/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class JasperLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection = null;
    private CodeSource codeSource = null;
    private String className = null;
    private ClassLoader parent = null;
    private SecurityManager securityManager = null;
    private PrivilegedLoadClass privLoadClass = null;

    JasperLoader(URL[] urls, String className, ClassLoader parent, PermissionCollection permissionCollection, CodeSource codeSource) {
        super(urls, parent);
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
        this.className = className;
        this.parent = parent;
        this.privLoadClass = new PrivilegedLoadClass();
        this.securityManager = System.getSecurityManager();
    }

    protected final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        int dot = name.lastIndexOf(46);
        if (System.getSecurityManager() != null && dot >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, dot));
            }
            catch (SecurityException securityException) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                System.out.println(error);
                throw new ClassNotFoundException(error);
            }
        }
        if (!name.startsWith("org.apache.jsp")) {
            ClassLoader classLoader = null;
            classLoader = System.getSecurityManager() != null ? (ClassLoader)AccessController.doPrivileged(this.privLoadClass) : Thread.currentThread().getContextClassLoader();
            clazz = classLoader.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (name.startsWith("org.apache.jsp." + this.className)) {
            String classFile = String.valueOf(name.substring("org.apache.jsp".length() + 1)) + ".class";
            byte[] cdata = this.loadClassDataFromFile(classFile);
            if (cdata == null) {
                throw new ClassNotFoundException(name);
            }
            if (System.getSecurityManager() != null) {
                ProtectionDomain pd = new ProtectionDomain(this.codeSource, this.permissionCollection);
                clazz = this.defineClass(name, cdata, 0, cdata.length, pd);
            } else {
                clazz = this.defineClass(name, cdata, 0, cdata.length);
            }
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected byte[] loadClassDataFromFile(String fileName) {
        byte[] classBytes = null;
        try {
            InputStream in = ((ClassLoader)this).getResourceAsStream(fileName);
            if (in == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                baos.write(buf, 0, i);
            }
            in.close();
            baos.close();
            classBytes = baos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return classBytes;
    }

    protected class PrivilegedLoadClass
    implements PrivilegedAction {
        PrivilegedLoadClass() {
        }

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

