/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.upgrade.InternalCopy;
import org.netbeans.core.upgrade.UpgradeProcessListener;
import org.netbeans.core.upgrade.UpgradeWizardSettings;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TransferSettingsPanel
extends JPanel
implements UpgradeProcessListener,
WizardDescriptor.Panel,
PropertyChangeListener {
    private Object lock = new Object();
    private JTextArea txtStatusSummary;
    private JProgressBar pbarProgress;
    private JLabel jLabel1;
    private JLabel lblStatus;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_FINISHED = 2;
    public static final int STATUS_ERRORS = 3;
    private static final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.core.upgrade.Bundle");
    private ArrayList changeListeners = new ArrayList(1);
    private LinkedList log = new LinkedList();
    private int progress = 0;
    private InternalCopy upgrader = null;
    private UpgradeWizardSettings settings = new UpgradeWizardSettings();
    private Timer tmr;
    private int status = 0;

    public TransferSettingsPanel() {
        this.initComponents();
        this.pbarProgress.setMinimum(0);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TransferSettingsPanel"));
        this.txtStatusSummary.getAccessibleContext().setAccessibleName(bundle.getString("ACS_txtUpgrade2_Bottom_Name"));
        this.txtStatusSummary.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_txtUpgrade2_Bottom_Desc"));
        this.upgrader = new InternalCopy();
        this.upgrader.addUpgradeProcessListener(this);
    }

    public int getStatus() {
        int n;
        Object object = this.lock;
        synchronized (object) {
            n = this.status;
        }
        return n;
    }

    private void setStatus(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.status = n;
        }
    }

    public void start() {
        this.setStatus(1);
        this.log.clear();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferSettingsPanel.this.progress = 0;
                TransferSettingsPanel.this.pbarProgress.setMaximum(1000);
                TransferSettingsPanel.this.lblStatus.setText(bundle.getString("MSG_Upgrade_Started"));
            }
        });
    }

    public void message(String string) {
        this.log.add(string);
    }

    public void done(final boolean bl) {
        this.setStatus(bl ? 2 : 3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                TransferSettingsPanel.this.pbarProgress.setValue(1000);
                TransferSettingsPanel.this.lblStatus.setText(bundle.getString("MSG_Upgrade_Finished"));
                if (bl) {
                    stringBuffer.append(bundle.getString("MSG_Upgrade_Succeeded"));
                } else {
                    Iterator iterator = TransferSettingsPanel.this.log.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        stringBuffer.append(string);
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("\n\n");
                    stringBuffer.append(bundle.getString("MSG_Upgrade_Failed"));
                }
                TransferSettingsPanel.this.txtStatusSummary.setText(stringBuffer.toString());
                TransferSettingsPanel.this.fireStateChanged();
            }
        });
    }

    public void progress(int n, int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferSettingsPanel.this.progress++;
                TransferSettingsPanel.this.pbarProgress.setValue((int)(980.0 - 980.0 / (double)TransferSettingsPanel.this.progress));
            }
        });
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return 2 == this.getStatus() || 3 == this.getStatus();
    }

    public void storeSettings(Object object) {
        ((UpgradeWizardSettings)object).read(this.settings);
    }

    public void readSettings(Object object) {
        this.settings.read((UpgradeWizardSettings)object);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        ((AbstractCollection)this.changeListeners).remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("WizardPanel_selected".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == this) {
            this.tmr = new Timer();
            this.tmr.schedule((TimerTask)new UpgradeStarter(this), 200L);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.lblStatus = new JLabel();
        this.pbarProgress = new JProgressBar();
        this.txtStatusSummary = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(550, 350));
        this.setName(bundle.getString("LBL_TransferSettingsPanel_Name"));
        this.setMinimumSize(new Dimension(500, 279));
        this.jLabel1.setText(bundle.getString("LBL_lblUpgradeStatus"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.lblStatus.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.lblStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pbarProgress, gridBagConstraints);
        this.txtStatusSummary.setWrapStyleWord(true);
        this.txtStatusSummary.setToolTipText(bundle.getString("ACS_txtUpgrade2_Bottom_Desc"));
        this.txtStatusSummary.setLineWrap(true);
        this.txtStatusSummary.setEditable(false);
        this.txtStatusSummary.setForeground(this.lblStatus.getForeground());
        this.txtStatusSummary.setBackground(this.lblStatus.getBackground());
        this.txtStatusSummary.setDisabledTextColor(this.lblStatus.getForeground());
        this.txtStatusSummary.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.txtStatusSummary, gridBagConstraints);
    }

    private void fireStateChanged() {
        int n = 0;
        while (n < this.changeListeners.size()) {
            ((ChangeListener)this.changeListeners.get(n)).stateChanged(new ChangeEvent(this));
            ++n;
        }
    }

    private void notify(String string, int n) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, n);
        TopManager.getDefault().notify((NotifyDescriptor)message);
    }

    static /* synthetic */ UpgradeWizardSettings access$900(TransferSettingsPanel transferSettingsPanel) {
        return transferSettingsPanel.settings;
    }

    static /* synthetic */ InternalCopy access$1000(TransferSettingsPanel transferSettingsPanel) {
        return transferSettingsPanel.upgrader;
    }

    private class UpgradeStarter
    extends TimerTask {
        private TransferSettingsPanel panel;

        public UpgradeStarter(TransferSettingsPanel transferSettingsPanel2) {
            this.panel = transferSettingsPanel2;
        }

        public void run() {
            TransferSettingsPanel.this.tmr.cancel();
            TransferSettingsPanel.this.tmr = null;
            Thread thread = new Thread(this){
                private final /* synthetic */ UpgradeStarter this$1;
                {
                    this.this$1 = upgradeStarter;
                }

                public void run() {
                    File file = new File(System.getProperty("netbeans.user", ""));
                    TransferSettingsPanel.access$1000(UpgradeStarter.access$800(this.this$1)).upgrade(TransferSettingsPanel.access$900(UpgradeStarter.access$800(this.this$1)).getIDEVersion(), TransferSettingsPanel.access$900(UpgradeStarter.access$800(this.this$1)).getIDELocation(), file);
                }
            };
            thread.start();
        }

        static /* synthetic */ TransferSettingsPanel access$800(UpgradeStarter upgradeStarter) {
            return upgradeStarter.TransferSettingsPanel.this;
        }
    }
}

