/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.SearchTypePanel;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

public class SearchPanel
extends JPanel
implements PropertyChangeListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;
    private JButton cancelButton;
    private Dialog dialog;
    private int returnStatus = 0;
    private List orderedSearchTypePanels;
    private boolean customized;
    private JTabbedPane tabbedPane;
    static /* synthetic */ Class class$org$netbeans$modules$search$SearchPanel;

    public SearchPanel(List list) {
        this(list, false);
    }

    public SearchPanel(List list, boolean bl) {
        Object[] objectArray;
        this.orderedSearchTypePanels = new ArrayList(list.size());
        this.customized = bl;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            SearchTypePanel searchTypePanel = new SearchTypePanel((SearchType)objectArray);
            if (this.orderedSearchTypePanels.contains(searchTypePanel)) continue;
            searchTypePanel.addPropertyChangeListener(this);
            this.orderedSearchTypePanels.add(searchTypePanel);
        }
        this.initComponents();
        iterator = this.orderedSearchTypePanels.iterator();
        while (iterator.hasNext()) {
            this.tabbedPane.add((Component)iterator.next());
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SearchPanel.this.tabbedPaneStateChanged(changeEvent);
            }
        });
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("TEXT_TITLE_CUSTOMIZE"));
        this.okButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("TEXT_BUTTON_SEARCH"));
        this.okButton.setEnabled(this.isCustomized());
        this.cancelButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("TEXT_BUTTON_CANCEL"));
        objectArray = new Object[]{this.okButton, this.cancelButton};
        this.initAccessibility();
        this.dialogDescriptor = new DialogDescriptor((Object)this, this.getName(), true, objectArray, objectArray[0], 0, this.getHelpCtx(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == SearchPanel.this.okButton) {
                    SearchPanel.this.doClose(1);
                } else {
                    SearchPanel.this.doClose(0);
                }
            }
        });
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACS_SearchPanel"));
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACSN_Tabs"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACSD_Tabs"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACS_TEXT_BUTTON_SEARCH"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACS_TEXT_BUTTON_CANCEL"));
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private List getOrderedSearchTypePanels() {
        return new ArrayList(this.orderedSearchTypePanels);
    }

    private String getTabText(int n) {
        try {
            return ((SearchTypePanel)this.getOrderedSearchTypePanels().get(n)).getName();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public SearchType[] getCustomizedSearchTypes() {
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
        Iterator iterator = this.orderedSearchTypePanels.iterator();
        while (iterator.hasNext()) {
            SearchTypePanel searchTypePanel = (SearchTypePanel)iterator.next();
            if (!searchTypePanel.isCustomized()) continue;
            arrayList.add(searchTypePanel.getSearchType());
        }
        return arrayList.toArray(new SearchType[arrayList.size()]);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int n) {
        this.returnStatus = n;
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog() {
        this.dialog = TopManager.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setModal(true);
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                Component component;
                int n = SearchPanel.this.tabbedPane.getSelectedIndex();
                if (n < 0) {
                    n = 0;
                }
                if ((component = SearchPanel.this.getTypeCustomizer(n)) != null) {
                    component.requestFocus();
                }
                SearchPanel.this.dialog.removeComponentListener(this);
            }
        });
        this.dialog.pack();
        this.dialog.show();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("customized".equals(propertyChangeEvent.getPropertyName())) {
            this.customized = this.getCustomizedSearchTypes().length != 0;
            this.okButton.setEnabled(this.isCustomized());
        }
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setTitleAt(n, this.getTabText(n));
            this.tabbedPane.setIconAt(n, null);
            ++n;
        }
    }

    private HelpCtx getHelpCtx() {
        int n = this.tabbedPane.getModel().getSelectedIndex();
        SearchTypePanel searchTypePanel = (SearchTypePanel)this.getOrderedSearchTypePanels().get(n);
        return searchTypePanel.getHelpCtx();
    }

    private Component getTypeCustomizer(int n) {
        SearchTypePanel searchTypePanel = null;
        Iterator iterator = this.getOrderedSearchTypePanels().iterator();
        while (n >= 0 && iterator.hasNext()) {
            searchTypePanel = (SearchTypePanel)iterator.next();
            --n;
        }
        return searchTypePanel != null ? searchTypePanel.getComponent() : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

