/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.search.RepositorySearchAction;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultViewTopComponent;
import org.netbeans.modules.search.SearchEngine;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.openide.TopManager;
import org.openide.actions.FindAction;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class SearchPerformer
implements ActionPerformer {
    private static SoftReference resultViewSRef = new SoftReference<Object>(null);
    private static SearchPerformer searchPerformer;
    private Lookup.Result result;
    static /* synthetic */ Class class$org$openidex$search$SearchType;

    private SearchPerformer() {
    }

    static synchronized SearchPerformer getDefault() {
        if (searchPerformer == null) {
            searchPerformer = new SearchPerformer();
        }
        return searchPerformer;
    }

    private Lookup.Result getSearchTypes() {
        if (this.result == null) {
            this.result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openidex$search$SearchType == null ? (class$org$openidex$search$SearchType = SearchPerformer.class$("org.openidex.search.SearchType")) : class$org$openidex$search$SearchType));
        }
        return this.result;
    }

    private List getTypes(Node[] nodeArray) {
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(5);
        if (nodeArray == null || nodeArray.length == 0) {
            return arrayList;
        }
        Iterator iterator = this.getSearchTypes().allInstances().iterator();
        while (iterator.hasNext()) {
            SearchType searchType = (SearchType)iterator.next();
            if (!searchType.enabled(nodeArray) || arrayList.contains(searchType)) continue;
            arrayList.add(searchType);
        }
        return arrayList;
    }

    public boolean enabled(Node[] nodeArray) {
        Iterator iterator = this.getSearchTypes().allInstances().iterator();
        while (iterator.hasNext()) {
            SearchType searchType = (SearchType)iterator.next();
            if (!searchType.enabled(nodeArray)) continue;
            return true;
        }
        return false;
    }

    private void performAction(Node[] nodeArray) {
        List list = this.getTypes(nodeArray);
        if (list.isEmpty()) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((SearchType)iterator.next()).clone());
        }
        SearchPanel searchPanel = new SearchPanel(arrayList);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() == 1) {
            ResultModel resultModel = this.performSearch(nodeArray, searchPanel, arrayList);
            ResultViewTopComponent resultViewTopComponent = (ResultViewTopComponent)resultViewSRef.get();
            if (resultViewTopComponent == null) {
                resultViewTopComponent = new ResultViewTopComponent(resultModel);
                resultViewSRef = new SoftReference<ResultViewTopComponent>(resultViewTopComponent);
            } else {
                resultViewTopComponent.setModel(resultModel);
            }
            Workspace workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
            Mode mode = workspace.findMode((TopComponent)resultViewTopComponent);
            if (mode == null) {
                mode = workspace.createMode("Search Results", ((Component)((Object)resultViewTopComponent)).getName(), null);
            }
            mode.dockInto((TopComponent)resultViewTopComponent);
            resultViewTopComponent.open();
            resultViewTopComponent.requestFocus();
        }
    }

    private ResultModel performSearch(Node[] nodeArray, SearchPanel searchPanel, List list) {
        SearchEngine searchEngine = new SearchEngine();
        SearchGroup[] searchGroupArray = SearchGroup.createSearchGroups((SearchType[])searchPanel.getCustomizedSearchTypes());
        SearchGroup searchGroup = null;
        if (searchGroupArray.length > 0) {
            searchGroup = searchGroupArray[0];
        }
        ResultModel resultModel = new ResultModel(list, searchGroup);
        SearchTask searchTask = searchEngine.search(nodeArray, searchGroup, resultModel);
        resultModel.setTask(searchTask);
        return resultModel;
    }

    public void performAction(SystemAction systemAction) {
        if (systemAction instanceof RepositorySearchAction) {
            RepositorySearchAction repositorySearchAction = (RepositorySearchAction)systemAction;
            this.performAction(repositorySearchAction.getNodes());
        } else if (systemAction instanceof FindAction) {
            this.performAction(TopComponent.getRegistry().getCurrentNodes());
        } else if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            throw new RuntimeException("Should not occure.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

