/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.DialogDescriptor;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openidex.search.SearchType;

public class SearchTypePanel
extends JPanel
implements PropertyChangeListener {
    public static final String PROP_CUSTOMIZED = "customized";
    private static final String MODIFICATOR_SUFFIX = " *";
    private boolean customized;
    private SearchType searchType;
    private BeanInfo beanInfo;
    private Customizer customizer;
    private Component customizerComponent;
    private String lastSavedName;
    private JPanel customizerPanel;
    private JButton restoreButton;
    private JButton saveButton;
    private JCheckBox applyCheckBox;
    static /* synthetic */ Class class$org$netbeans$modules$search$SearchTypePanel;

    public SearchTypePanel(SearchType searchType) {
        block4: {
            this.initComponents();
            this.initAccessibility();
            this.searchType = searchType;
            try {
                this.beanInfo = Utilities.getBeanInfo(this.searchType.getClass());
                if (this.hasCustomizer()) {
                    this.customizer = this.getCustomizer();
                    this.customizerComponent = (Component)((Object)this.customizer);
                } else {
                    System.err.println("No customizer for " + this.searchType.getName() + ", skipping...");
                }
            }
            catch (IntrospectionException introspectionException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block4;
                introspectionException.printStackTrace();
            }
        }
        this.customizer.setObject(this.searchType);
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        this.applyCheckBox.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_BUTTON_APPLY"));
        this.applyCheckBox.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_BUTTON_APPLY_MNEM").charAt(0));
        this.saveButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_BUTTON_SAVE_AS"));
        this.saveButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_BUTTON_SAVE_AS_MNEM").charAt(0));
        this.saveButton.setEnabled(false);
        this.restoreButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_BUTTON_RESTORE"));
        this.restoreButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_BUTTON_RESTORE_MNEM").charAt(0));
        this.customizerPanel.add(this.customizerComponent, "Center");
        this.setCustomized(this.searchType.isValid());
        this.setName(this.createName());
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("ACS_DIALOG_DESC"));
        this.restoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("ACS_TEXT_BUTTON_RESTORE"));
        this.saveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("ACS_TEXT_BUTTON_SAVE_AS"));
        this.applyCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("ACS_TEXT_BUTTON_APPLY"));
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.applyCheckBox = new JCheckBox();
        this.saveButton = new JButton();
        this.restoreButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.applyCheckBox.setText("jCheckBox2");
        this.applyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchTypePanel.this.applyCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 11, 0, 11);
        this.add((Component)this.applyCheckBox, gridBagConstraints);
        this.saveButton.setText("jButton3");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchTypePanel.this.saveButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.add((Component)this.saveButton, gridBagConstraints);
        this.restoreButton.setText("jButton4");
        this.restoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchTypePanel.this.restoreButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.restoreButton, gridBagConstraints);
    }

    private void restoreButtonActionPerformed(ActionEvent actionEvent) {
        this.restoreCriterion();
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        this.saveCriterion();
    }

    private void applyCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.applyCheckBox.isSelected();
        this.setCustomized(bl);
        this.searchType.setValid(bl);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.searchType && "org.openidex.search.valid".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue().equals(new Boolean(false))) {
                this.setCustomized(false);
                return;
            }
            this.setCustomized(true);
        }
    }

    private String createName() {
        String string = this.searchType.getName();
        if (this.customized) {
            return string + MODIFICATOR_SUFFIX;
        }
        return string;
    }

    private boolean hasCustomizer() {
        return this.beanInfo.getBeanDescriptor().getCustomizerClass() != null;
    }

    private Customizer getCustomizer() {
        Object obj;
        if (this.customizer != null) {
            return this.customizer;
        }
        Class<?> clazz = this.beanInfo.getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        if (!(obj instanceof Component) || !(obj instanceof Customizer)) {
            return null;
        }
        return (Customizer)obj;
    }

    public Component getComponent() {
        return this.customizerComponent;
    }

    private void setCustomized(boolean bl) {
        this.customized = bl;
        this.saveButton.setEnabled(this.customized);
        this.applyCheckBox.setSelected(this.customized);
        this.setName(this.createName());
        this.firePropertyChange(PROP_CUSTOMIZED, !bl, bl);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private void saveCriterion() {
        String string;
        block2: {
            block1: {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout(12, 0));
                JLabel jLabel = new JLabel(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_LABEL_NAME"));
                jLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_LABEL_NAME_MNEM").charAt(0));
                jPanel.add((Component)jLabel, "West");
                jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("ACS_SaveAsPanel"));
                JTextField jTextField = this.lastSavedName != null ? new JTextField(this.lastSavedName, 20) : new JTextField(20);
                jTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("ACS_TEXT_LABEL_SELECT"));
                jLabel.setLabelFor(jTextField);
                jPanel.add((Component)jTextField, "Center");
                jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_LABEL_SAVE_CRITERION"));
                Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
                do {
                    dialog.show();
                    Object object = dialogDescriptor.getValue();
                    if (!object.toString().equals("0")) break block1;
                } while ((string = jTextField.getText()).length() <= 0);
                break block2;
            }
            return;
        }
        this.saveSearchType(string);
        this.lastSavedName = string;
    }

    private boolean saveSearchType(String string) throws IllegalArgumentException {
        boolean bl;
        SearchType searchType = (SearchType)this.searchType.clone();
        searchType.setName(string);
        if (SearchTypePanel.existInRegistry(searchType)) {
            SearchTypePanel.removeFromRegistry(searchType);
            bl = false;
        } else {
            bl = true;
        }
        SearchTypePanel.appendToRegistry(searchType);
        return bl;
    }

    private void restoreCriterion() {
        String string;
        Object object;
        Object object2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(12, 0));
        jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("ACS_RestorePanel"));
        JLabel jLabel = new JLabel(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_LABEL_SELECT"));
        jLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_LABEL_SELECT_MNEM").charAt(0));
        jPanel.add((Component)jLabel, "West");
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(10);
        Enumeration enumeration = TopManager.getDefault().getServices().services(this.searchType.getClass());
        while (enumeration.hasMoreElements()) {
            object2 = (SearchType)enumeration.nextElement();
            object = object2.getName();
            if (object == null) continue;
            if (((String)object).equals(this.searchType.getName())) {
                hashMap.put(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel") : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_DEFAULT_CRITERION"), object2);
                continue;
            }
            hashMap.put(object, object2);
        }
        object2 = new JComboBox<Object>(hashMap.keySet().toArray());
        object = ((JComponent)object2).getPreferredSize();
        ((Dimension)object).width = 160;
        ((JComponent)object2).setPreferredSize((Dimension)object);
        jLabel.setLabelFor((Component)object2);
        jPanel.add((Component)object2, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchTypePanel == null ? (class$org$netbeans$modules$search$SearchTypePanel = SearchTypePanel.class$("org.netbeans.modules.search.SearchTypePanel")) : class$org$netbeans$modules$search$SearchTypePanel)).getString("TEXT_LABEL_RESTORE_CRITERION"));
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue().toString().equals("0") && (string = (String)((JComboBox)object2).getSelectedItem()) != null) {
            this.restoreSearchType((SearchType)hashMap.get(string));
        }
    }

    private void restoreSearchType(SearchType searchType) {
        this.searchType.removePropertyChangeListener((PropertyChangeListener)this);
        this.searchType = (SearchType)searchType.clone();
        this.getCustomizer().setObject(this.searchType);
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        this.setCustomized(true);
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public boolean equals(Object object) {
        try {
            return this.searchType.getClass().equals(((SearchTypePanel)object).getSearchType().getClass());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.searchType.getHelpCtx();
    }

    private static boolean existInRegistry(SearchType searchType) {
        ServiceType.Registry registry = TopManager.getDefault().getServices();
        Enumeration enumeration = registry.services(searchType.getClass());
        while (enumeration.hasMoreElements()) {
            SearchType searchType2 = (SearchType)enumeration.nextElement();
            if (!searchType2.getName().equals(searchType.getName())) continue;
            return true;
        }
        return false;
    }

    private static void appendToRegistry(SearchType searchType) {
        ServiceType.Registry registry = TopManager.getDefault().getServices();
        List list = registry.getServiceTypes();
        list.add(searchType);
        registry.setServiceTypes(list);
    }

    private static void removeFromRegistry(SearchType searchType) {
        ServiceType.Registry registry = TopManager.getDefault().getServices();
        List list = registry.getServiceTypes();
        ArrayList<ServiceType> arrayList = new ArrayList<ServiceType>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceType serviceType = (ServiceType)iterator.next();
            if (serviceType.getName().equals(searchType.getName()) && serviceType.getClass().equals(searchType.getClass())) continue;
            arrayList.add(serviceType);
        }
        registry.setServiceTypes(arrayList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

