/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.netbeans.modules.search.types.DataObjectType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;

public class ModificationDateType
extends DataObjectType {
    static final long serialVersionUID = 4L;
    private Date matchBefore;
    private Date matchAfter;
    private Short days;
    static /* synthetic */ Class class$org$netbeans$modules$search$types$ModificationDateType;

    public boolean testDataObject(DataObject dataObject) {
        boolean bl;
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject == null) {
            return false;
        }
        Date date = fileObject.lastModified();
        boolean bl2 = bl = this.testDays(date) && this.testAfter(date) && this.testBefore(date);
        return bl;
    }

    private boolean testAfter(Date date) {
        if (this.matchAfter == null) {
            return true;
        }
        return date.compareTo(this.matchAfter) >= 0;
    }

    private boolean testBefore(Date date) {
        if (this.matchBefore == null) {
            return true;
        }
        return date.compareTo(this.matchBefore) <= 0;
    }

    private boolean testDays(Date date) {
        if (this.days == null) {
            return true;
        }
        return System.currentTimeMillis() - date.getTime() < (long)this.days.shortValue() * 1000L * 60L * 60L * 24L;
    }

    public Date getMatchBeforeAsDate() {
        return new FormattedDate(this.matchBefore);
    }

    public String getMatchBefore() {
        if (this.matchBefore == null) {
            return "";
        }
        return this.getMatchBeforeAsDate().toString();
    }

    public void setMatchBefore(String string) {
        try {
            this.setMatchBeforeImpl(string);
            this.setValid(this.matchBefore != null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setValid(false);
            throw illegalArgumentException;
        }
    }

    private void setMatchBeforeImpl(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("")) {
            this.setMatchBeforeByDate(null);
            return;
        }
        try {
            this.setMatchBeforeByDate(new FormattedDate(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException();
        }
    }

    public void setMatchBeforeByDate(Date date) {
        Comparable<Date> comparable;
        if (date != null) {
            comparable = new GregorianCalendar();
            ((Calendar)comparable).setTime(date);
            ((Calendar)comparable).set(11, ((GregorianCalendar)comparable).getActualMaximum(11));
            ((Calendar)comparable).set(12, ((GregorianCalendar)comparable).getActualMaximum(12));
            ((Calendar)comparable).set(13, ((GregorianCalendar)comparable).getActualMaximum(13));
            ((Calendar)comparable).set(14, ((GregorianCalendar)comparable).getActualMaximum(14));
            date = ((Calendar)comparable).getTime();
        }
        comparable = this.matchBefore;
        this.matchBefore = date;
        this.days = null;
    }

    public Date getMatchAfterAsDate() {
        return new FormattedDate(this.matchAfter);
    }

    public String getMatchAfter() {
        if (this.matchAfter == null) {
            return "";
        }
        return this.getMatchAfterAsDate().toString();
    }

    public void setMatchAfter(String string) {
        try {
            this.setMatchAfterImpl(string);
            this.setValid(this.matchAfter != null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setValid(false);
            throw illegalArgumentException;
        }
    }

    private void setMatchAfterImpl(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("")) {
            this.setMatchAfterByDate(null);
            return;
        }
        try {
            this.setMatchAfterByDate(new FormattedDate(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException();
        }
    }

    public void setMatchAfterByDate(Date date) {
        Comparable<Date> comparable;
        if (date != null) {
            comparable = new GregorianCalendar();
            ((Calendar)comparable).setTime(date);
            ((Calendar)comparable).set(11, ((GregorianCalendar)comparable).getActualMinimum(11));
            ((Calendar)comparable).set(12, ((GregorianCalendar)comparable).getActualMinimum(12));
            ((Calendar)comparable).set(13, ((GregorianCalendar)comparable).getActualMinimum(13));
            ((Calendar)comparable).set(14, ((GregorianCalendar)comparable).getActualMinimum(14));
            date = ((Calendar)comparable).getTime();
        }
        comparable = this.matchAfter;
        this.matchAfter = date;
        this.days = null;
    }

    public Short getDaysAsShort() {
        return this.days;
    }

    public String getDays() {
        if (this.days == null) {
            return "";
        }
        return this.days.toString();
    }

    public void setDays(String string) {
        try {
            this.setDaysImpl(string);
            this.setValid(this.days != null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setValid(false);
            throw illegalArgumentException;
        }
    }

    private void setDaysImpl(String string) {
        if ("".equals(string)) {
            this.setDaysByShort(null);
            return;
        }
        try {
            DecimalFormat decimalFormat = new DecimalFormat();
            this.setDaysByShort(new Short(decimalFormat.parse(string).shortValue()));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException();
        }
    }

    private void setDaysByShort(Short s) {
        Short s2 = this.days;
        this.days = s;
        this.matchAfter = null;
        this.matchBefore = null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$search$types$ModificationDateType == null ? (class$org$netbeans$modules$search$types$ModificationDateType = ModificationDateType.class$("org.netbeans.modules.search.types.ModificationDateType")) : class$org$netbeans$modules$search$types$ModificationDateType);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class FormattedDate
    extends Date {
        private static DateFormat format;
        private transient boolean isNull = true;

        public FormattedDate(Date date) {
            super(date == null ? new Date().getTime() : date.getTime());
            this.isNull = date == null;
        }

        public FormattedDate(String string) throws ParseException {
            super(format.parse(string).getTime());
            this.isNull = string == null;
        }

        public String toString() {
            return format.format(this);
        }

        public boolean equals(Object object) {
            if (object == null && this.isNull) {
                return true;
            }
            return super.equals(object);
        }

        static {
            new SimpleDateFormat();
            format = DateFormat.getDateInstance();
        }
    }
}

