/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.search.types.DataObjectType;

public abstract class TextType
extends DataObjectType {
    static final long serialVersionUID = 3L;
    protected String matchString;
    protected String ciMatchString;
    protected boolean caseSensitive;
    protected boolean wholeWords;
    private static String wordSeparators = " \t,;.:+-*/\\()[]{}<>=&|\"'`~!?@#%^\n\r";
    protected transient RE re;
    protected String reString;

    protected boolean match(String string) {
        return this.matchString(string, 0) >= 0 && this.matchRE(string);
    }

    protected boolean matchRE(String string) {
        if (this.re == null) {
            return true;
        }
        return this.re.match(string);
    }

    protected int matchString(String string, int n) {
        int n2;
        if (this.matchString == null) {
            return 0;
        }
        int n3 = n2 = this.caseSensitive ? string.indexOf(this.matchString, n) : string.toUpperCase().indexOf(this.ciMatchString, n);
        if (this.wholeWords && n2 >= 0) {
            if (n2 > 0 && wordSeparators.indexOf(string.charAt(n2 - 1)) < 0) {
                n2 = -1;
            } else {
                int n4 = this.matchString.length();
                if (n2 + n4 < string.length() && wordSeparators.indexOf(string.charAt(n2 + n4)) < 0) {
                    n2 = -1;
                }
            }
        }
        return n2;
    }

    public String getMatchString() {
        if (this.matchString == null) {
            return "";
        }
        return this.matchString;
    }

    public void setMatchString(String string) {
        if (string == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (string.equals("")) {
            string = null;
        }
        String string2 = this.matchString;
        this.matchString = string;
        if (!this.caseSensitive && string != null) {
            this.ciMatchString = string.toUpperCase();
        }
        this.re = null;
        this.reString = null;
        this.setValid(string != null);
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        boolean bl2 = this.caseSensitive;
        this.caseSensitive = bl;
        if (!bl && this.matchString != null) {
            this.ciMatchString = this.matchString.toUpperCase();
        }
    }

    public boolean getWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean bl) {
        boolean bl2 = this.wholeWords;
        this.wholeWords = bl;
    }

    public String getRe() {
        if (this.reString == null) {
            return "";
        }
        return this.reString;
    }

    public void setRe(String string) {
        this.setReImpl(string);
    }

    private void setReImpl(String string) {
        if (string == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        String string2 = this.reString;
        if ("".equals(string)) {
            this.reString = null;
            string = null;
            this.matchString = null;
            this.setValid(false);
            return;
        }
        try {
            this.re = new RE(string);
            this.reString = string;
            this.matchString = null;
            this.setValid(true);
        }
        catch (RESyntaxException rESyntaxException) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
    }
}

