/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.PrintContainer;

interface DrawGraphics {
    public void setForeColor(Color var1);

    public void setBackColor(Color var1);

    public void setDefaultBackColor(Color var1);

    public void setStrikeThroughColor(Color var1);

    public void setUnderlineColor(Color var1);

    public void setWaveUnderlineColor(Color var1);

    public void setFont(Font var1);

    public void setX(int var1);

    public void setY(int var1);

    public void setLineHeight(int var1);

    public void setLineAscent(int var1);

    public Graphics getGraphics();

    public boolean supportsLineNumbers();

    public void init(DrawContext var1);

    public void finish();

    public void fillRect(int var1);

    public void drawChars(int var1, int var2, int var3);

    public void drawTabs(int var1, int var2, int var3, int var4);

    public void setBuffer(char[] var1);

    public boolean targetOffsetReached(int var1, char var2, int var3, int var4, DrawContext var5);

    public void eol();

    public static final class PrintDG
    extends SimpleDG {
        PrintContainer container;
        boolean lineInited;

        public PrintDG(PrintContainer printContainer) {
            this.container = printContainer;
        }

        public boolean supportsLineNumbers() {
            return true;
        }

        public void drawChars(int n, int n2, int n3) {
            if (n2 > 0) {
                char[] cArray = new char[n2];
                System.arraycopy(this.buffer, n, cArray, 0, n2);
                this.container.add(cArray, this.font, this.foreColor, this.backColor);
            }
        }

        private void printSpaces(int n) {
            char[] cArray = new char[n];
            System.arraycopy(Analyzer.getSpacesBuffer(n), 0, cArray, 0, n);
            this.container.add(cArray, this.font, this.foreColor, this.backColor);
        }

        public void drawTabs(int n, int n2, int n3, int n4) {
            this.printSpaces(n3);
        }

        public void eol() {
            if (!this.lineInited && this.container.initEmptyLines()) {
                this.printSpaces(1);
            }
            this.container.eol();
            this.lineInited = false;
        }
    }

    public static final class GraphicsDG
    extends SimpleDG {
        private Graphics graphics;
        private Color gColor;
        private Font gFont;
        private int startOffset = -1;
        private int endOffset;
        private int startX;
        private int startY;
        private int width;
        private Color strikeThroughColor;
        private Color underlineColor;
        private Color waveUnderlineColor;
        private AlphaComposite alpha = null;
        private Annotations annos = null;

        GraphicsDG(Graphics graphics) {
            this.graphics = graphics;
        }

        public void setForeColor(Color color) {
            if (!color.equals(this.foreColor)) {
                this.flush();
                this.foreColor = color;
            }
        }

        public void setBackColor(Color color) {
            if (!color.equals(this.backColor)) {
                this.flush();
                this.backColor = color;
            }
        }

        public void setStrikeThroughColor(Color color) {
            if (!(color == this.strikeThroughColor || color != null && color.equals(this.strikeThroughColor))) {
                this.flush();
                this.strikeThroughColor = color;
            }
        }

        public void setUnderlineColor(Color color) {
            if (!(color == this.underlineColor || color != null && color.equals(this.underlineColor))) {
                this.flush();
                this.underlineColor = color;
            }
        }

        public void setWaveUnderlineColor(Color color) {
            if (!(color == this.waveUnderlineColor || color != null && color.equals(this.waveUnderlineColor))) {
                this.flush();
                this.waveUnderlineColor = color;
            }
        }

        public void setFont(Font font) {
            if (!font.equals(this.font)) {
                this.flush();
                this.font = font;
            }
        }

        public void setX(int n) {
            if (n != this.x) {
                this.flush();
                this.x = n;
            }
        }

        public void setY(int n) {
            if (n != this.y) {
                this.flush();
                this.y = n;
            }
        }

        public void init(DrawContext drawContext) {
            JTextComponent jTextComponent = drawContext.getEditorUI().getComponent();
            this.gColor = this.graphics.getColor();
            this.gFont = this.graphics.getFont();
            this.annos = drawContext.getEditorUI().getDocument().getAnnotations();
        }

        public void finish() {
            this.flush();
        }

        private void flush() {
            Object object;
            if (this.startOffset < 0) {
                return;
            }
            if (this.startOffset == this.endOffset) {
                this.startOffset = -1;
                return;
            }
            this.fillRectImpl(this.startX, this.startY, this.x - this.startX);
            if (AnnotationTypes.getTypes().isBackgroundDrawing().booleanValue()) {
                if (this.alpha == null) {
                    this.alpha = AlphaComposite.getInstance(3, (float)AnnotationTypes.getTypes().getBackgroundGlyphAlpha().intValue() / 100.0f);
                }
                object = this.annos.getPasiveAnnotations((int)((float)this.startY / (float)this.lineHeight));
                int n = 2;
                if (object != null) {
                    Graphics2D graphics2D = (Graphics2D)this.graphics;
                    Shape shape = this.graphics.getClip();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(this.alpha);
                    Rectangle rectangle = new Rectangle(this.startX, this.startY, this.x - this.startX, this.lineHeight);
                    rectangle = rectangle.intersection(shape.getBounds());
                    this.graphics.setClip(rectangle);
                    int n2 = 0;
                    while (n2 < ((Object)object).length) {
                        graphics2D.drawImage(((AnnotationDesc)object[n2]).getGlyph(), n, this.startY, null);
                        n += ((AnnotationDesc)object[n2]).getGlyph().getWidth(null) + 1;
                        ++n2;
                    }
                    this.graphics.setClip(shape);
                    graphics2D.setComposite(composite);
                }
            }
            if (this.foreColor != this.gColor) {
                this.graphics.setColor(this.foreColor);
                this.gColor = this.foreColor;
            }
            if (this.font != this.gFont) {
                this.graphics.setFont(this.font);
                this.gFont = this.font;
            }
            this.graphics.drawChars(this.buffer, this.startOffset, this.endOffset - this.startOffset, this.startX, this.startY + this.lineAscent);
            if (this.strikeThroughColor != null) {
                object = FontMetricsCache.getInfo(this.font);
                if (this.strikeThroughColor != this.gColor) {
                    this.graphics.setColor(this.strikeThroughColor);
                    this.gColor = this.strikeThroughColor;
                }
                this.graphics.fillRect(this.startX, this.startY + (int)((double)object.getStrikethroughOffset(this.graphics) + 0.5), this.x - this.startX, (int)((double)object.getStrikethroughThickness(this.graphics) + 0.5));
            }
            if (this.waveUnderlineColor != null) {
                object = FontMetricsCache.getInfo(this.font);
                if (this.waveUnderlineColor != this.gColor) {
                    this.graphics.setColor(this.waveUnderlineColor);
                    this.gColor = this.waveUnderlineColor;
                }
                int[] nArray = new int[]{0, 1, 0, -1};
                int n = this.startX;
                int n3 = (int)((double)((float)this.startY + object.getUnderlineOffset(this.graphics) + (float)this.lineAscent + 1.0f) + 0.5);
                while (n <= this.x) {
                    this.graphics.drawLine(n, n3 + nArray[n % 4], n + 1, n3 + nArray[(n + 1) % 4]);
                    ++n;
                }
            }
            if (this.underlineColor != null) {
                object = FontMetricsCache.getInfo(this.font);
                if (this.underlineColor != this.gColor) {
                    this.graphics.setColor(this.underlineColor);
                    this.gColor = this.underlineColor;
                }
                this.graphics.fillRect(this.startX, this.startY + (int)((double)object.getUnderlineOffset(this.graphics) + 1.5), this.x - this.startX, (int)((double)object.getUnderlineThickness(this.graphics) + 0.5));
            }
            this.startOffset = -1;
        }

        public Graphics getGraphics() {
            return this.graphics;
        }

        public boolean supportsLineNumbers() {
            return true;
        }

        public void fillRect(int n) {
            this.fillRectImpl(this.x, this.y, n);
            this.x += n;
        }

        private void fillRectImpl(int n, int n2, int n3) {
            if (n3 > 0 && !this.backColor.equals(this.defaultBackColor)) {
                if (this.backColor != this.gColor) {
                    this.graphics.setColor(this.backColor);
                    this.gColor = this.backColor;
                }
                this.graphics.fillRect(n, n2, n3, this.lineHeight);
            }
        }

        public void drawChars(int n, int n2, int n3) {
            if (n2 >= 0) {
                if (this.startOffset < 0) {
                    this.startOffset = n;
                    this.endOffset = n + n2;
                    this.startX = this.x;
                    this.startY = this.y;
                    this.width = n3;
                } else {
                    this.endOffset += n2;
                }
            }
            this.x += n3;
        }

        public void drawTabs(int n, int n2, int n3, int n4) {
            if (n4 > 0) {
                this.flush();
                this.fillRectImpl(this.x, this.y, n4);
                this.x += n4;
            }
        }

        public void setBuffer(char[] cArray) {
            this.flush();
            this.buffer = cArray;
            this.startOffset = -1;
        }

        public void eol() {
            this.flush();
        }
    }

    public static class SimpleDG
    extends AbstractDG {
        public Graphics getGraphics() {
            return null;
        }

        public boolean supportsLineNumbers() {
            return false;
        }

        public void init(DrawContext drawContext) {
        }

        public void finish() {
        }

        public void fillRect(int n) {
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            return true;
        }

        public void eol() {
        }
    }

    public static abstract class AbstractDG
    implements DrawGraphics {
        Color foreColor;
        Color backColor;
        Color defaultBackColor;
        Font font;
        char[] buffer;
        int x;
        int y;
        int lineHeight;
        int lineAscent;

        public Color getForeColor() {
            return this.foreColor;
        }

        public void setForeColor(Color color) {
            this.foreColor = color;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public void setBackColor(Color color) {
            this.backColor = color;
        }

        public Color getDefaultBackColor() {
            return this.defaultBackColor;
        }

        public void setDefaultBackColor(Color color) {
            this.defaultBackColor = color;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int n) {
            this.y = n;
        }

        public int getLineHeight() {
            return this.lineHeight;
        }

        public void setLineHeight(int n) {
            this.lineHeight = n;
        }

        public int getLineAscent() {
            return this.lineAscent;
        }

        public void setLineAscent(int n) {
            this.lineAscent = n;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public void setBuffer(char[] cArray) {
            this.buffer = cArray;
        }

        public void drawChars(int n, int n2, int n3) {
            this.x += n3;
        }

        public void drawTabs(int n, int n2, int n3, int n4) {
            this.x += n4;
        }

        public void setStrikeThroughColor(Color color) {
        }

        public void setUnderlineColor(Color color) {
        }

        public void setWaveUnderlineColor(Color color) {
        }

        public abstract void eol();

        public abstract boolean targetOffsetReached(int var1, char var2, int var3, int var4, DrawContext var5);

        public abstract void fillRect(int var1);

        public abstract void finish();

        public abstract void init(DrawContext var1);

        public abstract boolean supportsLineNumbers();

        public abstract Graphics getGraphics();
    }
}

