/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.openide.TopManager;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class TestCreator {
    private static final String JUNIT_SUPER_CLASS_NAME = "TestCase";
    private static final String JUNIT_FRAMEWORK_PACKAGE_NAME = "junit.framework";
    private static final String NBJUNIT_SUPER_CLASS_NAME = "NbTestCase";
    private static final String NBJUNIT_EXTENSION_PACKAGE_NAME = "org.netbeans.junit";
    private static final String[] forbidenMethods = new String[]{"main", "suite", "setUp"};
    private static final String SUIT_BLOCK_START = "--JUNIT:";
    private static final String SUIT_BLOCK_END = ":JUNIT--";
    private static final String SUIT_BLOCK_COMMENT = "//This block was automatically generated and can be regenerated again.\n//Do NOT change lines enclosed by the --JUNIT: and :JUNIT-- tags.\n";
    private static final String SUIT_RETURN_COMMENT = "//This value MUST ALWAYS be returned from this function.\n";
    private static boolean cfg_MethodsFilterPackage = true;
    private static int cfg_MethodsFilter = 5;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    private static String arrayToString(Object[] objectArray) {
        String string = objectArray.getClass().getName() + ":";
        int n = 0;
        while (n < objectArray.length) {
            string = string + objectArray[n] + " ";
            ++n;
        }
        return string;
    }

    public static void createTestClass(ClassElement classElement, ClassElement classElement2) throws SourceException {
        SourceElement sourceElement = classElement.getSource();
        SourceElement sourceElement2 = classElement2.getSource();
        sourceElement2.setPackage(sourceElement.getPackage());
        sourceElement2.addImports(sourceElement.getImports());
        sourceElement2.addImport(new Import(Identifier.create((String)JUNIT_FRAMEWORK_PACKAGE_NAME), true));
        Import import_ = new Import(Identifier.create((String)NBJUNIT_EXTENSION_PACKAGE_NAME), true);
        if (JUnitSettings.getDefault().isGenerateNbJUnit()) {
            sourceElement2.addImport(import_);
        } else {
            sourceElement2.removeImport(import_);
        }
        TestCreator.fillTestClass(classElement, classElement2);
    }

    public static void createTestSuit(LinkedList linkedList, String string, ClassElement classElement) throws SourceException {
        SourceElement sourceElement = classElement.getSource();
        sourceElement.setPackage(string.length() != 0 ? Identifier.create((String)string) : null);
        sourceElement.addImport(new Import(Identifier.create((String)JUNIT_FRAMEWORK_PACKAGE_NAME), true));
        Import import_ = new Import(Identifier.create((String)NBJUNIT_EXTENSION_PACKAGE_NAME), true);
        if (JUnitSettings.getDefault().isGenerateNbJUnit()) {
            sourceElement.addImport(import_);
        } else {
            sourceElement.removeImport(import_);
        }
        TestCreator.fillSuitClass(linkedList, string, classElement);
    }

    public static void initialize() {
        cfg_MethodsFilter = 0;
        cfg_MethodsFilterPackage = JUnitSettings.getDefault().isMembersPackage();
        if (JUnitSettings.getDefault().isMembersProtected()) {
            cfg_MethodsFilter |= 4;
        }
        if (JUnitSettings.getDefault().isMembersPublic()) {
            cfg_MethodsFilter |= 1;
        }
    }

    public static boolean isClassTestable(ClassElement classElement) {
        if (!(null == classElement || !classElement.isClass() || 0 == (classElement.getModifiers() & 1) || !JUnitSettings.getDefault().isGenerateExceptionClasses() && TestCreator.isException(classElement) || classElement.isInner() && 0 == (classElement.getModifiers() & 8) || 0 != (classElement.getModifiers() & 0x400) && !JUnitSettings.getDefault().isGenerateAbstractImpl() || !TestCreator.hasTestableMethods(classElement))) {
            return true;
        }
        if (classElement.isInner() && 0 == (classElement.getModifiers() & 8)) {
            return false;
        }
        ClassElement[] classElementArray = classElement.getClasses();
        int n = 0;
        while (n < classElementArray.length) {
            if (TestCreator.isClassTestable(classElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void addMethods(ClassElement classElement, LinkedList linkedList) {
        if (null == linkedList) {
            return;
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            MethodElement methodElement = (MethodElement)listIterator.next();
            try {
                classElement.addMethod(methodElement);
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
        }
    }

    private static MethodElement createMainMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)"main"));
        methodElement.setModifiers(9);
        methodElement.setReturn(Type.VOID);
        MethodParameter[] methodParameterArray = new MethodParameter[]{new MethodParameter("args", Type.createArray((Type)Type.createFromClass((Class)(class$java$lang$String == null ? (class$java$lang$String = TestCreator.class$("java.lang.String")) : class$java$lang$String))), false)};
        methodElement.setParameters(methodParameterArray);
        methodElement.setBody("\njunit.textui.TestRunner.run(suite());\n");
        return methodElement;
    }

    private static MethodElement createTestClassSuiteMethod(ClassElement classElement) throws SourceException {
        StringBuffer stringBuffer = new StringBuffer(512);
        if (JUnitSettings.getDefault().isRegenerateSuiteMethod()) {
            TestCreator.removeSuiteMethod(classElement);
        }
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)"suite"));
        methodElement.setModifiers(9);
        methodElement.setReturn(Type.createClass((Identifier)Identifier.create((String)"Test")));
        if (JUnitSettings.getDefault().isGenerateNbJUnit()) {
            stringBuffer.append("\nTestSuite suite = new NbTestSuite(");
        } else {
            stringBuffer.append("\nTestSuite suite = new TestSuite(");
        }
        stringBuffer.append(classElement.getName().getName());
        stringBuffer.append(".class);\n");
        ClassElement[] classElementArray = classElement.getClasses();
        int n = 0;
        while (n < classElementArray.length) {
            stringBuffer.append("suite.addTest(");
            stringBuffer.append(classElementArray[n].getName().getName());
            stringBuffer.append(".suite());\n");
            ++n;
        }
        stringBuffer.append("\nreturn suite;\n");
        methodElement.setBody(stringBuffer.toString());
        return methodElement;
    }

    private static ConstructorElement createTestConstructor(Identifier identifier) throws SourceException {
        ConstructorElement constructorElement = new ConstructorElement();
        constructorElement.setName(identifier);
        constructorElement.setModifiers(1);
        MethodParameter[] methodParameterArray = new MethodParameter[]{new MethodParameter("testName", Type.createFromClass((Class)(class$java$lang$String == null ? (class$java$lang$String = TestCreator.class$("java.lang.String")) : class$java$lang$String)), false)};
        constructorElement.setParameters(methodParameterArray);
        constructorElement.setBody("\nsuper(testName);\n");
        return constructorElement;
    }

    private static LinkedList createVariantMethods(ClassElement classElement) throws SourceException {
        LinkedList<MethodElement> linkedList = new LinkedList<MethodElement>();
        MethodElement[] methodElementArray = classElement.getMethods();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < methodElementArray.length) {
            if (TestCreator.isMethodAcceptable(methodElementArray[n])) {
                String string = methodElementArray[n].getName().getName();
                MethodElement methodElement = new MethodElement();
                Identifier identifier = Identifier.create((String)("test" + string.substring(0, 1).toUpperCase() + string.substring(1)));
                if (!TestCreator.existsMethod(linkedList, identifier)) {
                    methodElement.setName(identifier);
                    methodElement.setModifiers(1);
                    if (JUnitSettings.getDefault().isJavaDoc()) {
                        methodElement.getJavaDoc().setText("Test of " + string + " method, of class " + classElement.getName().getFullName() + ".");
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append("\n");
                    if (JUnitSettings.getDefault().isBodyContent()) {
                        stringBuffer.append("System.out.println(\"" + identifier.getName() + "\");\n");
                    }
                    if (JUnitSettings.getDefault().isBodyComments()) {
                        stringBuffer.append("\n// Add your test code below by replacing the default call to fail.\n");
                    }
                    if (JUnitSettings.getDefault().isBodyContent()) {
                        stringBuffer.append("fail(\"The test case is empty.\");\n");
                    }
                    methodElement.setBody(stringBuffer.toString());
                    methodElement.setReturn(Type.VOID);
                    linkedList.add(methodElement);
                }
            }
            ++n;
        }
        return linkedList;
    }

    private static boolean existsMethod(LinkedList linkedList, Identifier identifier) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            MethodElement methodElement = (MethodElement)listIterator.next();
            if (!methodElement.getName().equals((Object)identifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean isImplemented(ClassElement classElement, MethodElement methodElement) {
        MethodElement[] methodElementArray = classElement.getMethods();
        int n = 0;
        while (n < methodElementArray.length) {
            if (0 == (methodElementArray[n].getModifiers() & 0x400) && methodElement.getName().equals((Object)methodElementArray[n].getName()) && methodElement.getReturn().equals((Object)methodElementArray[n].getReturn()) && Arrays.equals(TestCreator.getParameterTypes(methodElement.getParameters()), TestCreator.getParameterTypes(methodElementArray[n].getParameters()))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static Type[] getParameterTypes(MethodParameter[] methodParameterArray) {
        Type[] typeArray = new Type[methodParameterArray.length];
        int n = 0;
        while (n < methodParameterArray.length) {
            typeArray[n] = methodParameterArray[n].getType();
            ++n;
        }
        return typeArray;
    }

    private static boolean hasTestableMethods(ClassElement classElement) {
        MethodElement[] methodElementArray = classElement.getMethods();
        int n = 0;
        while (n < methodElementArray.length) {
            if (TestCreator.isMethodAcceptable(methodElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void fillGeneral(ClassElement classElement) throws SourceException {
        if (JUnitSettings.getDefault().isGenerateNbJUnit()) {
            classElement.setSuperclass(Identifier.create((String)NBJUNIT_SUPER_CLASS_NAME));
        } else {
            classElement.setSuperclass(Identifier.create((String)JUNIT_SUPER_CLASS_NAME));
        }
        classElement.setModifiers(1);
        ConstructorElement constructorElement = classElement.getConstructor(new Type[0]);
        if (null != constructorElement) {
            classElement.removeConstructor(constructorElement);
        }
        constructorElement = TestCreator.createTestConstructor(classElement.getName());
        try {
            classElement.addConstructor(constructorElement);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    private static void fillTestClass(ClassElement classElement, ClassElement classElement2) throws SourceException {
        TestCreator.fillGeneral(classElement2);
        ClassElement[] classElementArray = classElement.getClasses();
        int n = 0;
        while (n < classElementArray.length) {
            if (TestCreator.isClassTestable(classElementArray[n])) {
                Identifier identifier = Identifier.create((String)TestUtil.getTestClassName(classElementArray[n].getName().getName()));
                boolean bl = false;
                ClassElement classElement3 = classElement2.getClass(identifier);
                if (null == classElement3) {
                    bl = true;
                    classElement3 = new ClassElement();
                    classElement3.setName(identifier);
                }
                TestCreator.fillTestClass(classElementArray[n], classElement3);
                classElement3.setModifiers(classElement3.getModifiers() | 8);
                if (bl) {
                    classElement2.addClass(classElement3);
                }
            }
            ++n;
        }
        LinkedList linkedList = new LinkedList();
        linkedList.add(TestCreator.createMainMethod());
        linkedList.add(TestCreator.createTestClassSuiteMethod(classElement2));
        TestCreator.addMethods(classElement2, linkedList);
        linkedList = TestCreator.createVariantMethods(classElement);
        TestCreator.addMethods(classElement2, linkedList);
        if (JUnitSettings.getDefault().isGenerateAbstractImpl() && 0 != (classElement.getModifiers() & 0x400)) {
            try {
                TestCreator.createAbstractImpl(classElement, classElement2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void fillSuitClass(LinkedList linkedList, String string, ClassElement classElement) throws SourceException {
        MethodElement methodElement;
        TestCreator.fillGeneral(classElement);
        LinkedList<MethodElement> linkedList2 = new LinkedList<MethodElement>();
        linkedList2.add(TestCreator.createMainMethod());
        if (JUnitSettings.getDefault().isRegenerateSuiteMethod()) {
            TestCreator.removeSuiteMethod(classElement);
        }
        if (null == (methodElement = classElement.getMethod(Identifier.create((String)"suite"), new Type[0]))) {
            methodElement = new MethodElement();
            methodElement.setName(Identifier.create((String)"suite"));
        }
        methodElement.setModifiers(9);
        methodElement.setReturn(Type.createClass((Identifier)Identifier.create((String)"Test")));
        StringTokenizer stringTokenizer = new StringTokenizer(methodElement.getBody(), "\n");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (-1 != string2.indexOf(SUIT_BLOCK_START)) {
                bl = true;
                continue;
            }
            if (-1 != string2.indexOf(SUIT_BLOCK_END)) {
                bl = false;
                TestCreator.generateSuitBody(classElement.getName().getName(), stringBuffer, linkedList, true);
                bl2 = true;
                continue;
            }
            if (bl) continue;
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        if (!bl2) {
            TestCreator.generateSuitBody(classElement.getName().getName(), stringBuffer, linkedList, false);
        }
        methodElement.setBody(stringBuffer.toString());
        linkedList2.add(methodElement);
        TestCreator.addMethods(classElement, linkedList2);
    }

    private static void generateSuitBody(String string, StringBuffer stringBuffer, LinkedList linkedList, boolean bl) {
        stringBuffer.append("\n//--JUNIT:\n");
        stringBuffer.append(SUIT_BLOCK_COMMENT);
        if (JUnitSettings.getDefault().isGenerateNbJUnit()) {
            stringBuffer.append("\nTestSuite suite = new NbTestSuite(\"" + string + "\");\n");
        } else {
            stringBuffer.append("\nTestSuite suite = new TestSuite(\"" + string + "\");\n");
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            stringBuffer.append("suite.addTest(" + string2 + ".suite());\n");
        }
        stringBuffer.append("//:JUNIT--\n");
        if (!bl) {
            stringBuffer.append(SUIT_RETURN_COMMENT);
            stringBuffer.append("return suite;\n");
        }
    }

    private static boolean isForbiden(String string) {
        int n = 0;
        while (n < forbidenMethods.length) {
            if (forbidenMethods[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isException(ClassElement classElement) {
        ClassElement classElement2 = classElement;
        Identifier identifier = null;
        String string = null;
        while ((identifier = classElement2.getSuperclass()) != null) {
            string = identifier.getFullName();
            if (string.equals("java.lang.Throwable")) {
                return true;
            }
            classElement2 = ClassElement.forName((String)string);
            if (classElement2 != null) continue;
            return TestCreator.isException(string);
        }
        return false;
    }

    private static boolean isException(String string) {
        try {
            Class<?> clazz = TopManager.getDefault().currentClassLoader().loadClass(string);
            return (class$java$lang$Throwable == null ? (class$java$lang$Throwable = TestCreator.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isMethodAcceptable(MethodElement methodElement) {
        if ((methodElement.getModifiers() & 2) == 0 && ((methodElement.getModifiers() & cfg_MethodsFilter) != 0 || (methodElement.getModifiers() & 5) == 0 && cfg_MethodsFilterPackage)) {
            String string = methodElement.getName().getName();
            return !TestCreator.isForbiden(string) && (methodElement.getModifiers() & 0x400) == 0;
        }
        return false;
    }

    private static void createAbstractImpl(ClassElement classElement, ClassElement classElement2) throws SourceException {
        Object object;
        Identifier identifier = Identifier.create((String)(classElement.getName().getName() + "Impl"));
        ClassElement classElement3 = classElement2.getClass(identifier);
        if (classElement3 == null) {
            classElement3 = new ClassElement();
            classElement3.setName(identifier);
            classElement3.setModifiers(2);
            if (classElement.isInner()) {
                classElement3.setSuperclass(Identifier.create((String)classElement.getName().getFullName()));
            } else {
                classElement3.setSuperclass(classElement.getName());
            }
            if (JUnitSettings.getDefault().isJavaDoc()) {
                object = new StringBuffer();
                ((StringBuffer)object).append("Generated implementation of abstract class ");
                ((StringBuffer)object).append(classElement.getName().getFullName());
                ((StringBuffer)object).append(". Please fill dummy bodies of generated methods.");
                classElement3.getJavaDoc().setText(((StringBuffer)object).toString());
            }
            TestCreator.createImpleConstructors(classElement, classElement3);
        }
        LinkedList linkedList = new LinkedList();
        TestCreator.getAbstractClassMethods(classElement, linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (MethodElement)iterator.next();
            MethodElement methodElement = TestCreator.createMethodImpl((MethodElement)object);
            try {
                classElement3.addMethod(methodElement);
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
        }
        try {
            classElement2.addClass(classElement3);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    private static MethodElement createMethodImpl(MethodElement methodElement) throws SourceException {
        MethodElement methodElement2 = (MethodElement)methodElement.clone();
        StringBuffer stringBuffer = new StringBuffer();
        int n = methodElement.getModifiers() & 0xFFFFFBFF;
        if (methodElement.getDeclaringClass().isInterface()) {
            n |= 1;
        }
        methodElement2.setModifiers(n);
        if (JUnitSettings.getDefault().isBodyComments()) {
            stringBuffer.append("\n//fill the body in order to provide useful implementation\n");
        }
        if (methodElement2.getReturn().isClass() || methodElement2.getReturn().isArray()) {
            stringBuffer.append("\nreturn null;\n");
        } else if (methodElement2.getReturn().equals((Object)Type.BOOLEAN)) {
            stringBuffer.append("\nreturn false;\n");
        } else if (!methodElement2.getReturn().equals((Object)Type.VOID)) {
            stringBuffer.append("\nreturn 0;\n");
        }
        methodElement2.setBody(stringBuffer.toString());
        return methodElement2;
    }

    private static void createImpleConstructors(ClassElement classElement, ClassElement classElement2) throws SourceException {
        ConstructorElement[] constructorElementArray = classElement.getConstructors();
        ConstructorElement constructorElement = null;
        int n = 0;
        while (n < constructorElementArray.length) {
            constructorElement = (ConstructorElement)constructorElementArray[n].clone();
            if (0 == (constructorElement.getModifiers() & 2)) {
                constructorElement.setBody("\nsuper(" + TestCreator.getParameterString(constructorElement.getParameters()) + ");\n");
                constructorElement.getJavaDoc().clearJavaDoc();
                classElement2.addConstructor(constructorElement);
            }
            ++n;
        }
    }

    private static String getParameterString(MethodParameter[] methodParameterArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < methodParameterArray.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(methodParameterArray[n].getName());
            ++n;
        }
        return stringBuffer.toString();
    }

    private static LinkedList getInterfaceMethods(Identifier identifier) throws SourceException {
        LinkedList<MethodElement> linkedList = new LinkedList<MethodElement>();
        ClassElement classElement = ClassElement.forName((String)identifier.getFullName());
        MethodElement[] methodElementArray = classElement.getMethods();
        int n = 0;
        while (n < methodElementArray.length) {
            linkedList.add(methodElementArray[n]);
            ++n;
        }
        Identifier[] identifierArray = classElement.getInterfaces();
        int n2 = 0;
        while (n2 < identifierArray.length) {
            linkedList.addAll(TestCreator.getInterfaceMethods(identifierArray[n2]));
            ++n2;
        }
        return linkedList;
    }

    private static void getAbstractClassMethods(ClassElement classElement, LinkedList linkedList) throws SourceException {
        ClassElement classElement2;
        TestCreator.removeImplemented(classElement, linkedList, false);
        Identifier[] identifierArray = classElement.getInterfaces();
        int n = 0;
        while (n < identifierArray.length) {
            LinkedList linkedList2 = TestCreator.getInterfaceMethods(identifierArray[n]);
            TestCreator.removeImplemented(classElement, linkedList2, false);
            linkedList.addAll(linkedList2);
            ++n;
        }
        MethodElement[] methodElementArray = classElement.getMethods();
        int n2 = 0;
        while (n2 < methodElementArray.length) {
            if (0 != (methodElementArray[n2].getModifiers() & 0x400)) {
                linkedList.add(methodElementArray[n2]);
            }
            ++n2;
        }
        Identifier identifier = classElement.getSuperclass();
        if (null != identifier && null != (classElement2 = ClassElement.forName((String)identifier.getFullName()))) {
            if (0 != (classElement2.getModifiers() & 0x400)) {
                TestCreator.getAbstractClassMethods(classElement2, linkedList);
            } else {
                TestCreator.removeImplemented(classElement2, linkedList, true);
            }
        }
    }

    private static void removeImplemented(ClassElement classElement, LinkedList linkedList, boolean bl) throws SourceException {
        Identifier identifier;
        MethodElement methodElement;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            methodElement = (MethodElement)iterator.next();
            if (!TestCreator.isImplemented(classElement, methodElement)) continue;
            iterator.remove();
        }
        if (bl && null != (identifier = classElement.getSuperclass()) && null != (methodElement = ClassElement.forName((String)identifier.getFullName()))) {
            TestCreator.removeImplemented((ClassElement)methodElement, linkedList, true);
        }
    }

    private static void removeSuiteMethod(ClassElement classElement) throws SourceException {
        MethodElement methodElement = classElement.getMethod(Identifier.create((String)"suite"), null);
        if (methodElement != null) {
            classElement.removeMethod(methodElement);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

