/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.openide.TopManager;
import org.openide.execution.Executor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;

class TestUtil {
    private static final String JAVA_EXT = "java";
    private static final String CLS_SUFFIX = "Test";
    private static final String CLS_FULL_SUFFIX = "Test.java";
    private static final String SUITE_SUFFIX = "Suite";
    private static final String SUITE_FULL_SUFFIX = "Suite.java";
    private static final String SUITE_ROOT_NAME = "Root";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$src$ClassElement;
    static /* synthetic */ Class array$Ljava$lang$String;

    TestUtil() {
    }

    public static String getTestClassFullName(FileObject fileObject) {
        return fileObject.getPackageName('/') + CLS_FULL_SUFFIX;
    }

    public static String getTestClassName(FileObject fileObject) {
        return TestUtil.getTestClassName(fileObject.getName());
    }

    public static String getTestClassName(String string) {
        return string + CLS_SUFFIX;
    }

    public static String getTestSuitFullName(FileObject fileObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(fileObject.getPackageName('/'));
        if (stringBuffer.length() != 0) {
            stringBuffer.append("/");
        }
        if (fileObject.getName().length() == 0) {
            stringBuffer.append(SUITE_ROOT_NAME);
        } else {
            stringBuffer.append(fileObject.getName().substring(0, 1).toUpperCase());
            stringBuffer.append(fileObject.getName().substring(1));
        }
        stringBuffer.append(SUITE_FULL_SUFFIX);
        return stringBuffer.toString();
    }

    public static String getTestSuitName(FileObject fileObject) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fileObject.getName().length() == 0) {
            stringBuffer.append(SUITE_ROOT_NAME);
        } else {
            stringBuffer.append(fileObject.getName().substring(0, 1).toUpperCase());
            stringBuffer.append(fileObject.getName().substring(1));
        }
        stringBuffer.append(SUITE_SUFFIX);
        return stringBuffer.toString();
    }

    public static FileObject getFileObjectFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TestUtil.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (null != dataObject) {
            return dataObject.getPrimaryFile();
        }
        DataFolder dataFolder = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TestUtil.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (null != dataFolder) {
            return dataFolder.getPrimaryFile();
        }
        ClassElement classElement = (ClassElement)node.getCookie(class$org$openide$src$ClassElement == null ? (class$org$openide$src$ClassElement = TestUtil.class$("org.openide.src.ClassElement")) : class$org$openide$src$ClassElement);
        if (null != classElement) {
            while (null != (node = node.getParentNode())) {
                dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? TestUtil.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (null == dataObject) continue;
                return dataObject.getPrimaryFile();
            }
        }
        return null;
    }

    public static boolean isTestClassFile(String string) {
        return string.endsWith(CLS_SUFFIX);
    }

    public static boolean isTestSuiteFile(String string) {
        return string.endsWith(SUITE_SUFFIX);
    }

    static Executor findExecutor(Class clazz) {
        Executor.getDefault();
        Enumeration enumeration = Executor.executors();
        while (enumeration.hasMoreElements()) {
            Executor executor = (Executor)enumeration.nextElement();
            if (!clazz.isInstance(executor)) continue;
            return executor;
        }
        return null;
    }

    static void invokeMain(String string) throws Exception {
        TestUtil.invokeMain(string, null);
    }

    static void invokeMain(String string, String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName(string);
        TestUtil.invokeMain(clazz, stringArray);
    }

    static void invokeMain(Class clazz, String[] stringArray) throws Exception {
        Method method = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = TestUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        try {
            method.invoke(null, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof ThreadDeath) {
                return;
            }
            if (invocationTargetException.getTargetException() instanceof SecurityException) {
                return;
            }
            throw invocationTargetException;
        }
    }

    static void invokeMainInExecutor(final String string) throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestUtil.invokeMain(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        TopManager.getDefault().getExecutionEngine().execute(string, runnable, null);
    }

    static boolean isSupportedFileSystem(FileSystem fileSystem) {
        FileSystemCapability fileSystemCapability = fileSystem.getCapability();
        return fileSystem.isValid() && !fileSystem.isDefault() && !fileSystem.isReadOnly() && !fileSystemCapability.capableOf(FileSystemCapability.DOC);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

