/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.web.context.RepManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.actions.SystemAction;

public class DelegatingFileSystem
extends MultiFileSystem
implements FileSystem.Status,
FileStatusListener {
    static final long serialVersionUID = 3521863383479243345L;
    protected String rootFolder;
    protected transient FileSystem delegateeFs;
    protected String delegateeFsName;
    private transient PropertyChangeListener pcl;
    private transient boolean removable = false;

    public DelegatingFileSystem(FileObject fileObject) throws IOException {
        this(fileObject.getFileSystem(), fileObject.getPackageName('/'));
    }

    public DelegatingFileSystem(FileSystem fileSystem, String string) throws IOException {
        super(new FileSystem[]{fileSystem});
        this.rootFolder = string;
        this.delegateeFsName = fileSystem.getSystemName();
        this.setFileSystem(fileSystem);
    }

    public final void setFileSystem(FileSystem fileSystem) {
        FileSystem fileSystem2;
        FileSystem[] fileSystemArray = (FileSystem[])this.getDelegates().clone();
        if (fileSystemArray.length > 0) {
            fileSystem2 = fileSystemArray[0];
            fileSystemArray[0] = fileSystem;
        } else {
            fileSystem2 = null;
            fileSystemArray = new FileSystem[]{fileSystem};
        }
        if (fileSystem2 != null) {
            fileSystem2.removeFileStatusListener((FileStatusListener)this);
        }
        if (fileSystem != null) {
            fileSystem.addFileStatusListener((FileStatusListener)this);
        }
        this.setDelegates(fileSystemArray[0] != null ? fileSystemArray : new FileSystem[1]);
        this.delegateeFs = fileSystem;
        this.updateName();
    }

    void updateState() {
        if (this.delegateeFsName != null) {
            RepManager.register(this);
            FileSystem fileSystem = Repository.getDefault().findFileSystem(this.delegateeFsName);
            this.setFileSystem(fileSystem);
        }
    }

    public void prepareEnvironment(final FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        if (this.delegateeFs != null) {
            this.delegateeFs.prepareEnvironment(new FileSystem.Environment(){

                public void addClassPath(String string) {
                    String string2 = string.endsWith(File.separator) ? string : string + File.separator;
                    string2 = string2 + DelegatingFileSystem.this.rootFolder.replace('/', File.separatorChar);
                    environment.addClassPath(string2);
                }
            });
        }
    }

    private void updateName() {
        try {
            FileSystem[] fileSystemArray = this.getDelegates();
            String string = fileSystemArray.length > 0 && fileSystemArray[0] != null ? fileSystemArray[0].getSystemName() : "Invalid " + this.delegateeFsName;
            this.setSystemName(string + ":" + this.rootFolder);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        return this.delegateeFs == null ? super.getDisplayName() : this.delegateeFs.getDisplayName() + " : /" + this.rootFolder;
    }

    public SystemAction[] getActions(Set set) {
        return this.delegateeFs.getActions(this.translateFiles(set, false));
    }

    protected FileObject findResourceOn(FileSystem fileSystem, String string) {
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.findResource(this.rootFolder + "/" + string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        FileSystem[] fileSystemArray;
        objectInputStream.defaultReadObject();
        if (this.delegateeFsName == null && (fileSystemArray = this.getDelegates()).length > 0) {
            this.delegateeFsName = fileSystemArray[0].getSystemName();
        }
        this.updateState();
    }

    public boolean correspondsTo(FileSystem fileSystem) {
        if (fileSystem instanceof DelegatingFileSystem) {
            DelegatingFileSystem delegatingFileSystem = (DelegatingFileSystem)fileSystem;
            return (this.delegateeFs == delegatingFileSystem.delegateeFs || this.delegateeFsName.equals(delegatingFileSystem.delegateeFsName)) && this.rootFolder.equals(delegatingFileSystem.rootFolder);
        }
        if (fileSystem instanceof LocalFileSystem && this.delegateeFs instanceof LocalFileSystem) {
            File file = NbClassPath.toFile((FileObject)fileSystem.getRoot());
            if (file == null) {
                return false;
            }
            FileObject fileObject = this.delegateeFs.find(this.rootFolder.replace('/', '.'), null, null);
            if (fileObject == null) {
                return false;
            }
            File file2 = NbClassPath.toFile((FileObject)fileObject);
            if (file2 == null) {
                return false;
            }
            return file.equals(file2);
        }
        return false;
    }

    public boolean delegatesTo(FileSystem fileSystem) {
        File file = FileUtil.toFile((FileObject)fileSystem.getRoot());
        if (file == null || this.delegateeFs == null) {
            return false;
        }
        return file.equals(FileUtil.toFile((FileObject)this.delegateeFs.getRoot()));
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String string, Set set) {
        if (this.delegateeFs == null) {
            return string;
        }
        return this.delegateeFs.getStatus().annotateName(string, this.translateFiles(set, false));
    }

    public Image annotateIcon(Image image, int n, Set set) {
        if (this.delegateeFs == null) {
            return image;
        }
        return this.delegateeFs.getStatus().annotateIcon(image, n, this.translateFiles(set, false));
    }

    protected Set translateFiles(Set set, boolean bl) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if ((fileObject = this.translateFile(fileObject, bl)) == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    protected FileObject translateFile(FileObject fileObject, boolean bl) {
        if (bl) {
            String string = fileObject.getPackageNameExt('/', '.');
            fileObject = null;
            if (string.startsWith(this.rootFolder)) {
                fileObject = "".equals(string = string.substring(this.rootFolder.length())) ? this.getRoot() : this.findResource(string.substring(1));
            }
        } else {
            if (this.delegateeFs == null) {
                return null;
            }
            fileObject = this.delegateeFs.findResource(this.rootFolder + '/' + fileObject.getPackageNameExt('/', '.'));
        }
        return fileObject;
    }

    public void annotationChanged(final FileStatusEvent fileStatusEvent) {
        HashSet hashSet = new HashSet(1){

            public boolean contains(Object object) {
                if (DelegatingFileSystem.this.delegateeFs == null) {
                    return false;
                }
                if (object instanceof FileObject) {
                    FileObject fileObject = (FileObject)object;
                    fileObject = DelegatingFileSystem.this.delegateeFs.findResource(DelegatingFileSystem.this.rootFolder + '/' + fileObject.getPackageNameExt('/', '.'));
                    return fileObject != null && fileStatusEvent.hasChanged(fileObject);
                }
                return false;
            }
        };
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, (Set)hashSet, fileStatusEvent.isIconChange(), fileStatusEvent.isNameChange()));
    }
}

