/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public interface JspParserAPI {
    public static final int ERROR_IGNORE = 1;
    public static final int ERROR_REPORT_ANY = 2;
    public static final int ERROR_REPORT_ACCURATE = 3;

    public ParseResult analyzePage(JspDataObject var1, String var2, boolean var3, int var4) throws IOException;

    public ParseResult parsePage(JspDataObject var1, String var2) throws IOException;

    public TagLibParseSupport.TagLibData createTagLibData(JspInfo.TagLibraryData var1, FileSystem var2);

    public Map getTagLibraryMappings(FileObject var1) throws IOException;

    public static class ErrorDescriptor {
        protected FileObject source;
        protected int line;
        protected int column;
        protected String errorMessage;
        protected String referenceText;

        public ErrorDescriptor(FileObject fileObject, int n, int n2, String string, String string2) {
            this.source = fileObject;
            this.line = n;
            this.column = n2;
            this.errorMessage = string;
            this.referenceText = string2;
        }

        public FileObject getSource() {
            return this.source;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getReferenceText() {
            return this.referenceText;
        }
    }

    public static class ParseResult {
        protected JspInfo pageInfo;
        protected ErrorDescriptor[] errors;
        protected boolean parsedOK;

        public ParseResult(JspInfo jspInfo) {
            this.pageInfo = jspInfo;
            this.parsedOK = true;
        }

        public ParseResult(ErrorDescriptor[] errorDescriptorArray) {
            this.errors = errorDescriptorArray;
            this.parsedOK = false;
        }

        public boolean isParsingSuccess() {
            return this.parsedOK;
        }

        public JspInfo getPageInfo() {
            if (this.parsedOK) {
                return this.pageInfo;
            }
            throw new IllegalStateException();
        }

        public ErrorDescriptor[] getErrors() {
            if (!this.parsedOK) {
                return this.errors;
            }
            throw new IllegalStateException();
        }
    }
}

