/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.TreeMap;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.core.jsploader.JspParserAPI;
import org.openide.TopManager;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class TagLibParseSupport
implements Node.Cookie {
    private JspDataObject jspdo;
    private boolean documentDirty;
    private RequestProcessor.Task parsingTask = null;
    private WeakReference tagLibEditorDataRef;

    public TagLibParseSupport(JspDataObject jspDataObject) {
        this.jspdo = jspDataObject;
    }

    public TagLibEditorData getTagLibEditorData() {
        return this.getTagLibEditorData(true);
    }

    TagLibEditorData getTagLibEditorData(boolean bl) {
        Object object;
        if (this.tagLibEditorDataRef != null && (object = this.tagLibEditorDataRef.get()) != null) {
            return (TagLibEditorData)object;
        }
        object = new TagLibEditorData(this);
        this.tagLibEditorDataRef = new WeakReference(object);
        if (bl) {
            this.prepare();
        }
        return object;
    }

    synchronized void setDocumentDirty(boolean bl) {
        this.documentDirty = bl;
    }

    boolean isDocumentDirty() {
        return this.documentDirty;
    }

    RequestProcessor.Task autoParse() {
        return this.parseObject(1);
    }

    public RequestProcessor.Task prepare() {
        return this.parseObject(9);
    }

    private synchronized RequestProcessor.Task parseObject(int n) {
        RequestProcessor.Task task = this.parsingTask;
        if (task != null) {
            task.setPriority(Math.max(task.getPriority(), n));
            return task;
        }
        this.setDocumentDirty(false);
        this.parsingTask = task = RequestProcessor.postRequest((Runnable)new ParsingRunnable(), (int)0, (int)n);
        return this.parsingTask;
    }

    static TagLibData createTagLibData(JspInfo.TagLibraryData tagLibraryData, FileSystem fileSystem) {
        JspParserAPI jspParserAPI = JspCompileUtil.getJspParser();
        if (jspParserAPI == null) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)new NullPointerException());
            return null;
        }
        return jspParserAPI.createTagLibData(tagLibraryData, fileSystem);
    }

    public static abstract class TagLibData {
        public abstract boolean equalsColoringInformation(TagLibData var1);

        public abstract String getPrefix();

        public abstract Object getTagLibraryInfo();
    }

    public static class TagLibEditorData
    extends PropertyChangeSupport {
        public static final String PROP_COLORING_CHANGE = "coloringChange";
        private TreeMap libraryMap = new TreeMap();
        private JspInfo.BeanData[] beanData = new JspInfo.BeanData[0];
        private boolean errorPage = false;

        TagLibEditorData(Object object) {
            super(object);
        }

        public void setBeanData(JspInfo.BeanData[] beanDataArray) {
            this.beanData = beanDataArray;
        }

        public JspInfo.BeanData[] getBeanData() {
            return this.beanData;
        }

        public void setErrorPage(boolean bl) {
            this.errorPage = bl;
        }

        public boolean isErrorPage() {
            return this.errorPage;
        }

        void applyParsedData(JspInfo.TagLibraryData[] tagLibraryDataArray, FileSystem fileSystem) {
            TreeMap<String, TagLibData> treeMap = new TreeMap<String, TagLibData>();
            int n = 0;
            while (n < tagLibraryDataArray.length) {
                String string = tagLibraryDataArray[n].getPrefix();
                treeMap.put(string, TagLibParseSupport.createTagLibData(tagLibraryDataArray[n], fileSystem));
                ++n;
            }
            boolean bl = false;
            if (this.libraryMap.size() != treeMap.size()) {
                bl = true;
            } else {
                TagLibData[] tagLibDataArray = this.getTagLibData();
                TagLibData[] tagLibDataArray2 = treeMap.values().toArray(new TagLibData[treeMap.size()]);
                int n2 = 0;
                while (n2 < tagLibDataArray.length) {
                    if (!tagLibDataArray[n2].equalsColoringInformation(tagLibDataArray2[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            this.libraryMap = treeMap;
            if (bl) {
                this.firePropertyChange(PROP_COLORING_CHANGE, null, null);
            }
        }

        public TagLibData[] getTagLibData() {
            return this.libraryMap.values().toArray(new TagLibData[this.libraryMap.size()]);
        }

        public TagLibData getTagLibData(String string) {
            return (TagLibData)this.libraryMap.get(string);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    private class ParsingRunnable
    implements Runnable {
        private ParsingRunnable() {
        }

        public void run() {
            TagLibParseSupport tagLibParseSupport;
            try {
                try {
                    JspParserAPI jspParserAPI = JspCompileUtil.getJspParser();
                    if (jspParserAPI == null) {
                        TopManager.getDefault().getErrorManager().notify(1, (Throwable)new NullPointerException());
                    } else {
                        JspParserAPI.ParseResult parseResult = jspParserAPI.parsePage(TagLibParseSupport.this.jspdo, JspCompileUtil.getContextPath(TagLibParseSupport.this.jspdo.getPrimaryFile()));
                        if (parseResult.isParsingSuccess()) {
                            JspInfo jspInfo = parseResult.getPageInfo();
                            TagLibParseSupport.this.getTagLibEditorData(false).applyParsedData(jspInfo.getTagLibraryData(), TagLibParseSupport.this.jspdo.getPrimaryFile().getFileSystem());
                            TagLibParseSupport.this.getTagLibEditorData(false).setBeanData(jspInfo.getBeans());
                            TagLibParseSupport.this.getTagLibEditorData(false).setErrorPage(jspInfo.isErrorPage());
                        }
                    }
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
                }
                Object var5_5 = null;
                tagLibParseSupport = TagLibParseSupport.this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                TagLibParseSupport tagLibParseSupport2 = TagLibParseSupport.this;
                synchronized (tagLibParseSupport2) {
                    TagLibParseSupport.this.parsingTask = null;
                }
                throw throwable;
            }
            synchronized (tagLibParseSupport) {
                TagLibParseSupport.this.parsingTask = null;
            }
        }
    }
}

