/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.idl.editor.coloring;

import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.corba.idl.editor.coloring.IDLTokenContext;

public class IDLSyntax
extends Syntax {
    private static final int ISI_ERROR = 1;
    private static final int ISI_TEXT = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_STRING_A_BSLASH = 7;
    private static final int ISI_CHAR = 8;
    private static final int ISI_CHAR_A_BSLASH = 9;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_SLASH = 11;
    private static final int ISA_EQ = 12;
    private static final int ISA_GT = 13;
    private static final int ISA_GTGT = 14;
    private static final int ISA_GTGTGT = 15;
    private static final int ISA_LT = 16;
    private static final int ISA_LTLT = 17;
    private static final int ISA_PLUS = 18;
    private static final int ISA_MINUS = 19;
    private static final int ISA_STAR = 20;
    private static final int ISA_STAR_I_BLOCK_COMMENT = 21;
    private static final int ISA_PIPE = 22;
    private static final int ISA_PERCENT = 23;
    private static final int ISA_AND = 24;
    private static final int ISA_XOR = 25;
    private static final int ISA_EXCLAMATION = 26;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_OCTAL = 29;
    private static final int ISI_FLOAT = 30;
    private static final int ISI_FLOAT_EXP = 31;
    private static final int ISI_HEX = 32;
    private static final int ISA_DOT = 33;
    private static final int ISA_HASH = 34;
    private static final int ISA_DIRECTIVE = 36;
    private static final int ISI_HERROR = 37;

    public IDLSyntax() {
        this.tokenContextPath = IDLTokenContext.contextPath;
    }

    public boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char c = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (c) {
                        case '\n': {
                            ++this.offset;
                            return IDLTokenContext.EOL;
                        }
                        case '\t': 
                        case ' ': {
                            this.state = 2;
                            break block0;
                        }
                        case '\"': {
                            this.state = 6;
                            break block0;
                        }
                        case '\'': {
                            this.state = 8;
                            break block0;
                        }
                        case '/': {
                            this.state = 11;
                            break block0;
                        }
                        case '=': {
                            this.state = 12;
                            break block0;
                        }
                        case '>': {
                            this.state = 13;
                            break block0;
                        }
                        case '<': {
                            this.state = 16;
                            break block0;
                        }
                        case '+': {
                            this.state = 18;
                            break block0;
                        }
                        case '-': {
                            this.state = 19;
                            break block0;
                        }
                        case '*': {
                            this.state = 20;
                            break block0;
                        }
                        case '|': {
                            this.state = 22;
                            break block0;
                        }
                        case '%': {
                            this.state = 23;
                            break block0;
                        }
                        case '&': {
                            this.state = 24;
                            break block0;
                        }
                        case '^': {
                            this.state = 25;
                            break block0;
                        }
                        case '!': {
                            this.state = 26;
                            break block0;
                        }
                        case '0': {
                            this.state = 27;
                            break block0;
                        }
                        case '.': {
                            this.state = 33;
                            break block0;
                        }
                        case '#': {
                            this.state = 34;
                            break block0;
                        }
                    }
                    if (c >= '1' && c <= '9') {
                        this.state = 28;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        this.state = 10;
                        break;
                    }
                    ++this.offset;
                    return IDLTokenContext.OPERATOR;
                }
                case 1: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            this.state = -1;
                            return IDLTokenContext.ERROR;
                        }
                    }
                    break;
                }
                case 2: {
                    if (c == ' ' || c == '\t') break;
                    this.state = -1;
                    return IDLTokenContext.TEXT;
                }
                case 4: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return IDLTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (c) {
                        case '\n': {
                            if (this.offset == this.tokenOffset) {
                                ++this.offset;
                                return IDLTokenContext.EOL;
                            }
                            return IDLTokenContext.BLOCK_COMMENT;
                        }
                        case '*': {
                            this.state = 21;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\\': {
                            this.state = 7;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            return IDLTokenContext.STRING_LITERAL;
                        }
                        case '\"': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (c) {
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 6;
                    break;
                }
                case 8: {
                    switch (c) {
                        case '\\': {
                            this.state = 9;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            return IDLTokenContext.CHAR_LITERAL;
                        }
                        case '\'': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.CHAR_LITERAL;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (c) {
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 8;
                    break;
                }
                case 10: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.state = -1;
                    TokenID tokenID = IDLSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tokenID != null ? tokenID : IDLTokenContext.IDENTIFIER;
                }
                case 11: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.OPERATOR;
                        }
                        case '/': {
                            this.state = 4;
                            break block0;
                        }
                        case '*': {
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 12: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 13: {
                    switch (c) {
                        case '>': {
                            this.state = 14;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 14: {
                    switch (c) {
                        case '>': {
                            this.state = 15;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 15: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 16: {
                    switch (c) {
                        case '<': {
                            this.state = 17;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 17: {
                    switch (c) {
                        case '<': {
                            this.state = 1;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 18: {
                    switch (c) {
                        case '+': 
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 19: {
                    switch (c) {
                        case '-': 
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 20: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            return IDLTokenContext.OPERATOR;
                        }
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.ERROR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 21: {
                    switch (c) {
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.BLOCK_COMMENT;
                        }
                    }
                    --this.offset;
                    this.state = 5;
                    break;
                }
                case 22: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 23: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 24: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 25: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 26: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 27: {
                    switch (c) {
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            this.state = 32;
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.LONG_LITERAL;
                        }
                        case 'D': 
                        case 'F': 
                        case 'd': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.FLOAT_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                        case '8': 
                        case '9': {
                            this.state = 1;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '7') {
                        this.state = 29;
                        break;
                    }
                    this.state = -1;
                    return IDLTokenContext.INT_LITERAL;
                }
                case 28: {
                    switch (c) {
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.LONG_LITERAL;
                        }
                        case 'D': 
                        case 'F': 
                        case 'd': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.FLOAT_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') break;
                    this.state = -1;
                    return IDLTokenContext.INT_LITERAL;
                }
                case 29: {
                    if (c >= '0' && c <= '7') break;
                    this.state = -1;
                    return IDLTokenContext.OCTAL_LITERAL;
                }
                case 30: {
                    switch (c) {
                        case 'D': 
                        case 'F': 
                        case 'd': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.FLOAT_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9' || c == '.') break;
                    this.state = -1;
                    return IDLTokenContext.FLOAT_LITERAL;
                }
                case 31: {
                    switch (c) {
                        case 'D': 
                        case 'F': 
                        case 'd': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return IDLTokenContext.FLOAT_LITERAL;
                        }
                    }
                    if (c >= '0' && c <= '9' || c == '-' || c == '+') break;
                    this.state = -1;
                    return IDLTokenContext.FLOAT_LITERAL;
                }
                case 32: {
                    if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') break;
                    this.state = -1;
                    return IDLTokenContext.HEX_LITERAL;
                }
                case 33: {
                    if (c >= '0' && c <= '9') {
                        this.state = 30;
                        break;
                    }
                    this.state = -1;
                    return IDLTokenContext.OPERATOR;
                }
                case 34: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    if (this.matchDirective()) {
                        this.state = 36;
                        return IDLTokenContext.DIRECTIVE;
                    }
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return IDLTokenContext.TEXT;
                        }
                    }
                    this.state = 37;
                    return IDLTokenContext.ERROR;
                }
                case 36: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return IDLTokenContext.DIRECTIVE;
                        }
                    }
                    break;
                }
                case 37: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return IDLTokenContext.ERROR;
                        }
                    }
                }
            }
            this.offset = ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 10: {
                    TokenID tokenID = IDLSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tokenID != null ? tokenID : IDLTokenContext.IDENTIFIER;
                }
                case 34: {
                    return this.matchDirective() ? IDLTokenContext.DIRECTIVE : IDLTokenContext.TEXT;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 33: {
                    return IDLTokenContext.OPERATOR;
                }
                case 1: 
                case 37: {
                    return IDLTokenContext.ERROR;
                }
                case 2: {
                    return IDLTokenContext.TEXT;
                }
                case 4: {
                    return IDLTokenContext.LINE_COMMENT;
                }
                case 5: 
                case 21: {
                    return IDLTokenContext.BLOCK_COMMENT;
                }
                case 6: 
                case 7: {
                    return IDLTokenContext.STRING_LITERAL;
                }
                case 8: 
                case 9: {
                    return IDLTokenContext.CHAR_LITERAL;
                }
                case 27: 
                case 28: {
                    return IDLTokenContext.INT_LITERAL;
                }
                case 29: {
                    return IDLTokenContext.OCTAL_LITERAL;
                }
                case 30: 
                case 31: {
                    return IDLTokenContext.FLOAT_LITERAL;
                }
                case 32: {
                    return IDLTokenContext.HEX_LITERAL;
                }
                case 36: {
                    return IDLTokenContext.DIRECTIVE;
                }
            }
        }
        return null;
    }

    public static TokenID matchKeyword(char[] cArray, int n, int n2) {
        if (n2 > 11) {
            return null;
        }
        if (n2 <= 1) {
            return null;
        }
        switch (cArray[n++]) {
            case 'F': {
                return n2 == 5 && cArray[n++] == 'A' && cArray[n++] == 'L' && cArray[n++] == 'S' && cArray[n++] == 'E' ? IDLTokenContext.FALSE : null;
            }
            case 'O': {
                return n2 == 6 && cArray[n++] == 'b' && cArray[n++] == 'j' && cArray[n++] == 'e' && cArray[n++] == 'c' && cArray[n++] == 't' ? IDLTokenContext.OBJECT : null;
            }
            case 'T': {
                return n2 == 4 && cArray[n++] == 'R' && cArray[n++] == 'U' && cArray[n++] == 'E' ? IDLTokenContext.TRUE : null;
            }
            case 'V': {
                return n2 == 9 && cArray[n++] == 'a' && cArray[n++] == 'l' && cArray[n++] == 'u' && cArray[n++] == 'e' && cArray[n++] == 'B' && cArray[n++] == 'a' && cArray[n++] == 's' && cArray[n++] == 'e' ? IDLTokenContext.VALUEBASE : null;
            }
            case 'a': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'b': {
                        return n2 == 8 && cArray[n++] == 's' && cArray[n++] == 't' && cArray[n++] == 'r' && cArray[n++] == 'a' && cArray[n++] == 'c' && cArray[n++] == 't' ? IDLTokenContext.ABSTRACT : null;
                    }
                    case 'n': {
                        return n2 == 3 && cArray[n++] == 'y' ? IDLTokenContext.ANY : null;
                    }
                    case 't': {
                        return n2 == 9 && cArray[n++] == 't' && cArray[n++] == 'r' && cArray[n++] == 'i' && cArray[n++] == 'b' && cArray[n++] == 'u' && cArray[n++] == 't' && cArray[n++] == 'e' ? IDLTokenContext.ATTRIBUTE : null;
                    }
                }
                return null;
            }
            case 'b': {
                return n2 == 7 && cArray[n++] == 'o' && cArray[n++] == 'o' && cArray[n++] == 'l' && cArray[n++] == 'e' && cArray[n++] == 'a' && cArray[n++] == 'n' ? IDLTokenContext.BOOLEAN : null;
            }
            case 'c': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return n2 == 4 && cArray[n++] == 's' && cArray[n++] == 'e' ? IDLTokenContext.CASE : null;
                    }
                    case 'h': {
                        return n2 == 4 && cArray[n++] == 'a' && cArray[n++] == 'r' ? IDLTokenContext.CHAR : null;
                    }
                    case 'o': {
                        if (n2 <= 4) {
                            return null;
                        }
                        if (cArray[n++] != 'n') {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 's': {
                                return n2 == 5 && cArray[n++] == 't' ? IDLTokenContext.CONST : null;
                            }
                            case 't': {
                                return n2 == 7 && cArray[n++] == 'e' && cArray[n++] == 'x' && cArray[n++] == 't' ? IDLTokenContext.CONTEXT : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return n2 == 6 && cArray[n++] == 's' && cArray[n++] == 't' && cArray[n++] == 'o' && cArray[n++] == 'm' ? IDLTokenContext.CUSTOM : null;
                    }
                }
                return null;
            }
            case 'd': {
                if (n2 <= 5) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'e': {
                        return n2 == 7 && cArray[n++] == 'f' && cArray[n++] == 'a' && cArray[n++] == 'u' && cArray[n++] == 'l' && cArray[n++] == 't' ? IDLTokenContext.DEFAULT : null;
                    }
                    case 'o': {
                        return n2 == 6 && cArray[n++] == 'u' && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'e' ? IDLTokenContext.DOUBLE : null;
                    }
                }
                return null;
            }
            case 'e': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'n': {
                        return n2 == 4 && cArray[n++] == 'u' && cArray[n++] == 'm' ? IDLTokenContext.ENUM : null;
                    }
                    case 'x': {
                        return n2 == 9 && cArray[n++] == 'c' && cArray[n++] == 'e' && cArray[n++] == 'p' && cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'o' && cArray[n++] == 'n' ? IDLTokenContext.EXCEPTION : null;
                    }
                }
                return null;
            }
            case 'f': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return n2 == 7 && cArray[n++] == 'c' && cArray[n++] == 't' && cArray[n++] == 'o' && cArray[n++] == 'r' && cArray[n++] == 'y' ? IDLTokenContext.FACTORY : null;
                    }
                    case 'i': {
                        return n2 == 5 && cArray[n++] == 'x' && cArray[n++] == 'e' && cArray[n++] == 'd' ? IDLTokenContext.FIXED : null;
                    }
                    case 'l': {
                        return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'a' && cArray[n++] == 't' ? IDLTokenContext.FLOAT : null;
                    }
                }
                return null;
            }
            case 'i': {
                if (cArray[n++] != 'n') {
                    return null;
                }
                if (n2 == 2) {
                    return IDLTokenContext.IN;
                }
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'o': {
                        return n2 == 5 && cArray[n++] == 'u' && cArray[n++] == 't' ? IDLTokenContext.INOUT : null;
                    }
                    case 't': {
                        return n2 == 9 && cArray[n++] == 'e' && cArray[n++] == 'r' && cArray[n++] == 'f' && cArray[n++] == 'a' && cArray[n++] == 'c' && cArray[n++] == 'e' ? IDLTokenContext.INTERFACE : null;
                    }
                }
                return null;
            }
            case 'l': {
                return n2 == 4 && cArray[n++] == 'o' && cArray[n++] == 'n' && cArray[n++] == 'g' ? IDLTokenContext.LONG : null;
            }
            case 'm': {
                return n2 == 6 && cArray[n++] == 'o' && cArray[n++] == 'd' && cArray[n++] == 'u' && cArray[n++] == 'l' && cArray[n++] == 'e' ? IDLTokenContext.MODULE : null;
            }
            case 'n': {
                return n2 == 6 && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'i' && cArray[n++] == 'v' && cArray[n++] == 'e' ? IDLTokenContext.NATIVE : null;
            }
            case 'o': {
                if (n2 <= 2) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'c': {
                        return n2 == 5 && cArray[n++] == 't' && cArray[n++] == 'e' && cArray[n++] == 't' ? IDLTokenContext.OCTET : null;
                    }
                    case 'n': {
                        return n2 == 6 && cArray[n++] == 'e' && cArray[n++] == 'w' && cArray[n++] == 'a' && cArray[n++] == 'y' ? IDLTokenContext.ONEWAY : null;
                    }
                    case 'u': {
                        return n2 == 3 && cArray[n++] == 't' ? IDLTokenContext.OUT : null;
                    }
                }
                return null;
            }
            case 'p': {
                if (n2 <= 5) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'r': {
                        return n2 == 7 && cArray[n++] == 'i' && cArray[n++] == 'v' && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'e' ? IDLTokenContext.PRIVATE : null;
                    }
                    case 'u': {
                        return n2 == 6 && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'i' && cArray[n++] == 'c' ? IDLTokenContext.PUBLIC : null;
                    }
                }
                return null;
            }
            case 'r': {
                if (n2 <= 5) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return n2 == 6 && cArray[n++] == 'i' && cArray[n++] == 's' && cArray[n++] == 'e' && cArray[n++] == 's' ? IDLTokenContext.RAISES : null;
                    }
                    case 'e': {
                        return n2 == 8 && cArray[n++] == 'a' && cArray[n++] == 'd' && cArray[n++] == 'o' && cArray[n++] == 'n' && cArray[n++] == 'l' && cArray[n++] == 'y' ? IDLTokenContext.READONLY : null;
                    }
                }
                return null;
            }
            case 's': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'e': {
                        return n2 == 8 && cArray[n++] == 'q' && cArray[n++] == 'u' && cArray[n++] == 'e' && cArray[n++] == 'n' && cArray[n++] == 'c' && cArray[n++] == 'e' ? IDLTokenContext.SEQUENCE : null;
                    }
                    case 'h': {
                        return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'r' && cArray[n++] == 't' ? IDLTokenContext.SHORT : null;
                    }
                    case 't': {
                        if (n2 <= 5) {
                            return null;
                        }
                        if (cArray[n++] != 'r') {
                            return null;
                        }
                        switch (cArray[n++]) {
                            case 'i': {
                                return n2 == 6 && cArray[n++] == 'n' && cArray[n++] == 'g' ? IDLTokenContext.STRING : null;
                            }
                            case 'u': {
                                return n2 == 6 && cArray[n++] == 'c' && cArray[n++] == 't' ? IDLTokenContext.STRUCT : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return n2 == 8 && cArray[n++] == 'p' && cArray[n++] == 'p' && cArray[n++] == 'o' && cArray[n++] == 'r' && cArray[n++] == 't' && cArray[n++] == 's' ? IDLTokenContext.SUPPORTS : null;
                    }
                    case 'w': {
                        return n2 == 6 && cArray[n++] == 'i' && cArray[n++] == 't' && cArray[n++] == 'c' && cArray[n++] == 'h' ? IDLTokenContext.SWITCH : null;
                    }
                }
                return null;
            }
            case 't': {
                if (n2 <= 6) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'r': {
                        return n2 == 11 && cArray[n++] == 'u' && cArray[n++] == 'n' && cArray[n++] == 'c' && cArray[n++] == 'a' && cArray[n++] == 't' && cArray[n++] == 'a' && cArray[n++] == 'b' && cArray[n++] == 'l' && cArray[n++] == 'e' ? IDLTokenContext.TRUNCATABLE : null;
                    }
                    case 'y': {
                        return n2 == 7 && cArray[n++] == 'p' && cArray[n++] == 'e' && cArray[n++] == 'd' && cArray[n++] == 'e' && cArray[n++] == 'f' ? IDLTokenContext.TYPEDEF : null;
                    }
                }
                return null;
            }
            case 'u': {
                if (n2 <= 4) {
                    return null;
                }
                if (cArray[n++] != 'n') {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'i': {
                        return n2 == 5 && cArray[n++] == 'o' && cArray[n++] == 'n' ? IDLTokenContext.UNION : null;
                    }
                    case 's': {
                        return n2 == 8 && cArray[n++] == 'i' && cArray[n++] == 'g' && cArray[n++] == 'n' && cArray[n++] == 'e' && cArray[n++] == 'd' ? IDLTokenContext.UNSIGNED : null;
                    }
                }
                return null;
            }
            case 'v': {
                if (n2 <= 3) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'a': {
                        return n2 == 9 && cArray[n++] == 'l' && cArray[n++] == 'u' && cArray[n++] == 'e' && cArray[n++] == 't' && cArray[n++] == 'y' && cArray[n++] == 'p' && cArray[n++] == 'e' ? IDLTokenContext.VALUETYPE : null;
                    }
                    case 'o': {
                        return n2 == 4 && cArray[n++] == 'i' && cArray[n++] == 'd' ? IDLTokenContext.VOID : null;
                    }
                }
                return null;
            }
            case 'w': {
                if (n2 <= 4) {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'c': {
                        return n2 == 5 && cArray[n++] == 'h' && cArray[n++] == 'a' && cArray[n++] == 'r' ? IDLTokenContext.WCHAR : null;
                    }
                    case 's': {
                        return n2 == 7 && cArray[n++] == 't' && cArray[n++] == 'r' && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'g' ? IDLTokenContext.WSTRING : null;
                    }
                }
                return null;
            }
            case '_': {
                if (n2 != 8 || cArray[n++] != '_') {
                    return null;
                }
                switch (cArray[n++]) {
                    case 'L': {
                        return cArray[n++] == 'I' && cArray[n++] == 'N' && cArray[n++] == 'E' && cArray[n++] == '_' && cArray[n++] == '_' ? IDLTokenContext.DIRECTIVE : null;
                    }
                    case 'F': {
                        return cArray[n++] == 'I' && cArray[n++] == 'L' && cArray[n++] == 'E' && cArray[n++] == '_' && cArray[n++] == '_' ? IDLTokenContext.DIRECTIVE : null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private boolean matchDirective() {
        if (this.offset - this.tokenOffset > 8) {
            return false;
        }
        if (this.offset - this.tokenOffset <= 0) {
            return false;
        }
        switch (this.buffer[this.tokenOffset + 0]) {
            case '#': {
                if (this.offset - this.tokenOffset <= 1) {
                    return false;
                }
                switch (this.buffer[this.tokenOffset + 1]) {
                    case 'd': {
                        return this.offset - this.tokenOffset == 7 && this.buffer[this.tokenOffset + 2] == 'e' && this.buffer[this.tokenOffset + 3] == 'f' && this.buffer[this.tokenOffset + 4] == 'i' && this.buffer[this.tokenOffset + 5] == 'n' && this.buffer[this.tokenOffset + 6] == 'e';
                    }
                    case 'e': {
                        if (this.offset - this.tokenOffset <= 2) {
                            return false;
                        }
                        switch (this.buffer[this.tokenOffset + 2]) {
                            case 'l': {
                                if (this.offset - this.tokenOffset <= 3) {
                                    return false;
                                }
                                switch (this.buffer[this.tokenOffset + 3]) {
                                    case 'i': {
                                        return this.offset - this.tokenOffset == 5 && this.buffer[this.tokenOffset + 4] == 'f';
                                    }
                                    case 's': {
                                        return this.offset - this.tokenOffset == 5 && this.buffer[this.tokenOffset + 4] == 'e';
                                    }
                                }
                            }
                            case 'n': {
                                return this.offset - this.tokenOffset == 6 && this.buffer[this.tokenOffset + 3] == 'd' && this.buffer[this.tokenOffset + 4] == 'i' && this.buffer[this.tokenOffset + 5] == 'f';
                            }
                        }
                    }
                    case 'i': {
                        if (this.offset - this.tokenOffset <= 2) {
                            return false;
                        }
                        switch (this.buffer[this.tokenOffset + 2]) {
                            case 'f': {
                                if (this.offset - this.tokenOffset <= 3) {
                                    return true;
                                }
                                switch (this.buffer[this.tokenOffset + 3]) {
                                    case 'd': {
                                        return this.offset - this.tokenOffset == 6 && this.buffer[this.tokenOffset + 4] == 'e' && this.buffer[this.tokenOffset + 5] == 'f';
                                    }
                                    case 'n': {
                                        return this.offset - this.tokenOffset == 7 && this.buffer[this.tokenOffset + 4] == 'd' && this.buffer[this.tokenOffset + 5] == 'e' && this.buffer[this.tokenOffset + 6] == 'f';
                                    }
                                }
                                return false;
                            }
                            case 'n': {
                                return this.offset - this.tokenOffset == 8 && this.buffer[this.tokenOffset + 3] == 'c' && this.buffer[this.tokenOffset + 4] == 'l' && this.buffer[this.tokenOffset + 5] == 'u' && this.buffer[this.tokenOffset + 6] == 'd' && this.buffer[this.tokenOffset + 7] == 'e';
                            }
                        }
                        return false;
                    }
                    case 'p': {
                        return this.offset - this.tokenOffset == 7 && this.buffer[this.tokenOffset + 2] == 'r' && this.buffer[this.tokenOffset + 3] == 'a' && this.buffer[this.tokenOffset + 4] == 'g' && this.buffer[this.tokenOffset + 5] == 'm' && this.buffer[this.tokenOffset + 6] == 'a';
                    }
                    case 'u': {
                        return this.offset - this.tokenOffset == 6 && this.buffer[this.tokenOffset + 2] == 'n' && this.buffer[this.tokenOffset + 3] == 'd' && this.buffer[this.tokenOffset + 4] == 'e' && this.buffer[this.tokenOffset + 5] == 'f';
                    }
                }
                return false;
            }
        }
        return false;
    }

    public String getStateName(int n) {
        switch (n) {
            case 1: {
                return "ISI_ERROR";
            }
            case 2: {
                return "ISI_TEXT";
            }
            case 4: {
                return "ISI_LINE_COMMENT";
            }
            case 5: {
                return "ISI_BLOCK_COMMENT";
            }
            case 6: {
                return "ISI_STRING";
            }
            case 7: {
                return "ISI_STRING_A_BSLASH";
            }
            case 8: {
                return "ISI_CHAR";
            }
            case 9: {
                return "ISI_CHAR_A_BSLASH";
            }
            case 10: {
                return "ISI_IDENTIFIER";
            }
            case 11: {
                return "ISA_SLASH";
            }
            case 12: {
                return "ISA_EQ";
            }
            case 13: {
                return "ISA_GT";
            }
            case 14: {
                return "ISA_GTGT";
            }
            case 15: {
                return "ISA_GTGTGT";
            }
            case 16: {
                return "ISA_LT";
            }
            case 17: {
                return "ISA_LTLT";
            }
            case 18: {
                return "ISA_PLUS";
            }
            case 19: {
                return "ISA_MINUS";
            }
            case 20: {
                return "ISA_STAR";
            }
            case 21: {
                return "ISA_STAR_I_BLOCK_COMMENT";
            }
            case 22: {
                return "ISA_PIPE";
            }
            case 23: {
                return "ISA_PERCENT";
            }
            case 24: {
                return "ISA_AND";
            }
            case 25: {
                return "ISA_XOR";
            }
            case 26: {
                return "ISA_EXCLAMATION";
            }
            case 27: {
                return "ISA_ZERO";
            }
            case 28: {
                return "ISI_INT";
            }
            case 29: {
                return "ISI_OCTAL";
            }
            case 30: {
                return "ISI_FLOAT";
            }
            case 31: {
                return "ISI_FLOAT_EXP";
            }
            case 32: {
                return "ISI_HEX";
            }
            case 33: {
                return "ISA_DOT";
            }
        }
        return super.getStateName(n);
    }
}

