/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.corba.idl.editor.indent;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.openide.text.IndentEngine;
import org.openide.text.NbDocument;

public class IDLIndentEngine
extends IndentEngine {
    private static final long serialVersionUID = 5378217893629944112L;
    public static final char L_CPAR = '{';
    public static final char R_CPAR = '}';
    private static final char NL = '\n';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char INDENT_CHAR = ' ';
    private static final String NL_STR = "\n";
    private static final int DEFAULT_TAB_WIDTH = 4;
    private int indentTabWidth = 4;

    public void setTabWidth(int n) {
        int n2 = this.indentTabWidth;
        this.indentTabWidth = n;
        this.firePropertyChange("tabWidth", new Integer(n2), new Integer(this.indentTabWidth));
    }

    public int getTabWidth() {
        return this.indentTabWidth;
    }

    protected boolean acceptMimeType(String string) {
        return "text/x-idl".equals(string);
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        if (document instanceof StyledDocument) {
            return new IDLFormater(document, n, writer);
        }
        return writer;
    }

    public int indentLine(Document document, int n) {
        if (!(document instanceof StyledDocument)) {
            return n;
        }
        try {
            int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)n);
            Element element = NbDocument.findLineRootElement((StyledDocument)((StyledDocument)document));
            Element element2 = element.getElement(n2);
            String string = document.getText(element2.getStartOffset(), n - element2.getStartOffset());
            char c = string.charAt(string.length() - 1);
            switch (c) {
                case '}': {
                    int n3 = string.length() - 2;
                    while (n3 >= 0) {
                        if (string.charAt(n3) != ' ' && string.charAt(n3) != '\t') break;
                        --n3;
                    }
                    if (n3 < 0) {
                        int n4;
                        StringWriter stringWriter = new StringWriter();
                        IDLFormater iDLFormater = new IDLFormater(document, n, stringWriter);
                        int n5 = iDLFormater.getIndentWidth() - this.indentTabWidth;
                        int n6 = n5 - (n4 = string.length() - 1);
                        if (n6 < 0) {
                            document.remove(element2.getStartOffset(), -n6);
                            return n + n6;
                        }
                        if (n6 > 0) {
                            String string2 = iDLFormater.generateIndent(n6);
                            document.insertString(element2.getStartOffset(), string2, null);
                            return n + n6;
                        }
                        return n;
                    }
                    return n;
                }
            }
            return n;
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
    }

    public int indentNewLine(Document document, int n) {
        if (!(document instanceof StyledDocument)) {
            return n;
        }
        try {
            document.insertString(n++, NL_STR, null);
            StringWriter stringWriter = new StringWriter();
            IDLFormater iDLFormater = new IDLFormater(document, n, stringWriter);
            String string = iDLFormater.generateIndent(iDLFormater.getIndentWidth());
            document.insertString(n, string, null);
            return n + string.length();
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
    }

    class IDLFormater
    extends FilterWriter {
        private int startingIndent;
        private int actualIndentSpaceSize;
        private int actualIndent;
        private int indentChars;
        private int state;

        public IDLFormater(Document document, int n, Writer writer) {
            super(writer);
            this.actualIndentSpaceSize = IDLIndentEngine.this.indentTabWidth;
            this.state = 0;
            int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)n);
            Element element = NbDocument.findLineRootElement((StyledDocument)((StyledDocument)document));
            int n3 = 0;
            while (n3 == 0) {
                this.actualIndent = 0;
                this.startingIndent = 0;
                if (--n2 < 0) break;
                try {
                    Element element2 = element.getElement(n2);
                    String string = document.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                    int n4 = 0;
                    while (n4 < string.length()) {
                        char c = string.charAt(n4);
                        block1 : switch (n3) {
                            case 0: {
                                switch (c) {
                                    case ' ': {
                                        ++this.startingIndent;
                                        break block1;
                                    }
                                    case '\t': {
                                        this.startingIndent += this.actualIndentSpaceSize;
                                        break block1;
                                    }
                                    case '{': {
                                        ++this.actualIndent;
                                        n3 = 1;
                                        break block1;
                                    }
                                    case '}': {
                                        n3 = 1;
                                        break block1;
                                    }
                                }
                                n3 = 1;
                                break;
                            }
                            case 1: {
                                switch (c) {
                                    case '{': {
                                        ++this.actualIndent;
                                        break block1;
                                    }
                                    case '}': {
                                        --this.actualIndent;
                                    }
                                }
                            }
                        }
                        ++n4;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.indentChars = Math.max(0, this.startingIndent + this.actualIndent * this.actualIndentSpaceSize);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            while (n3 < n2) {
                this.write(cArray[n3]);
                ++n3;
            }
        }

        public void write(char[] cArray) throws IOException {
            this.write(cArray, 0, cArray.length);
        }

        public void write(int n) throws IOException {
            block0 : switch (this.state) {
                case 0: {
                    switch (n) {
                        case 123: {
                            ++this.actualIndent;
                            this.state = 1;
                            this.writeIndent();
                            break block0;
                        }
                        case 125: {
                            --this.actualIndent;
                            this.state = 1;
                            this.indentChars -= this.actualIndentSpaceSize;
                            this.writeIndent();
                            break block0;
                        }
                        case 10: {
                            this.indentChars = Math.max(0, this.startingIndent + this.actualIndentSpaceSize * this.actualIndent);
                            break block0;
                        }
                        case 9: 
                        case 32: {
                            break block0;
                        }
                    }
                    this.state = 1;
                    this.writeIndent();
                    break;
                }
                case 1: {
                    switch (n) {
                        case 123: {
                            ++this.actualIndent;
                            break block0;
                        }
                        case 125: {
                            --this.actualIndent;
                            break block0;
                        }
                        case 10: {
                            this.indentChars = Math.max(0, this.startingIndent + this.actualIndentSpaceSize * this.actualIndent);
                            this.state = 0;
                        }
                    }
                }
            }
            if (this.state == 1 || n != 9 && n != 32) {
                super.write(n);
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            int n3 = n;
            while (n3 < n2) {
                this.write(string.charAt(n3));
                ++n3;
            }
        }

        public void write(String string) throws IOException {
            this.write(string, 0, string.length());
        }

        public int getIndentWidth() {
            return this.indentChars;
        }

        public String generateIndent(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            return stringBuffer.toString();
        }

        private void writeIndent() throws IOException {
            if (this.indentChars > 0) {
                String string = this.generateIndent(this.indentChars);
                super.write(string, 0, string.length());
            }
        }
    }
}

