/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.httpserver.GrantAccessEvent;
import org.netbeans.modules.httpserver.GrantAccessListener;
import org.netbeans.modules.httpserver.GrantAccessPanel;
import org.netbeans.modules.httpserver.HttpServerModule;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.HttpServer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class HttpServerSettings
extends SystemOption
implements HttpServer.Impl,
PropertyChangeListener {
    private static final int MAX_START_RETRIES = 20;
    private static int currentRetries = 0;
    protected static EventListenerList listenerList = new EventListenerList();
    static boolean inited = false;
    private static Hashtable whoAsking = new Hashtable();
    public static final int SERVER_STARTUP_TIMEOUT = 3000;
    public static final String LOCALHOST = "local";
    public static final String ANYHOST = "any";
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST_PROPERTY = "hostProperty";
    public static final String PROP_REPOSITORY_BASEURL = "repositoryBaseURL";
    public static final String PROP_CLASSPATH_BASEURL = "classpathBaseURL";
    public static final String PROP_JAVADOC_BASEURL = "javadocBaseURL";
    static final String PROP_WRAPPER_BASEURL = "wrapperBaseURL";
    public static final String PROP_RUNNING = "running";
    private static final String PROP_HOST = "host";
    private static final String PROP_GRANTED_ADDRESSES = "grantedAddresses";
    private static final String PROP_SHOW_GRANT_ACCESS = "showGrantAccess";
    private static final int DEFAULT_PORT = 8082;
    private static String host = "local";
    private static String repositoryBaseURL = "/repository/";
    private static String classpathBaseURL = "/classpath/";
    private static String javadocBaseURL = "/javadoc/";
    private static String wrapperBaseURL = "/resource/";
    private static String grantedAddresses = "";
    static boolean running = false;
    private static boolean startStopMessages = true;
    private static Properties mappedServlets = new Properties();
    public static HttpServerSettings OPTIONS = null;
    private static int lastUsedName = 0;
    private static HashMap nameMap = new HashMap();
    private static Object httpLock;
    static final long serialVersionUID = 7387407495740535307L;
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$HttpServerSettings;
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$GrantAccessListener;

    static final Object httpLock() {
        if (httpLock == null) {
            httpLock = new Object();
        }
        return httpLock;
    }

    protected void initialize() {
        super.initialize();
        this.addPropertyChangeListener(this);
    }

    private boolean isGlobal() {
        return false;
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings)).getString("CTL_HTTP_settings");
    }

    public boolean isRunning() {
        if (this.isWriteExternal()) {
            if (inited) {
                return running;
            }
            return true;
        }
        if (inited) {
            return running;
        }
        this.setRunning(false);
        return running;
    }

    void runSuccess() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            currentRetries = 0;
            running = true;
            HttpServerSettings.httpLock().notifyAll();
        }
    }

    void runFailure() {
        running = false;
        if (++currentRetries <= 20) {
            this.setPort(this.getPort() + 1);
            this.setRunning(true);
        } else {
            currentRetries = 0;
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings)).getString("MSG_HTTP_SERVER_START_FAIL"), 2));
            int n = this.getPort();
            if (n < 1024 && inited && Utilities.isUnix()) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings)).getString("MSG_onlyRootOnUnix"), 2));
            }
        }
    }

    private void restartIfNecessary(boolean bl) {
        if (this.isReadExternal()) {
            return;
        }
        if (running) {
            if (!bl) {
                this.setStartStopMessages(false);
            }
            HttpServerModule.stopHTTPServer();
            HttpServerModule.initHTTPServer();
        }
    }

    private String getCanonicalRelativeURL(String string) {
        String string2;
        if (string.length() == 0) {
            string2 = "/";
        } else {
            string2 = string.charAt(0) != '/' ? "/" + string : string;
            if (string2.charAt(string2.length() - 1) != '/') {
                string2 = string2 + "/";
            }
        }
        return string2;
    }

    public void setRunning(boolean bl) {
        if (this.isReadExternal()) {
            return;
        }
        inited = true;
        if (running == bl) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (bl) {
                HttpServerModule.initHTTPServer();
            } else {
                running = false;
                HttpServerModule.stopHTTPServer();
            }
        }
        this.firePropertyChange(PROP_RUNNING, new Boolean(!bl), new Boolean(bl));
    }

    public String getRepositoryBaseURL() {
        return repositoryBaseURL;
    }

    public void setRepositoryBaseURL(String string) {
        String string2 = this.getCanonicalRelativeURL(string);
        if (repositoryBaseURL.equals(string2)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            repositoryBaseURL = string2;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_REPOSITORY_BASEURL, null, repositoryBaseURL);
    }

    public String getClasspathBaseURL() {
        return classpathBaseURL;
    }

    public void setClasspathBaseURL(String string) {
        String string2 = this.getCanonicalRelativeURL(string);
        if (classpathBaseURL.equals(string2)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            classpathBaseURL = string2;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_CLASSPATH_BASEURL, null, classpathBaseURL);
    }

    public String getJavadocBaseURL() {
        return javadocBaseURL;
    }

    public void setJavadocBaseURL(String string) {
        String string2;
        String string3 = this.getCanonicalRelativeURL(string);
        if (javadocBaseURL.equals(string3)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            string2 = javadocBaseURL;
            javadocBaseURL = string3;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_JAVADOC_BASEURL, string2, javadocBaseURL);
    }

    public URL getJavadocURL(FileObject fileObject) throws MalformedURLException, UnknownHostException {
        try {
            this.setRunning(true);
            return new URL("http", this.getLocalHost(), this.getPort(), this.getJavadocBaseURL() + HttpServerSettings.mangle(fileObject.getFileSystem().getSystemName()) + "/" + fileObject.getPackageNameExt('/', '.'));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new MalformedURLException();
        }
    }

    String getWrapperBaseURL() {
        return wrapperBaseURL;
    }

    void setWrapperBaseURL(String string) {
        String string2;
        String string3 = this.getCanonicalRelativeURL(string);
        if (wrapperBaseURL.equals(string3)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            string2 = wrapperBaseURL;
            wrapperBaseURL = string3;
            this.restartIfNecessary(false);
        }
        this.firePropertyChange(PROP_WRAPPER_BASEURL, string2, wrapperBaseURL);
    }

    private String getGrantedAddresses() {
        return grantedAddresses;
    }

    public void setGrantedAddresses(String string) {
        grantedAddresses = string;
        this.firePropertyChange(PROP_HOST_PROPERTY, null, grantedAddresses);
    }

    public void setPort(int n) {
        Object object = this.getProperty(PROP_PORT);
        int n2 = object == null ? 8082 : (Integer)object;
        Object object2 = HttpServerSettings.httpLock();
        synchronized (object2) {
            object = this.putProperty(PROP_PORT, new Integer(n), false);
            if (object != null && n == (Integer)object) {
                return;
            }
            this.restartIfNecessary(true);
        }
        this.firePropertyChange(PROP_PORT, object, new Integer(n));
    }

    public int getPort() {
        Object object = this.getProperty(PROP_PORT);
        return object == null ? 8082 : (Integer)object;
    }

    public void setHost(String string) {
        if (string.equals(ANYHOST) || string.equals(LOCALHOST)) {
            host = string;
        }
        this.firePropertyChange(PROP_HOST_PROPERTY, null, host);
    }

    private String getHost() {
        return host;
    }

    public void setStartStopMessages(boolean bl) {
        startStopMessages = bl;
    }

    public boolean isStartStopMessages() {
        return startStopMessages;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings);
    }

    void firePropertyChange0(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2);
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public URL getRepositoryURL(FileObject fileObject) throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getRepositoryBaseURL() + fileObject.getPackageNameExt('/', '.'));
    }

    public URL getRepositoryRoot() throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getRepositoryBaseURL());
    }

    public URL getResourceURL(String string) throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getClasspathBaseURL() + (string.startsWith("/") ? string.substring(1) : string));
    }

    public URL getResourceRoot() throws MalformedURLException, UnknownHostException {
        this.setRunning(true);
        return new URL("http", this.getLocalHost(), this.getPort(), this.getClasspathBaseURL());
    }

    public void addGrantAccessListener(GrantAccessListener grantAccessListener) {
        listenerList.add(class$org$netbeans$modules$httpserver$GrantAccessListener == null ? (class$org$netbeans$modules$httpserver$GrantAccessListener = HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener")) : class$org$netbeans$modules$httpserver$GrantAccessListener, grantAccessListener);
    }

    public void removeGrantAccessListener(GrantAccessListener grantAccessListener) {
        listenerList.remove(class$org$netbeans$modules$httpserver$GrantAccessListener == null ? (class$org$netbeans$modules$httpserver$GrantAccessListener = HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener")) : class$org$netbeans$modules$httpserver$GrantAccessListener, grantAccessListener);
    }

    protected boolean fireGrantAccessEvent(InetAddress inetAddress, String string) {
        Object[] objectArray = listenerList.getListenerList();
        GrantAccessEvent grantAccessEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$netbeans$modules$httpserver$GrantAccessListener == null ? HttpServerSettings.class$("org.netbeans.modules.httpserver.GrantAccessListener") : class$org$netbeans$modules$httpserver$GrantAccessListener)) {
                if (grantAccessEvent == null) {
                    grantAccessEvent = new GrantAccessEvent(this, inetAddress, string);
                }
                ((GrantAccessListener)objectArray[n + 1]).grantAccess(grantAccessEvent);
            }
            n -= 2;
        }
        return grantAccessEvent == null ? false : grantAccessEvent.isGranted();
    }

    public boolean allowAccess(InetAddress inetAddress) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean allowAccess(InetAddress inetAddress, String string) {
        if (this.accessAllowedNow(inetAddress, string)) {
            return true;
        }
        Thread thread = null;
        Hashtable hashtable = whoAsking;
        synchronized (hashtable) {
            if (this.accessAllowedNow(inetAddress, string)) {
                return true;
            }
            thread = (Thread)whoAsking.get(inetAddress);
            if (thread == null) {
                thread = Thread.currentThread();
                whoAsking.put(inetAddress, thread);
            }
        }
        Class clazz = class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings;
        synchronized (clazz) {
            boolean bl;
            block14: {
                boolean bl2;
                block13: {
                    boolean bl3;
                    block12: {
                        if (thread != Thread.currentThread()) {
                            return this.accessAllowedNow(inetAddress, string);
                        }
                        try {
                            if (!this.isShowGrantAccessDialog()) {
                                bl3 = false;
                                Object var13_9 = null;
                                whoAsking.remove(inetAddress);
                                break block12;
                            }
                            String string2 = NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_AddAddress", (Object)inetAddress.getHostAddress());
                            GrantAccessPanel grantAccessPanel = new GrantAccessPanel(string2);
                            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)grantAccessPanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = HttpServerSettings.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"CTL_GrantAccessTitle"), true, 0, NotifyDescriptor.NO_OPTION, null);
                            dialogDescriptor.setMessageType(3);
                            Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
                            ((Component)dialog).setSize(580, 180);
                            dialog.show();
                            this.setShowGrantAccessDialog(grantAccessPanel.getShowDialog());
                            if (NotifyDescriptor.YES_OPTION.equals(dialogDescriptor.getValue())) {
                                this.appendAddressToGranted(inetAddress.getHostAddress());
                                bl2 = true;
                                break block13;
                            }
                            bl = false;
                            break block14;
                        }
                        catch (Throwable throwable) {
                            Object var13_12 = null;
                            whoAsking.remove(inetAddress);
                            throw throwable;
                        }
                    }
                    return bl3;
                }
                Object var13_10 = null;
                whoAsking.remove(inetAddress);
                return bl2;
            }
            Object var13_11 = null;
            whoAsking.remove(inetAddress);
            return bl;
        }
    }

    private boolean accessAllowedNow(InetAddress inetAddress, String string) {
        if (this.getHost().equals(ANYHOST)) {
            return true;
        }
        HashSet hashSet = this.getGrantedAddressesSet();
        if (hashSet.contains(inetAddress.getHostAddress())) {
            return true;
        }
        return this.fireGrantAccessEvent(inetAddress, string);
    }

    private void appendAddressToGranted(String string) {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String string2 = this.getGrantedAddresses().trim();
            if (string2.length() > 0 && string2.charAt(string2.length() - 1) != ';' && string2.charAt(string2.length() - 1) != ',') {
                string2 = string2 + ',';
            }
            string2 = string2 + string;
            this.setGrantedAddresses(string2);
        }
    }

    HashSet getGrantedAddressesSet() {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            hashSet.add(InetAddress.getByName("localhost").getHostAddress());
            hashSet.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.getGrantedAddresses(), ",;");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            string = string.trim();
            try {
                hashSet.add(InetAddress.getByName(string).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    Properties getMappedServlets() {
        return mappedServlets;
    }

    static String mangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (Character.isLetterOrDigit(string.charAt(n)) || string.charAt(n) == '.') {
                stringBuffer.append(string.charAt(n));
            } else {
                String string2 = Integer.toHexString(string.charAt(n)).toUpperCase();
                if (string2.length() < 2) {
                    string2 = string2.length() == 0 ? "00" : "0" + string2;
                }
                stringBuffer.append("%").append(string2.length() == 2 ? string2 : string2.substring(string2.length() - 2));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String demangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '%') {
                    stringBuffer.append(string.charAt(n));
                } else {
                    stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                    n += 2;
                }
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return "";
        }
        return stringBuffer.toString();
    }

    public HostProperty getHostProperty() {
        return new HostProperty(grantedAddresses, host);
    }

    public void setHostProperty(HostProperty hostProperty) {
        if (ANYHOST.equals(hostProperty.getHost()) || LOCALHOST.equals(hostProperty.getHost())) {
            grantedAddresses = hostProperty.getGrantedAddresses();
            host = hostProperty.getHost();
            this.firePropertyChange(PROP_HOST_PROPERTY, null, hostProperty);
        }
    }

    public boolean isShowGrantAccessDialog() {
        Boolean bl = (Boolean)this.getProperty(PROP_SHOW_GRANT_ACCESS);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public void setShowGrantAccessDialog(boolean bl) {
        this.putProperty(PROP_SHOW_GRANT_ACCESS, new Boolean(bl), true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isReadExternal() || !this.equals(propertyChangeEvent.getSource())) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (PROP_CLASSPATH_BASEURL.equals(string) || PROP_JAVADOC_BASEURL.equals(string) || PROP_REPOSITORY_BASEURL.equals(string)) {
            boolean bl = this.getClasspathBaseURL().startsWith(this.getJavadocBaseURL());
            bl |= this.getClasspathBaseURL().startsWith(this.getRepositoryBaseURL());
            bl |= this.getJavadocBaseURL().startsWith(this.getClasspathBaseURL());
            bl |= this.getJavadocBaseURL().startsWith(this.getRepositoryBaseURL());
            bl |= this.getRepositoryBaseURL().startsWith(this.getClasspathBaseURL());
            if (bl |= this.getRepositoryBaseURL().startsWith(this.getJavadocBaseURL())) {
                RequestProcessor.postRequest((Runnable)new Runnable(){
                    static /* synthetic */ Class class$org$netbeans$modules$httpserver$HttpServerSettings;

                    public void run() {
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = 1.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings), (String)"MSG_MappingsConflict")));
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HostProperty
    implements Serializable {
        private String grantedAddresses;
        private String host;
        private static final long serialVersionUID = 1927848926692414249L;

        HostProperty(String string, String string2) {
            this.grantedAddresses = string;
            this.host = string2;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String string) {
            this.host = string;
        }

        public String getGrantedAddresses() {
            return this.grantedAddresses;
        }

        public void setGrantedAddresses(String string) {
            this.grantedAddresses = string;
        }
    }
}

