/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public class WizardDescriptor
extends DialogDescriptor {
    public static final Object NEXT_OPTION = new Object();
    public static final Object FINISH_OPTION = NotifyDescriptor.OK_OPTION;
    public static final Object PREVIOUS_OPTION = new Object();
    private final JButton nextButton = new JButton();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton previousButton = new JButton();
    private static final ActionListener CLOSE_PREVENTER = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_HELP_DISPLAYED = "WizardPanel_helpDisplayed";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_BACK_COLOR = "WizardPanel_contentBackColor";
    private static final String PROP_CONTENT_FOREGROUND_COLOR = "WizardPanel_contentForegroundColor";
    private static final String PROP_IMAGE = "WizardPanel_image";
    private static final String PROP_IMAGE_ALIGNMENT = "WizardPanel_imageAlignment";
    private static final String PROP_LEFT_DIMENSION = "WizardPanel_leftDimension";
    private static final String PROP_HELP_URL = "WizardPanel_helpURL";
    private static WeakReference defaultImage;
    private boolean autoWizardStyle;
    private boolean init;
    private WizardPanel wizardPanel;
    private Image image;
    private String[] contentData;
    private int contentSelectedIndex;
    private Color contentBackColor;
    private Color contentForegroundColor;
    private URL helpURL;
    private PropL propListener;
    private boolean useDefaultImage;
    private String imageAlignment;
    private Iterator panels;
    private Listener listener;
    private Panel current;
    private Object settings;
    private MessageFormat titleFormat;
    private Map properties;
    private static final Set warnedPanelIsComponent;
    ResourceBundle bundle;
    static /* synthetic */ Class class$org$openide$WizardDescriptor;

    public WizardDescriptor(Panel[] panelArray, Object object) {
        this(new ArrayIterator(panelArray), object);
    }

    public WizardDescriptor(Panel[] panelArray) {
        this(panelArray, (Object)CLOSE_PREVENTER);
    }

    public WizardDescriptor(Iterator iterator, Object object) {
        super((Object)"", "", true, -1, null, CLOSE_PREVENTER);
        ResourceBundle resourceBundle = NbBundle.getBundle("org.openide.Bundle");
        this.nextButton.setText(resourceBundle.getString("CTL_NEXT"));
        this.previousButton.setText(resourceBundle.getString("CTL_PREVIOUS"));
        this.finishButton.setText(resourceBundle.getString("CTL_FINISH"));
        this.finishButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FINISH"));
        this.cancelButton.setText(resourceBundle.getString("CTL_CANCEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CANCEL"));
        this.previousButton.setMnemonic(resourceBundle.getString("CTL_PREVIOUS_Mnemonic").charAt(0));
        this.finishButton.setMnemonic(resourceBundle.getString("CTL_FINISH_Mnemonic").charAt(0));
        this.finishButton.setDefaultCapable(true);
        this.nextButton.setDefaultCapable(true);
        this.previousButton.setDefaultCapable(false);
        this.cancelButton.setDefaultCapable(false);
        this.autoWizardStyle = false;
        this.init = false;
        this.contentData = new String[0];
        this.contentSelectedIndex = -1;
        this.useDefaultImage = true;
        this.imageAlignment = "North";
        this.bundle = NbBundle.getBundle(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor);
        this.settings = object == CLOSE_PREVENTER ? this : object;
        this.listener = new Listener();
        this.nextButton.addActionListener(this.listener);
        this.previousButton.addActionListener(this.listener);
        this.finishButton.addActionListener(this.listener);
        this.cancelButton.addActionListener(this.listener);
        super.setOptions(new Object[]{this.previousButton, this.nextButton, this.finishButton, this.cancelButton});
        super.setClosingOptions(new Object[]{this.finishButton, this.cancelButton});
        this.panels = iterator;
        iterator.addChangeListener(this.listener);
    }

    public WizardDescriptor(Iterator iterator) {
        this(iterator, (Object)CLOSE_PREVENTER);
    }

    protected void initialize() {
        super.initialize();
        this.updateState();
    }

    public final synchronized void setPanels(Iterator iterator) {
        if (iterator != null) {
            iterator.removeChangeListener(this.listener);
        }
        this.panels = iterator;
        iterator.addChangeListener(this.listener);
        this.init = false;
        this.updateState();
    }

    public void setOptions(Object[] objectArray) {
        super.setOptions(this.convertOptions(objectArray));
    }

    public void setAdditionalOptions(Object[] objectArray) {
        super.setAdditionalOptions(this.convertOptions(objectArray));
    }

    public void setClosingOptions(Object[] objectArray) {
        super.setClosingOptions(this.convertOptions(objectArray));
    }

    private Object[] convertOptions(Object[] objectArray) {
        objectArray = (Object[])objectArray.clone();
        int n = objectArray.length - 1;
        while (n >= 0) {
            if (objectArray[n] == NEXT_OPTION) {
                objectArray[n] = this.nextButton;
            }
            if (objectArray[n] == PREVIOUS_OPTION) {
                objectArray[n] = this.previousButton;
            }
            if (objectArray[n] == FINISH_OPTION) {
                objectArray[n] = this.finishButton;
            }
            if (objectArray[n] == NotifyDescriptor.CANCEL_OPTION) {
                objectArray[n] = this.cancelButton;
            }
            --n;
        }
        return objectArray;
    }

    public Object getValue() {
        return this.backConvertOption(super.getValue());
    }

    private Object backConvertOption(Object object) {
        if (object == this.nextButton) {
            return NEXT_OPTION;
        }
        if (object == this.previousButton) {
            return PREVIOUS_OPTION;
        }
        if (object == this.finishButton) {
            return FINISH_OPTION;
        }
        if (object == this.cancelButton) {
            return NotifyDescriptor.CANCEL_OPTION;
        }
        return object;
    }

    public void setTitleFormat(MessageFormat messageFormat) {
        this.titleFormat = messageFormat;
        if (this.init) {
            this.updateState();
        }
    }

    public synchronized MessageFormat getTitleFormat() {
        if (this.titleFormat == null) {
            this.titleFormat = new MessageFormat(NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "CTL_WizardName"));
        }
        return this.titleFormat;
    }

    public void putProperty(final String string, Object object) {
        WizardDescriptor wizardDescriptor = this;
        synchronized (wizardDescriptor) {
            if (this.properties == null) {
                this.properties = new HashMap(7);
            }
            this.properties.put(string, object);
        }
        if (this.propListener != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    WizardDescriptor.this.propListener.propertyChange(new PropertyChangeEvent(this, string, null, null));
                }
            });
        }
    }

    public synchronized Object getProperty(String string) {
        return this.properties == null ? null : this.properties.get(string);
    }

    public void setHelpCtx(HelpCtx helpCtx) {
        if (this.wizardPanel != null && helpCtx != null) {
            HelpCtx.setHelpIDString(this.wizardPanel, helpCtx.getHelpID());
        }
        super.setHelpCtx(helpCtx);
    }

    protected synchronized void updateState() {
        Object object;
        Panel panel = this.panels.current();
        if (this.current != panel) {
            if (this.current != null) {
                this.current.removeChangeListener(this.listener);
                this.current.storeSettings(this.settings);
            }
            panel = this.panels.current();
            panel.addChangeListener(this.listener);
            this.current = panel;
            this.current.readSettings(this.settings);
        }
        boolean bl = this.panels.hasNext();
        boolean bl2 = this.panels.hasPrevious();
        boolean bl3 = panel.isValid();
        this.nextButton.setEnabled(bl && bl3);
        this.previousButton.setEnabled(bl2);
        this.finishButton.setEnabled(bl3 && (!bl || this.current instanceof FinishPanel));
        if (bl) {
            this.setValue(this.nextButton);
        }
        this.setHelpCtx(panel.getHelp());
        Component component = panel.getComponent();
        if (component == null || component instanceof Window) {
            throw new IllegalStateException("Wizard panel " + panel + " gave a strange component " + component);
        }
        if (component == panel) {
            WizardDescriptor.warnPanelIsComponent(panel.getClass());
        }
        if (!this.init) {
            if (component instanceof JComponent) {
                this.autoWizardStyle = this.getBooleanProperty((JComponent)component, PROP_AUTO_WIZARD_STYLE);
                if (this.autoWizardStyle) {
                    this.wizardPanel = new WizardPanel(this.getBooleanProperty((JComponent)component, PROP_CONTENT_DISPLAYED), this.getBooleanProperty((JComponent)component, PROP_HELP_DISPLAYED), this.getBooleanProperty((JComponent)component, PROP_CONTENT_NUMBERED), this.getLeftDimension((JComponent)component));
                    this.initBundleProperties();
                }
            }
            if (this.propListener == null) {
                this.propListener = new PropL();
            }
            this.init = true;
        }
        if (this.wizardPanel != null) {
            object = this.wizardPanel.getRightComponent();
            if (object != null) {
                ((Component)object).removePropertyChangeListener(this.propListener);
            }
            if (component instanceof JComponent) {
                this.setPanelProperties((JComponent)component);
                this.wizardPanel.setContent(this.contentData);
                this.wizardPanel.setSelectedIndex(this.contentSelectedIndex);
                this.wizardPanel.setContentBackColor(this.contentBackColor);
                this.wizardPanel.setContentForegroundColor(this.contentForegroundColor);
                this.wizardPanel.setImage(this.image);
                this.wizardPanel.setImageAlignment(this.imageAlignment);
                this.wizardPanel.setHelpURL(this.helpURL);
                this.updateButtonAccessibleDescription();
                component.addPropertyChangeListener(this.propListener);
            }
            if (this.wizardPanel.getRightComponent() != component) {
                this.wizardPanel.setRightComponent(component);
                if (this.wizardPanel != this.getMessage()) {
                    this.setMessage(this.wizardPanel);
                } else {
                    this.firePropertyChange("message", null, this.wizardPanel);
                }
            }
        } else if (component != this.getMessage()) {
            this.setMessage(component);
        }
        if ((object = component.getName()) == null) {
            object = "";
        }
        Object[] objectArray = new Object[]{object, this.panels.name()};
        MessageFormat messageFormat = this.getTitleFormat();
        if (this.autoWizardStyle) {
            this.wizardPanel.setPanelName(messageFormat.format(objectArray));
        } else {
            this.setTitle(messageFormat.format(objectArray));
        }
    }

    private static synchronized void warnPanelIsComponent(Class clazz) {
        if (warnedPanelIsComponent.add(clazz)) {
            ErrorManager.getDefault().log(16, "WARNING - the WizardDescriptor.Panel implementation " + clazz.getName() + " provides itself as the result of getComponent(). This can cause a clash when Component.isValid() is overridden. Please use a separate component class.");
        }
    }

    private boolean getBooleanProperty(JComponent jComponent, String string) {
        Object object = this.getProperty(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        object = jComponent.getClientProperty(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private Dimension getLeftDimension(JComponent jComponent) {
        Object object = jComponent.getClientProperty(PROP_LEFT_DIMENSION);
        Dimension dimension = object instanceof Dimension ? (Dimension)object : new Dimension(198, 233);
        return dimension;
    }

    private void setPanelProperties(JComponent jComponent) {
        Object object = this.getProperty(PROP_CONTENT_SELECTED_INDEX);
        if (object instanceof Integer) {
            this.contentSelectedIndex = (Integer)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_SELECTED_INDEX);
            if (object instanceof Integer) {
                this.contentSelectedIndex = (Integer)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_DATA);
        if (object instanceof String[]) {
            this.contentData = (String[])object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_DATA);
            if (object instanceof String[]) {
                this.contentData = (String[])object;
            }
        }
        object = this.getProperty(PROP_IMAGE);
        if (object instanceof Image) {
            this.image = (Image)object;
        } else if (this.properties == null || !this.properties.containsKey(PROP_IMAGE)) {
            object = jComponent.getClientProperty(PROP_IMAGE);
            if (object instanceof Image) {
                this.image = (Image)object;
            } else if (this.image == null) {
                this.useDefaultImage = true;
            }
        } else {
            this.useDefaultImage = false;
        }
        object = this.getProperty(PROP_IMAGE_ALIGNMENT);
        if (object instanceof String) {
            this.imageAlignment = (String)object;
        } else {
            object = jComponent.getClientProperty(PROP_IMAGE_ALIGNMENT);
            if (object instanceof String) {
                this.imageAlignment = (String)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_BACK_COLOR);
        if (object instanceof Color) {
            this.contentBackColor = (Color)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_BACK_COLOR);
            if (object instanceof Color) {
                this.contentBackColor = (Color)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_FOREGROUND_COLOR);
        if (object instanceof Color) {
            this.contentForegroundColor = (Color)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_FOREGROUND_COLOR);
            if (object instanceof Color) {
                this.contentForegroundColor = (Color)object;
            }
        }
        object = jComponent.getClientProperty(PROP_HELP_URL);
        if (object instanceof URL) {
            this.helpURL = (URL)object;
        } else if (object == null) {
            this.helpURL = null;
        }
    }

    private void initBundleProperties() {
        this.contentBackColor = new Color(this.getIntFromBundle("INT_WizardBackRed"), this.getIntFromBundle("INT_WizardBackGreen"), this.getIntFromBundle("INT_WizardBackBlue"));
        this.contentForegroundColor = new Color(this.getIntFromBundle("INT_WizardForegroundRed"), this.getIntFromBundle("INT_WizardForegroundGreen"), this.getIntFromBundle("INT_WizardForegroundBlue"));
        this.imageAlignment = this.bundle.getString("STRING_WizardImageAlignment");
    }

    public void setValue(Object object) {
        super.setValue(this.backConvertOption(object));
        if (object == NotifyDescriptor.CLOSED_OPTION) {
            this.resetWizard();
        }
    }

    private void resetWizard() {
        if (this.current != null) {
            this.current.storeSettings(this.settings);
            this.current.removeChangeListener(this.listener);
            this.current = null;
            if (this.wizardPanel != null) {
                this.wizardPanel.resetPreferredSize();
            }
        }
    }

    private int getIntFromBundle(String string) {
        return Integer.parseInt(this.bundle.getString(string));
    }

    private static Image getDefaultImage() {
        Image image = null;
        if (defaultImage != null) {
            image = (Image)defaultImage.get();
        }
        if (image == null) {
            URL uRL = NbBundle.getLocalizedFile("org.openide.resources.defaultWizard", "gif");
            Image image2 = image = uRL == null ? null : Toolkit.getDefaultToolkit().getImage(uRL);
            if (image != null) {
                defaultImage = new WeakReference<Image>(image);
            }
        }
        return image;
    }

    private void updateButtonAccessibleDescription() {
        String string = this.contentData != null && this.contentSelectedIndex > 0 && this.contentSelectedIndex - 1 < this.contentData.length ? this.contentData[this.contentSelectedIndex - 1] : "";
        this.previousButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "ACSD_PREVIOUS", new Integer(this.contentSelectedIndex), string));
        string = this.contentData != null && this.contentSelectedIndex < this.contentData.length - 1 && this.contentSelectedIndex + 1 >= 0 ? this.contentData[this.contentSelectedIndex + 1] : "";
        this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "ACSD_NEXT", new Integer(this.contentSelectedIndex + 2), string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        warnedPanelIsComponent = new WeakSet();
    }

    private static class BoundedHtmlBrowser
    extends HtmlBrowser {
        Dimension dim;
        boolean firstPage = true;

        public BoundedHtmlBrowser(Dimension dimension) {
            super(false, false);
            this.dim = dimension;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }
    }

    private static class WizardPanel
    extends JPanel {
        private JPanel rightPanel = new JPanel(new BorderLayout());
        private JLabel panelName = new JLabel("Step");
        private JList contentList;
        private Component rightComponent;
        private ImagedPanel contentPanel;
        private JPanel contentLabelPanel;
        private WrappedCellRenderer cellRenderer;
        private JTabbedPane tabbedPane;
        private HtmlBrowser htmlBrowser;
        private Dimension cachedDimension;
        private JLabel label;
        private int selectedIndex;
        static /* synthetic */ Class class$org$openide$WizardDescriptor;

        public WizardPanel(boolean bl, boolean bl2, boolean bl3, Dimension dimension) {
            super(new BorderLayout());
            this.initComponents(bl, bl2, bl3, dimension);
            this.setOpaque(false);
            this.resetPreferredSize();
        }

        private void initComponents(boolean bl, boolean bl2, boolean bl3, Dimension dimension) {
            if (bl) {
                this.createContentPanel(bl3, dimension);
                if (!bl2) {
                    this.add((Component)this.contentPanel, "West");
                }
            }
            if (bl2) {
                this.htmlBrowser = new BoundedHtmlBrowser(dimension);
                this.htmlBrowser.setPreferredSize(dimension);
                if (!bl) {
                    this.add((Component)this.htmlBrowser, "West");
                }
            }
            if (bl2 && bl) {
                this.tabbedPane = new JTabbedPane(3);
                this.tabbedPane.addTab(NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardPanel.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "CTL_ContentName"), this.contentPanel);
                this.tabbedPane.addTab(NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardPanel.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "CTL_HelpName"), this.htmlBrowser);
                this.tabbedPane.setEnabledAt(1, false);
                this.tabbedPane.setOpaque(false);
                this.add((Component)this.tabbedPane, "West");
            }
            this.panelName.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.panelName.getForeground()));
            this.panelName.setFont(this.panelName.getFont().deriveFont(1));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.panelName, "North");
            jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 11));
            this.rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 11, 11));
            this.panelName.setLabelFor(jPanel);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)this.rightPanel, "Center");
            JSeparator jSeparator = new JSeparator();
            jSeparator.setForeground(Color.darkGray);
            this.add((Component)jPanel2, "Center");
            this.add((Component)jSeparator, "South");
        }

        private void createContentPanel(boolean bl, Dimension dimension) {
            this.contentList = new JList();
            this.cellRenderer = new WrappedCellRenderer(bl, dimension.width);
            this.cellRenderer.setOpaque(false);
            this.contentList.setCellRenderer(this.cellRenderer);
            this.contentList.setOpaque(false);
            this.contentList.setEnabled(false);
            this.contentList.getAccessibleContext().setAccessibleDescription("");
            JScrollPane jScrollPane = new JScrollPane(this.contentList);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.getViewport().setOpaque(false);
            jScrollPane.setBorder(null);
            jScrollPane.setOpaque(false);
            this.label = new JLabel(NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardPanel.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "CTL_ContentName"));
            this.label.setForeground(Color.white);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.contentLabelPanel = new JPanel(new BorderLayout());
            this.contentLabelPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
            this.contentLabelPanel.setOpaque(false);
            this.contentLabelPanel.add((Component)this.label, "North");
            this.contentPanel = new ImagedPanel(null);
            this.contentPanel.add((Component)this.contentLabelPanel, "North");
            this.contentPanel.add((Component)jScrollPane, "Center");
            this.contentPanel.setPreferredSize(dimension);
            this.label.setLabelFor(this.contentList);
        }

        public void setContent(String[] stringArray) {
            JList jList = this.contentList;
            if (jList == null) {
                return;
            }
            Mutex.EVENT.writeAccess(new Runnable(this, jList, stringArray){
                private final /* synthetic */ JList val$list;
                private final /* synthetic */ String[] val$content;
                private final /* synthetic */ WizardPanel this$0;
                {
                    this.this$0 = wizardPanel;
                    this.val$list = jList;
                    this.val$content = stringArray;
                }

                public void run() {
                    this.val$list.setListData(this.val$content);
                    this.val$list.revalidate();
                    this.val$list.repaint();
                    WizardPanel.access$2100(this.this$0).setVisible(this.val$content.length > 0);
                }
            });
        }

        public void setSelectedIndex(int n) {
            this.selectedIndex = n;
            if (this.cellRenderer != null) {
                this.cellRenderer.setSelectedIndex(n);
                JList jList = this.contentList;
                if (jList == null) {
                    return;
                }
                Mutex.EVENT.readAccess(new Runnable(this, jList, n){
                    private final /* synthetic */ JList val$list;
                    private final /* synthetic */ int val$index;
                    private final /* synthetic */ WizardPanel this$0;
                    {
                        this.this$0 = wizardPanel;
                        this.val$list = jList;
                        this.val$index = n;
                    }

                    public void run() {
                        this.val$list.ensureIndexIsVisible(this.val$index);
                        this.val$list.setFixedCellWidth(0);
                        this.val$list.setFixedCellWidth(-1);
                    }
                });
            }
        }

        public void setContentBackColor(Color color) {
            if (this.contentPanel != null) {
                this.contentPanel.setBackground(color);
            }
        }

        public void setContentForegroundColor(Color color) {
            if (this.cellRenderer == null) {
                return;
            }
            this.cellRenderer.setForegroundColor(color);
            this.label.setForeground(color);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
        }

        public void setImage(Image image) {
            if (this.contentPanel != null) {
                this.contentPanel.setImage(image);
            }
        }

        public void setImageAlignment(String string) {
            if (this.contentPanel != null) {
                this.contentPanel.setImageAlignment(string);
            }
        }

        public void setRightComponent(Component component) {
            if (this.rightComponent != null) {
                this.rightPanel.remove(this.rightComponent);
            }
            this.rightComponent = component;
            this.rightPanel.add(this.rightComponent, "Center");
        }

        public Component getRightComponent() {
            return this.rightComponent;
        }

        public void setPanelName(String string) {
            this.panelName.setText(string);
        }

        public void setHelpURL(URL uRL) {
            if (this.htmlBrowser == null) {
                return;
            }
            if (uRL != null) {
                if (!uRL.equals(this.htmlBrowser.getDocumentURL())) {
                    this.htmlBrowser.setURL(uRL);
                }
                if (this.tabbedPane != null) {
                    this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.htmlBrowser), true);
                }
            } else if (this.tabbedPane != null) {
                this.tabbedPane.setSelectedComponent(this.contentPanel);
                this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.htmlBrowser), false);
            }
        }

        public void resetPreferredSize() {
            this.cachedDimension = new Dimension(600, 365);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.height > this.cachedDimension.height) {
                this.cachedDimension.height = dimension.height;
            }
            if (dimension.width > this.cachedDimension.width) {
                this.cachedDimension.width = dimension.width;
            }
            return this.cachedDimension;
        }

        public void requestFocus() {
            if (this.rightComponent != null) {
                this.rightComponent.requestFocus();
            } else {
                super.requestFocus();
            }
        }

        public boolean requestDefaultFocus() {
            if (this.rightComponent instanceof JComponent) {
                return ((JComponent)this.rightComponent).requestDefaultFocus();
            }
            return super.requestDefaultFocus();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleWizardPanel();
            }
            return this.accessibleContext;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ JPanel access$2100(WizardPanel wizardPanel) {
            return wizardPanel.contentLabelPanel;
        }

        private class AccessibleWizardPanel
        extends JPanel.AccessibleJPanel {
            static /* synthetic */ Class class$org$openide$WizardDescriptor;

            private AccessibleWizardPanel() {
                super(WizardPanel.this);
            }

            public String getAccessibleDescription() {
                if (this.accessibleDescription != null) {
                    return this.accessibleDescription;
                }
                if (WizardPanel.this.rightComponent instanceof Accessible) {
                    if (WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription() == null) {
                        return null;
                    }
                    return NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = AccessibleWizardPanel.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "ACSD_WizardPanel", new Integer(WizardPanel.this.selectedIndex + 1), WizardPanel.this.panelName.getText(), WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription());
                }
                return super.getAccessibleDescription();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }

    private static class WrappedCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JTextArea ta = new JTextArea();
        JLabel numberLabel;
        int selected = -1;
        boolean contentNumbered;
        int taWidth;

        private WrappedCellRenderer(boolean bl, int n) {
            super(new BorderLayout());
            this.contentNumbered = bl;
            this.ta.setOpaque(false);
            this.ta.setEditable(false);
            this.ta.setLineWrap(true);
            this.ta.setWrapStyleWord(true);
            this.ta.setFont(UIManager.getFont("Label.font"));
            this.ta.getAccessibleContext().setAccessibleDescription("");
            this.taWidth = n - 12 - 12;
            this.numberLabel = new JLabel(this){
                private final /* synthetic */ WrappedCellRenderer this$0;
                {
                    this.this$0 = wrappedCellRenderer;
                }

                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (!this.this$0.contentNumbered) {
                        Rectangle rectangle = graphics.getClipBounds();
                        graphics.fillOval(rectangle.x, rectangle.y, 7, 7);
                    }
                }
            };
            this.numberLabel.setLabelFor(this.ta);
            this.numberLabel.setHorizontalAlignment(2);
            this.numberLabel.setVerticalAlignment(1);
            this.numberLabel.setFont(this.ta.getFont());
            this.numberLabel.setOpaque(false);
            this.numberLabel.setPreferredSize(new Dimension(25, 0));
            this.add((Component)this.numberLabel, "West");
            this.taWidth -= 25;
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.add((Component)this.ta, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n == this.selected) {
                this.numberLabel.setFont(this.numberLabel.getFont().deriveFont(1));
                this.ta.setFont(this.ta.getFont().deriveFont(1));
            } else {
                this.numberLabel.setFont(this.numberLabel.getFont().deriveFont(0));
                this.ta.setFont(this.ta.getFont().deriveFont(0));
            }
            if (this.contentNumbered) {
                this.numberLabel.setText(Integer.toString(n + 1) + ".");
            }
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.ta.setText((String)object);
            return this;
        }

        private void setSelectedIndex(int n) {
            this.selected = n;
        }

        private void setForegroundColor(Color color) {
            if (this.numberLabel != null) {
                this.numberLabel.setForeground(color);
                this.numberLabel.setBackground(color);
            }
            this.ta.setForeground(color);
        }
    }

    private static class ImagedPanel
    extends JComponent
    implements Accessible {
        Image image;
        boolean isDefault = false;
        boolean north = true;

        public ImagedPanel(Image image) {
            this.setImage(image);
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image != null) {
                graphics.drawImage(this.image, 0, this.north ? 0 : this.getHeight() - this.image.getHeight(null), null);
            }
        }

        public void setImageAlignment(String string) {
            this.north = "North".equals(string);
        }

        public void setImage(Image image) {
            if (image != null) {
                this.image = image;
                this.isDefault = false;
                return;
            }
            if (!this.isDefault) {
                this.image = new ImageIcon(WizardDescriptor.getDefaultImage()).getImage();
                this.isDefault = true;
            }
        }
    }

    private class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (WizardDescriptor.this.wizardPanel == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            WizardDescriptor.this.setPanelProperties((JComponent)WizardDescriptor.this.wizardPanel.getRightComponent());
            if (string.equals(WizardDescriptor.PROP_CONTENT_DATA)) {
                WizardDescriptor.this.wizardPanel.setContent(WizardDescriptor.this.contentData);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (string.equals(WizardDescriptor.PROP_CONTENT_SELECTED_INDEX)) {
                WizardDescriptor.this.wizardPanel.setSelectedIndex(WizardDescriptor.this.contentSelectedIndex);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (string.equals(WizardDescriptor.PROP_CONTENT_BACK_COLOR)) {
                WizardDescriptor.this.wizardPanel.setContentBackColor(WizardDescriptor.this.contentBackColor);
            } else if (string.equals(WizardDescriptor.PROP_CONTENT_FOREGROUND_COLOR)) {
                WizardDescriptor.this.wizardPanel.setContentForegroundColor(WizardDescriptor.this.contentForegroundColor);
            } else if (string.equals(WizardDescriptor.PROP_IMAGE)) {
                WizardDescriptor.this.wizardPanel.setImage(WizardDescriptor.this.image);
            } else if (string.equals(WizardDescriptor.PROP_IMAGE_ALIGNMENT)) {
                WizardDescriptor.this.wizardPanel.setImageAlignment(WizardDescriptor.this.imageAlignment);
            } else if (string.equals(WizardDescriptor.PROP_HELP_URL)) {
                WizardDescriptor.this.wizardPanel.setHelpURL(WizardDescriptor.this.helpURL);
            }
        }
    }

    private final class Listener
    implements ChangeListener,
    ActionListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            WizardDescriptor.this.updateState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == WizardDescriptor.this.nextButton) {
                WizardDescriptor.this.panels.nextPanel();
                try {
                    WizardDescriptor.this.updateState();
                }
                catch (IllegalStateException illegalStateException) {
                    WizardDescriptor.this.panels.previousPanel();
                    if (illegalStateException.getMessage() != null) {
                        TopManager.getDefault().notify(new NotifyDescriptor.Message(illegalStateException.getMessage()));
                    } else {
                        ErrorManager.getDefault().notify(illegalStateException);
                    }
                    WizardDescriptor.this.updateState();
                }
            }
            if (actionEvent.getSource() == WizardDescriptor.this.previousButton) {
                WizardDescriptor.this.panels.previousPanel();
                WizardDescriptor.this.updateState();
            }
            if (actionEvent.getSource() == WizardDescriptor.this.finishButton) {
                if (Arrays.asList(WizardDescriptor.this.getClosingOptions()).contains(WizardDescriptor.this.finishButton)) {
                    WizardDescriptor.this.resetWizard();
                }
                WizardDescriptor.this.setValue(NotifyDescriptor.OK_OPTION);
            }
            if (actionEvent.getSource() == WizardDescriptor.this.cancelButton) {
                if (Arrays.asList(WizardDescriptor.this.getClosingOptions()).contains(WizardDescriptor.this.cancelButton)) {
                    WizardDescriptor.this.resetWizard();
                }
                WizardDescriptor.this.setValue(NotifyDescriptor.CANCEL_OPTION);
            }
        }
    }

    public static class ArrayIterator
    implements Iterator {
        private Panel[] panels;
        private int index;
        static /* synthetic */ Class class$org$openide$WizardDescriptor;

        public ArrayIterator() {
            this.panels = this.initializePanels();
            this.index = 0;
        }

        public ArrayIterator(Panel[] panelArray) {
            this.panels = panelArray;
            this.index = 0;
        }

        protected Panel[] initializePanels() {
            return new Panel[0];
        }

        public Panel current() {
            return this.panels[this.index];
        }

        public String name() {
            return NbBundle.getMessage(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = ArrayIterator.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor, "CTL_ArrayIteratorName", new Integer(this.index + 1), new Integer(this.panels.length));
        }

        public boolean hasNext() {
            return this.index < this.panels.length - 1;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public synchronized void nextPanel() {
            if (this.index + 1 == this.panels.length) {
                throw new NoSuchElementException();
            }
            ++this.index;
        }

        public synchronized void previousPanel() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        protected void reset() {
            this.index = 0;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static interface FinishPanel
    extends Panel {
    }

    public static interface Panel {
        public Component getComponent();

        public HelpCtx getHelp();

        public void readSettings(Object var1);

        public void storeSettings(Object var1);

        public boolean isValid();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    public static interface Iterator {
        public Panel current();

        public String name();

        public boolean hasNext();

        public boolean hasPrevious();

        public void nextPanel();

        public void previousPanel();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

