/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.actions.AddWatchAction;
import org.openide.actions.FinishDebuggerAction;
import org.openide.actions.GoAction;
import org.openide.actions.GoToCursorAction;
import org.openide.actions.StartDebuggerAction;
import org.openide.actions.StepOutAction;
import org.openide.actions.TraceIntoAction;
import org.openide.actions.TraceOverAction;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.DebuggerCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

class DebuggerPerformer
implements PropertyChangeListener {
    private static DebuggerPerformer defaultPerformer;
    private boolean installed = false;
    static /* synthetic */ Class class$org$openide$actions$TraceIntoAction;
    static /* synthetic */ Class class$org$openide$actions$TraceOverAction;
    static /* synthetic */ Class class$org$openide$actions$StepOutAction;
    static /* synthetic */ Class class$org$openide$actions$StartDebuggerAction;
    static /* synthetic */ Class class$org$openide$actions$GoAction;
    static /* synthetic */ Class class$org$openide$actions$FinishDebuggerAction;
    static /* synthetic */ Class class$org$openide$actions$GoToCursorAction;
    static /* synthetic */ Class class$org$openide$actions$AddWatchAction;

    static void notifyDebuggerException(DebuggerException debuggerException) {
        ErrorManager errorManager = ErrorManager.getDefault();
        Throwable throwable = debuggerException.getTargetException() == null ? debuggerException : debuggerException.getTargetException();
        errorManager.annotate(throwable, NbBundle.getMessage(class$org$openide$actions$TraceIntoAction == null ? (class$org$openide$actions$TraceIntoAction = DebuggerPerformer.class$("org.openide.actions.TraceIntoAction")) : class$org$openide$actions$TraceIntoAction, "FMT_EXC_Debugger", debuggerException.getMessage()));
        errorManager.notify(throwable);
    }

    static DebuggerPerformer getDefault() {
        if (defaultPerformer == null) {
            new DebuggerPerformer();
        }
        return defaultPerformer;
    }

    DebuggerPerformer() {
        if (defaultPerformer == null) {
            defaultPerformer = this;
        }
        TopManager.getDefault().addPropertyChangeListener(this);
        this.update();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("debugger")) {
            this.update();
            return;
        }
        if (!propertyChangeEvent.getPropertyName().equals("state")) {
            return;
        }
        try {
            switch (TopManager.getDefault().getDebugger().getState()) {
                case 1: {
                    ((TraceOverAction)SystemAction.get(class$org$openide$actions$TraceOverAction == null ? (class$org$openide$actions$TraceOverAction = DebuggerPerformer.class$("org.openide.actions.TraceOverAction")) : class$org$openide$actions$TraceOverAction)).setActionPerformer(null);
                    ((StepOutAction)SystemAction.get(class$org$openide$actions$StepOutAction == null ? (class$org$openide$actions$StepOutAction = DebuggerPerformer.class$("org.openide.actions.StepOutAction")) : class$org$openide$actions$StepOutAction)).setActionPerformer(null);
                    ((StartDebuggerAction)SystemAction.get(class$org$openide$actions$StartDebuggerAction == null ? (class$org$openide$actions$StartDebuggerAction = DebuggerPerformer.class$("org.openide.actions.StartDebuggerAction")) : class$org$openide$actions$StartDebuggerAction)).changeEnabled(true);
                    ((GoAction)SystemAction.get(class$org$openide$actions$GoAction == null ? (class$org$openide$actions$GoAction = DebuggerPerformer.class$("org.openide.actions.GoAction")) : class$org$openide$actions$GoAction)).changeEnabled(false);
                    ((TraceIntoAction)SystemAction.get(class$org$openide$actions$TraceIntoAction == null ? (class$org$openide$actions$TraceIntoAction = DebuggerPerformer.class$("org.openide.actions.TraceIntoAction")) : class$org$openide$actions$TraceIntoAction)).changeEnabled(true);
                    ((FinishDebuggerAction)SystemAction.get(class$org$openide$actions$FinishDebuggerAction == null ? (class$org$openide$actions$FinishDebuggerAction = DebuggerPerformer.class$("org.openide.actions.FinishDebuggerAction")) : class$org$openide$actions$FinishDebuggerAction)).setActionPerformer(null);
                    ((GoToCursorAction)SystemAction.get(class$org$openide$actions$GoToCursorAction == null ? (class$org$openide$actions$GoToCursorAction = DebuggerPerformer.class$("org.openide.actions.GoToCursorAction")) : class$org$openide$actions$GoToCursorAction)).changeEnabled(true);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    ((TraceOverAction)SystemAction.get(class$org$openide$actions$TraceOverAction == null ? (class$org$openide$actions$TraceOverAction = DebuggerPerformer.class$("org.openide.actions.TraceOverAction")) : class$org$openide$actions$TraceOverAction)).setActionPerformer(null);
                    ((StepOutAction)SystemAction.get(class$org$openide$actions$StepOutAction == null ? (class$org$openide$actions$StepOutAction = DebuggerPerformer.class$("org.openide.actions.StepOutAction")) : class$org$openide$actions$StepOutAction)).setActionPerformer(null);
                    ((GoAction)SystemAction.get(class$org$openide$actions$GoAction == null ? (class$org$openide$actions$GoAction = DebuggerPerformer.class$("org.openide.actions.GoAction")) : class$org$openide$actions$GoAction)).changeEnabled(false);
                    ((TraceIntoAction)SystemAction.get(class$org$openide$actions$TraceIntoAction == null ? (class$org$openide$actions$TraceIntoAction = DebuggerPerformer.class$("org.openide.actions.TraceIntoAction")) : class$org$openide$actions$TraceIntoAction)).changeEnabled(false);
                    ((FinishDebuggerAction)SystemAction.get(class$org$openide$actions$FinishDebuggerAction == null ? (class$org$openide$actions$FinishDebuggerAction = DebuggerPerformer.class$("org.openide.actions.FinishDebuggerAction")) : class$org$openide$actions$FinishDebuggerAction)).setActionPerformer(new FinishDebuggerPerformer());
                    ((GoToCursorAction)SystemAction.get(class$org$openide$actions$GoToCursorAction == null ? (class$org$openide$actions$GoToCursorAction = DebuggerPerformer.class$("org.openide.actions.GoToCursorAction")) : class$org$openide$actions$GoToCursorAction)).changeEnabled(false);
                    break;
                }
                case 4: {
                    ((TraceOverAction)SystemAction.get(class$org$openide$actions$TraceOverAction == null ? (class$org$openide$actions$TraceOverAction = DebuggerPerformer.class$("org.openide.actions.TraceOverAction")) : class$org$openide$actions$TraceOverAction)).setActionPerformer(new TraceOverPerformer());
                    ((StepOutAction)SystemAction.get(class$org$openide$actions$StepOutAction == null ? (class$org$openide$actions$StepOutAction = DebuggerPerformer.class$("org.openide.actions.StepOutAction")) : class$org$openide$actions$StepOutAction)).setActionPerformer(new StepOutPerformer());
                    ((GoAction)SystemAction.get(class$org$openide$actions$GoAction == null ? (class$org$openide$actions$GoAction = DebuggerPerformer.class$("org.openide.actions.GoAction")) : class$org$openide$actions$GoAction)).changeEnabled(true);
                    ((TraceIntoAction)SystemAction.get(class$org$openide$actions$TraceIntoAction == null ? (class$org$openide$actions$TraceIntoAction = DebuggerPerformer.class$("org.openide.actions.TraceIntoAction")) : class$org$openide$actions$TraceIntoAction)).changeEnabled(true);
                    ((GoToCursorAction)SystemAction.get(class$org$openide$actions$GoToCursorAction == null ? (class$org$openide$actions$GoToCursorAction = DebuggerPerformer.class$("org.openide.actions.GoToCursorAction")) : class$org$openide$actions$GoToCursorAction)).changeEnabled(true);
                }
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    void update() {
        try {
            Debugger debugger = TopManager.getDefault().getDebugger();
            if (this.installed) {
                return;
            }
            this.installed = true;
            debugger.addPropertyChangeListener(this);
            return;
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            debuggerNotFoundException.printStackTrace();
            if (!this.installed) {
                return;
            }
            this.installed = false;
            ((AddWatchAction)SystemAction.get(class$org$openide$actions$AddWatchAction == null ? (class$org$openide$actions$AddWatchAction = DebuggerPerformer.class$("org.openide.actions.AddWatchAction")) : class$org$openide$actions$AddWatchAction)).setActionPerformer(null);
            return;
        }
    }

    void setDebuggerRunning(boolean bl) {
        ((StartDebuggerAction)SystemAction.get(class$org$openide$actions$StartDebuggerAction == null ? (class$org$openide$actions$StartDebuggerAction = DebuggerPerformer.class$("org.openide.actions.StartDebuggerAction")) : class$org$openide$actions$StartDebuggerAction)).changeEnabled(!bl);
        ((GoAction)SystemAction.get(class$org$openide$actions$GoAction == null ? (class$org$openide$actions$GoAction = DebuggerPerformer.class$("org.openide.actions.GoAction")) : class$org$openide$actions$GoAction)).changeEnabled(!bl);
        ((GoToCursorAction)SystemAction.get(class$org$openide$actions$GoToCursorAction == null ? (class$org$openide$actions$GoToCursorAction = DebuggerPerformer.class$("org.openide.actions.GoToCursorAction")) : class$org$openide$actions$GoToCursorAction)).changeEnabled(!bl);
        ((TraceIntoAction)SystemAction.get(class$org$openide$actions$TraceIntoAction == null ? (class$org$openide$actions$TraceIntoAction = DebuggerPerformer.class$("org.openide.actions.TraceIntoAction")) : class$org$openide$actions$TraceIntoAction)).changeEnabled(!bl);
        ((TraceOverAction)SystemAction.get(class$org$openide$actions$TraceOverAction == null ? (class$org$openide$actions$TraceOverAction = DebuggerPerformer.class$("org.openide.actions.TraceOverAction")) : class$org$openide$actions$TraceOverAction)).setActionPerformer(null);
    }

    static void init() {
        try {
            Debugger debugger = TopManager.getDefault().getDebugger();
        }
        catch (DebuggerException debuggerException) {
            DebuggerPerformer.notifyDebuggerException(debuggerException);
            return;
        }
    }

    static void changeWorkspace() {
        WindowManager windowManager = WindowManager.getDefault();
        final Workspace workspace = windowManager.findWorkspace(StartDebuggerAction.getWorkspace());
        if (workspace != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    workspace.activate();
                }
            });
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class StartDebugThread
    extends Thread {
        private Node[] activatedNodes;
        private boolean stopOnMain;
        private PropertyChangeListener goToCursor_pcl = null;
        private Breakpoint goToCursor_breakpoint = null;
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
        static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
        static /* synthetic */ Class class$org$openide$actions$TraceIntoAction;

        public StartDebugThread(Node[] nodeArray, boolean bl) {
            this.activatedNodes = nodeArray;
            this.stopOnMain = bl;
        }

        void storeGoToCursorInfo(PropertyChangeListener propertyChangeListener, Breakpoint breakpoint) {
            this.goToCursor_pcl = propertyChangeListener;
            this.goToCursor_breakpoint = breakpoint;
        }

        public void run() {
            Object object;
            if (StartDebuggerAction.getRunCompilation()) {
                object = new HashSet();
                int n = 0;
                while (n < this.activatedNodes.length) {
                    CompilerCookie compilerCookie = (CompilerCookie)this.activatedNodes[n].getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? StartDebugThread.class$("org.openide.cookies.CompilerCookie$Compile") : class$org$openide$cookies$CompilerCookie$Compile);
                    if (compilerCookie != null) {
                        ((HashSet)object).add(compilerCookie);
                    }
                    ++n;
                }
                if (!AbstractCompileAction.compile(Collections.enumeration(object), AbstractCompileAction.findName(this.activatedNodes))) {
                    DebuggerPerformer.this.setDebuggerRunning(false);
                    try {
                        if (this.goToCursor_pcl != null) {
                            TopManager.getDefault().getDebugger().removePropertyChangeListener(this.goToCursor_pcl);
                            this.goToCursor_pcl = null;
                            this.goToCursor_breakpoint.remove();
                        }
                        return;
                    }
                    catch (DebuggerException debuggerException) {
                        DebuggerPerformer.notifyDebuggerException(debuggerException);
                        return;
                    }
                }
            }
            if ((object = (DebuggerCookie)this.activatedNodes[0].getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = StartDebugThread.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie)) == null) {
                TopManager.getDefault().notify(new NotifyDescriptor.Message(NbBundle.getMessage(class$org$openide$actions$TraceIntoAction == null ? (class$org$openide$actions$TraceIntoAction = StartDebugThread.class$("org.openide.actions.TraceIntoAction")) : class$org$openide$actions$TraceIntoAction, "FMT_MSG_CannotDebug", this.activatedNodes[0].getDisplayName()), 2));
                return;
            }
            DebuggerPerformer.changeWorkspace();
            try {
                object.debug(this.stopOnMain);
                if (TopManager.getDefault().getDebugger().getState() == 1) {
                    DebuggerPerformer.this.setDebuggerRunning(false);
                    if (this.goToCursor_pcl != null) {
                        TopManager.getDefault().getDebugger().removePropertyChangeListener(this.goToCursor_pcl);
                        this.goToCursor_pcl = null;
                        this.goToCursor_breakpoint.remove();
                    }
                } else {
                    this.goToCursor_pcl = null;
                }
            }
            catch (DebuggerException debuggerException) {
                DebuggerPerformer.notifyDebuggerException(debuggerException);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static final class TraceOverPerformer
    implements ActionPerformer {
        TraceOverPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            DebuggerPerformer.getDefault().setDebuggerRunning(true);
            try {
                TopManager.getDefault().getDebugger().traceOver();
            }
            catch (DebuggerException debuggerException) {
                DebuggerPerformer.notifyDebuggerException(debuggerException);
            }
        }
    }

    static final class StepOutPerformer
    implements ActionPerformer {
        StepOutPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            DebuggerPerformer.getDefault().setDebuggerRunning(true);
            try {
                TopManager.getDefault().getDebugger().stepOut();
            }
            catch (DebuggerException debuggerException) {
                DebuggerPerformer.notifyDebuggerException(debuggerException);
            }
        }
    }

    static final class FinishDebuggerPerformer
    implements ActionPerformer {
        FinishDebuggerPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            try {
                TopManager.getDefault().getDebugger().finishDebugger();
            }
            catch (DebuggerException debuggerException) {
                DebuggerPerformer.notifyDebuggerException(debuggerException);
            }
        }
    }
}

