/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Manifest;
import org.openide.ErrorManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.NbfsStreamHandlerFactory;
import org.openide.execution.NbfsURLConnection;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public class NbClassLoader
extends URLClassLoader {
    protected InputOutput inout;
    private HashMap permissionCollections;
    private PermissionCollection defaultPermissions;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    private static ClassLoader systemClassLoader() {
        return (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
    }

    public NbClassLoader() {
        super(NbClassLoader.createRootURLs(FileSystemCapability.EXECUTE.fileSystems()), NbClassLoader.systemClassLoader());
    }

    public NbClassLoader(InputOutput inputOutput) {
        this();
        this.inout = inputOutput;
    }

    public NbClassLoader(FileSystem[] fileSystemArray) {
        this(fileSystemArray, NbClassLoader.systemClassLoader());
    }

    public NbClassLoader(FileSystem[] fileSystemArray, ClassLoader classLoader) {
        super(NbClassLoader.createRootURLs(Collections.enumeration(Arrays.asList(fileSystemArray))), classLoader);
    }

    public URL getResource(String string) {
        return super.getResource(string.startsWith("/") ? string.substring(1) : string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        String string2;
        if (string.indexOf(46) != -1 && this.getPackage(string2 = string.substring(0, string.lastIndexOf(46))) == null) {
            String string3 = string.replace('.', '/') + ".class";
            URL[] uRLArray = this.getURLs();
            int n = 0;
            while (n < uRLArray.length) {
                block8: {
                    FileObject fileObject = NbfsURLConnection.decodeURL(uRLArray[n]);
                    if (fileObject != null && fileObject.isRoot()) {
                        Object object;
                        try {
                            FileSystem fileSystem = fileObject.getFileSystem();
                            object = fileSystem.findResource(string3);
                            if (object == null) break block8;
                            FileObject fileObject2 = fileSystem.findResource("META-INF/MANIFEST.MF");
                            if (fileObject2 == null) {
                                fileObject2 = fileSystem.findResource("meta-inf/manifest.mf");
                            }
                            if (fileObject2 == null) break;
                            Manifest manifest = new Manifest();
                            InputStream inputStream = fileObject2.getInputStream();
                            try {
                                manifest.read(inputStream);
                                Object var13_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var13_14 = null;
                                inputStream.close();
                                throw throwable;
                            }
                            inputStream.close();
                            this.definePackage(string2, manifest, uRLArray[n]);
                            break;
                        }
                        catch (IOException iOException) {
                            object = ErrorManager.getDefault();
                            ((ErrorManager)object).annotate((Throwable)iOException, uRLArray[n].toString());
                            ((ErrorManager)object).notify(1, iOException);
                        }
                    }
                }
                ++n;
            }
        }
        return super.findClass(string);
    }

    public void setDefaultPermissions(PermissionCollection permissionCollection) {
        if (permissionCollection != null && !permissionCollection.isReadOnly()) {
            permissionCollection.setReadOnly();
        }
        this.defaultPermissions = permissionCollection;
    }

    protected final synchronized PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection;
        if (this.permissionCollections != null && (permissionCollection = (PermissionCollection)this.permissionCollections.get(codeSource)) != null) {
            return permissionCollection;
        }
        return this.createPermissions(codeSource, this.inout);
    }

    private PermissionCollection createPermissions(CodeSource codeSource, InputOutput inputOutput) {
        PermissionCollection permissionCollection;
        if (inputOutput == null) {
            permissionCollection = this.defaultPermissions != null ? this.defaultPermissions : super.getPermissions(codeSource);
        } else {
            ExecutionEngine executionEngine = ExecutionEngine.getDefault();
            permissionCollection = executionEngine.createPermissions(codeSource, inputOutput);
            if (this.defaultPermissions != null) {
                NbClassLoader.addAllPermissions(permissionCollection, this.defaultPermissions);
            } else {
                permissionCollection.add(new AllPermission());
            }
        }
        if (this.permissionCollections == null) {
            this.permissionCollections = new HashMap(7);
        }
        this.permissionCollections.put(codeSource, permissionCollection);
        return permissionCollection;
    }

    private static void addAllPermissions(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        Enumeration<Permission> enumeration = permissionCollection2.elements();
        while (enumeration.hasMoreElements()) {
            permissionCollection.add(enumeration.nextElement());
        }
    }

    private static URL[] createRootURLs(Enumeration enumeration) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            try {
                arrayList.add(fileSystem.getRoot().getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, fileStateInvalidException);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        URL.setURLStreamHandlerFactory(NbfsStreamHandlerFactory.getDefault());
    }
}

