/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.ListViewDragSupport;
import org.openide.explorer.view.ListViewDropSupport;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class ListView
extends JScrollPane
implements Externalizable {
    static final long serialVersionUID = -7540940974042262975L;
    private transient ExplorerManager manager;
    protected transient JList list;
    protected transient NodeListModel model;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupSupport popupSupport;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = true;
    private ActionListener defaultProcessor;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient ListViewDragSupport dragSupport;
    transient ListViewDropSupport dropSupport;
    transient boolean listenerActive;

    public ListView() {
        this.initializeList();
    }

    private void initializeList() {
        this.model = this.createModel();
        this.list = this.createList();
        this.list.setModel(this.model);
        this.setViewportView(this.list);
        AbstractAction abstractAction = new GoUpAction();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(8, 0);
        this.list.registerKeyboardAction(abstractAction, keyStroke, 0);
        abstractAction = new EnterAction();
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.list.registerKeyboardAction(abstractAction, keyStroke, 0);
        this.managerListener = new Listener();
        this.popupSupport = new PopupSupport();
        this.list.getSelectionModel().setSelectionMode(2);
        ToolTipManager.sharedInstance().registerComponent(this.list);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Boolean(this.popupAllowed));
        objectOutput.writeObject(new Boolean(this.traversalAllowed));
        objectOutput.writeObject(new Integer(this.getSelectionMode()));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)objectInput.readObject();
        this.traversalAllowed = (Boolean)objectInput.readObject();
        this.setSelectionMode((Integer)objectInput.readObject());
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean bl) {
        this.popupAllowed = bl;
    }

    public boolean isTraversalAllowed() {
        return this.traversalAllowed;
    }

    public void setTraversalAllowed(boolean bl) {
        this.traversalAllowed = bl;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener actionListener) {
        this.defaultProcessor = actionListener;
    }

    public void setSelectionMode(int n) {
        this.list.setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl == this.dragActive) {
            return;
        }
        this.dragActive = bl;
        if (this.dragActive && this.dragSupport == null) {
            this.dragSupport = new ListViewDragSupport(this, this.list);
        }
        this.dragSupport.activate(this.dragActive);
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (bl == this.dropActive) {
            return;
        }
        this.dropActive = bl;
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new ListViewDropSupport(this, this.list);
        }
        this.dropSupport.activate(this.dropActive);
    }

    public int getAllowedDragActions() {
        return 0x40000003;
    }

    public void setAllowedDragActions(int n) {
    }

    public int getAllowedDropActions() {
        return 0x40000003;
    }

    public void setAllowedDropActions(int n) {
    }

    protected JList createList() {
        NbList nbList = new NbList();
        nbList.setCellRenderer(NodeRenderer.sharedInstance());
        return nbList;
    }

    protected NodeListModel createModel() {
        return new NodeListModel();
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        explorerManager.setSelectedNodes(nodeArray);
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        if (nodeArray.length == 1 && this.manager.getRootContext().equals(nodeArray[0])) {
            return true;
        }
        Node node = this.manager.getExploredContext();
        int n = 0;
        while (n < nodeArray.length) {
            VisualizerNode visualizerNode = VisualizerNode.getVisualizer(null, nodeArray[n]);
            if (this.model.getIndex(visualizerNode) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void showSelection(int[] nArray) {
        this.list.setSelectedIndices(nArray);
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find(this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListener.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.model.setNode(this.manager.getExploredContext());
            this.updateSelection();
        } else if (!this.listenerActive && this.manager != null) {
            this.wlvc = WeakListener.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
            this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            this.model.addListDataListener(this.managerListener);
            this.model.setNode(this.manager.getExploredContext());
            this.list.addFocusListener(this.popupSupport);
            this.list.addMouseListener(this.popupSupport);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.listenerActive = false;
        this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        if (this.manager != null) {
            this.manager.removeVetoableChangeListener(this.wlvc);
            this.manager.removePropertyChangeListener(this.wlpc);
        }
        this.model.removeListDataListener(this.managerListener);
        this.list.removeFocusListener(this.popupSupport);
        this.list.removeMouseListener(this.popupSupport);
    }

    public void requestFocus() {
        this.list.requestFocus();
    }

    final void performObjectAt(int n, int n2) {
        if (n < 0 || n >= this.model.getSize()) {
            return;
        }
        VisualizerNode visualizerNode = (VisualizerNode)this.model.getElementAt(n);
        Node node = visualizerNode.node;
        if (this.defaultProcessor != null) {
            this.defaultProcessor.actionPerformed(new ActionEvent(node, 0, null, n2));
            return;
        }
        SystemAction systemAction = node.getDefaultAction();
        if (systemAction != null && (n2 & 2) == 0) {
            TreeView.invokeAction(systemAction, new ActionEvent(node, 1001, ""));
        } else if (this.traversalAllowed && !node.isLeaf()) {
            this.manager.setExploredContext(node, this.manager.getSelectedNodes());
        }
    }

    private void updateSelection() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        int[] nArray = new int[nodeArray.length];
        int n = 0;
        while (n < nodeArray.length) {
            VisualizerNode visualizerNode = VisualizerNode.getVisualizer(null, nodeArray[n]);
            nArray[n] = this.model.getIndex(visualizerNode);
            ++n;
        }
        if (this.listenerActive) {
            this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        }
        try {
            this.showSelection(nArray);
            Object var6_5 = null;
            if (this.listenerActive) {
                this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.listenerActive) {
                this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            }
            throw throwable;
        }
    }

    void createPopup(int n, int n2) {
        if (this.manager == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        JPopupMenu jPopupMenu = NodeOp.findContextMenu(this.manager.getSelectedNodes());
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0 && TreeView.shouldPopupBeDisplayed(this)) {
            Point point = this.getViewport().getViewPosition();
            point.x = n - point.x;
            point.y = n2 - point.y;
            SwingUtilities.convertPointToScreen(point, this);
            Dimension dimension = jPopupMenu.getPreferredSize();
            Rectangle rectangle = Utilities.getUsableScreenBounds(this.getGraphicsConfiguration());
            if (point.x + dimension.width > rectangle.x + rectangle.width) {
                point.x = rectangle.x + rectangle.width - dimension.width;
            }
            if (point.y + dimension.height > rectangle.y + rectangle.height) {
                point.y = rectangle.y + rectangle.height - dimension.height;
            }
            SwingUtilities.convertPointFromScreen(point, this);
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private final class EnterAction
    extends AbstractAction {
        static final long serialVersionUID = -239805141416294016L;

        public EnterAction() {
            super("Enter");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListView.this.list.getSelectedIndex();
            ListView.this.performObjectAt(n, actionEvent.getModifiers());
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class GoUpAction
    extends AbstractAction {
        static final long serialVersionUID = 1599999335583246715L;

        public GoUpAction() {
            super("GoUpAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ListView.this.traversalAllowed) {
                Node node = ListView.this.manager.getExploredContext();
                if ((node = node.getParentNode()) != null) {
                    ListView.this.manager.setExploredContext(node, ListView.this.manager.getSelectedNodes());
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class Listener
    implements ListDataListener,
    ListSelectionListener,
    PropertyChangeListener,
    VetoableChangeListener {
        Listener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListView.this.updateSelection();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListView.this.updateSelection();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListView.this.updateSelection();
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            ListView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && !ListView.this.selectionAccept(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ListView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                ListView.this.updateSelection();
                return;
            }
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                ListView.this.model.setNode(ListView.this.manager.getExploredContext());
                return;
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object;
            int n = ListView.this.model.getSize();
            int[] nArray = ListView.this.list.getSelectedIndices();
            ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < n) {
                    object = Visualizer.findNode(ListView.this.model.getElementAt(nArray[n2]));
                    if (object == ListView.this.manager.getRootContext() || ((Node)object).getParentNode() != null) {
                        arrayList.add(object);
                    }
                } else {
                    ListView.this.updateSelection();
                    return;
                }
                ++n2;
            }
            object = arrayList.toArray(new Node[arrayList.size()]);
            ListView.this.manager.removePropertyChangeListener(ListView.this.wlpc);
            ListView.this.manager.removeVetoableChangeListener(ListView.this.wlvc);
            try {
                try {
                    ListView.this.selectionChanged((Node[])object, ListView.this.manager);
                }
                catch (PropertyVetoException propertyVetoException) {
                    ListView.this.updateSelection();
                    Object var9_8 = null;
                    ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                    ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
                }
                Object var9_7 = null;
                ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
                throw throwable;
            }
        }
    }

    final class PopupSupport
    extends MouseUtils.PopupMouseAdapter
    implements ActionPerformer,
    Runnable,
    FocusListener {
        CallbackSystemAction csa;

        PopupSupport() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseUtils.isDoubleClick(mouseEvent)) {
                int n = ListView.this.list.locationToIndex(mouseEvent.getPoint());
                ListView.this.performObjectAt(n, mouseEvent.getModifiers());
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = ListView.this.list.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (!ListView.this.list.isSelectedIndex(n)) {
                ListView.this.list.setSelectedIndex(n);
            }
            ListView.this.createPopup(mouseEvent.getX(), mouseEvent.getY());
        }

        public void performAction(SystemAction systemAction) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            int n;
            boolean bl = ListView.this.list.getSelectionMode() != 0;
            int n2 = n = bl ? ListView.this.list.getLeadSelectionIndex() : ListView.this.list.getSelectedIndex();
            if (n < 0) {
                return;
            }
            Point point = ListView.this.list.indexToLocation(n);
            if (point == null) {
                return;
            }
            ListView.this.createPopup(point.x, point.y);
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.csa == null) {
                try {
                    Class<?> clazz = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError();
                    ErrorManager.getDefault().annotate((Throwable)noClassDefFoundError, classNotFoundException);
                    throw noClassDefFoundError;
                }
            }
            this.csa.setActionPerformer(this);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupSupport) {
                this.csa.setActionPerformer(null);
            }
        }
    }

    final class NbList
    extends JList
    implements Autoscroll {
        static final long serialVersionUID = -7571829536335024077L;
        AutoscrollSupport support;

        NbList() {
            if (System.getProperty("java.version").startsWith("1.4")) {
                this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point;
            int n;
            if (mouseEvent != null && (n = this.locationToIndex(point = mouseEvent.getPoint())) >= 0) {
                VisualizerNode visualizerNode = (VisualizerNode)ListView.this.model.getElementAt(n);
                String string = visualizerNode.getShortDescription();
                String string2 = visualizerNode.displayName;
                if (string != null && !string.equals(string2)) {
                    return string;
                }
            }
            return null;
        }

        public void autoscroll(Point point) {
            this.getSupport().autoscroll(point);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerList();
            }
            return this.accessibleContext;
        }

        private class AccessibleExplorerList
        extends JList.AccessibleJList {
            AccessibleExplorerList() {
                super(NbList.this);
            }

            public String getAccessibleName() {
                return ListView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return ListView.this.getAccessibleContext().getAccessibleDescription();
            }
        }
    }
}

