/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

public class MultiFileSystem
extends FileSystem {
    static final long serialVersionUID = -767493828111559560L;
    static final String MASK = "_hidden";
    private FileSystem[] systems;
    private boolean propagateMasks = false;
    private transient MultiFileObject root;
    private static final int WRITE_SYSTEM_INDEX = 0;

    protected MultiFileSystem() {
        this(new FileSystem[1]);
    }

    public MultiFileSystem(FileSystem[] fileSystemArray) {
        this.systems = (FileSystem[])fileSystemArray.clone();
    }

    public void refresh(boolean bl) {
        Enumeration enumeration = this.getMultiRoot().existingSubFiles(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            fileObject.refresh(bl);
        }
    }

    protected final void setDelegates(FileSystem[] fileSystemArray) {
        Serializable serializable;
        FileSystem[] fileSystemArray2 = this.systems;
        this.systems = fileSystemArray;
        this.getMultiRoot().updateAllAfterSetDelegates(fileSystemArray2);
        List<FileSystem> list = Arrays.asList(fileSystemArray2);
        List<FileSystem> list2 = Arrays.asList(this.systems);
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>(list);
        hashSet.removeAll(list2);
        Iterator<FileSystem> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            serializable = iterator.next();
            if (serializable == null) continue;
            ((FileSystem)serializable).removeNotify();
        }
        serializable = new HashSet<FileSystem>(list2);
        ((AbstractSet)((Object)serializable)).removeAll(list);
        Iterator iterator2 = ((HashSet)serializable).iterator();
        while (iterator2.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator2.next();
            if (fileSystem == null) continue;
            fileSystem.addNotify();
        }
    }

    protected final FileSystem[] getDelegates() {
        return this.systems;
    }

    public final boolean getPropagateMasks() {
        return this.propagateMasks;
    }

    protected final void setPropagateMasks(boolean bl) {
        this.propagateMasks = bl;
    }

    public boolean isReadOnly() {
        return this.systems[0] == null || this.systems[0].isReadOnly();
    }

    public String getDisplayName() {
        return FileSystem.getString("CTL_MultiFileSystem");
    }

    public FileObject getRoot() {
        return this.getMultiRoot();
    }

    private MultiFileObject getMultiRoot() {
        if (this.root == null) {
            MultiFileSystem multiFileSystem = this;
            synchronized (multiFileSystem) {
                if (this.root == null) {
                    this.root = new MultiFileObject(this);
                }
            }
        }
        return this.root;
    }

    public SystemAction[] getActions() {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> hashSet = new HashSet<SystemAction>(101);
        FileSystem[] fileSystemArray = this.getDelegates();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] != null) {
                SystemAction[] systemActionArray = fileSystemArray[n].getActions();
                int n2 = 0;
                while (n2 < systemActionArray.length) {
                    if (hashSet.add(systemActionArray[n2])) {
                        arrayList.add(systemActionArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    public SystemAction[] getActions(Set set) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> hashSet = new HashSet<SystemAction>(101);
        FileSystem[] fileSystemArray = this.getDelegates();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] != null) {
                SystemAction[] systemActionArray = fileSystemArray[n].getActions(set);
                int n2 = 0;
                while (n2 < systemActionArray.length) {
                    if (hashSet.add(systemActionArray[n2])) {
                        arrayList.add(systemActionArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    public FileObject find(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Enumeration<Object> enumeration = string2 == null || string3 == null ? stringTokenizer : new SequenceEnumeration(stringTokenizer, new SingletonEnumeration(string2 + '.' + string3));
        return this.getMultiRoot().find(enumeration);
    }

    public FileObject findResource(String string) {
        if (string.length() == 0) {
            return this.getMultiRoot();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        return this.getMultiRoot().find(stringTokenizer);
    }

    protected final FileSystem findSystem(FileObject fileObject) throws IllegalArgumentException {
        try {
            if (fileObject instanceof MultiFileObject) {
                MultiFileObject multiFileObject = (MultiFileObject)fileObject;
                return multiFileObject.getLeaderFileSystem();
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return this;
        }
        throw new IllegalArgumentException(fileObject.toString());
    }

    protected final void hideResource(String string, boolean bl) throws IOException {
        if (bl) {
            this.maskFile(this.createWritableOn(string), string);
        } else {
            this.unmaskFile(this.createWritableOn(string), string);
        }
    }

    protected static Enumeration hiddenFiles(FileObject fileObject, boolean bl) {
        Enumeration enumeration = fileObject.getChildren(bl);
        AlterEnumeration alterEnumeration = new AlterEnumeration(enumeration){

            public Object alter(Object object) {
                String string = ((FileObject)object).getPackageNameExt('/', '.');
                if (string.endsWith(MultiFileSystem.MASK)) {
                    return string.substring(0, string.length() - MultiFileSystem.MASK.length());
                }
                return null;
            }
        };
        return new FilterEnumeration(alterEnumeration);
    }

    protected FileObject findResourceOn(FileSystem fileSystem, String string) {
        return fileSystem.findResource(string);
    }

    protected FileSystem createWritableOn(String string) throws IOException {
        if (this.systems[0] == null || this.systems[0].isReadOnly()) {
            FSException.io("EXC_FSisRO", this.getDisplayName());
        }
        return this.systems[0];
    }

    protected FileSystem createWritableOnForRename(String string, String string2) throws IOException {
        return this.createWritableOn(string2);
    }

    protected Set createLocksOn(String string) throws IOException {
        FileSystem fileSystem = this.createWritableOn(string);
        return Collections.singleton(fileSystem);
    }

    protected void notifyMigration(FileObject fileObject) {
    }

    protected void markUnimportant(FileObject fileObject) {
    }

    public void prepareEnvironment(FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        FileSystem[] fileSystemArray = this.getDelegates();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] != null) {
                try {
                    fileSystemArray[n].prepareEnvironment(environment);
                }
                catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    public void addNotify() {
        super.addNotify();
        int n = 0;
        while (n < this.systems.length) {
            if (this.systems[n] != null) {
                this.systems[n].addNotify();
            }
            ++n;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        int n = 0;
        while (n < this.systems.length) {
            if (this.systems[n] != null) {
                this.systems[n].removeNotify();
            }
            ++n;
        }
    }

    private static String[] split(String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[3];
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        stringArray[0] = n == -1 ? "" : string.substring(0, n);
        ++n;
        if (n2 == -1) {
            stringArray[1] = string.substring(n);
            stringArray[2] = "";
        } else {
            stringArray[1] = string.substring(n, n2);
            stringArray[2] = string.substring(n2 + 1);
        }
        return stringArray;
    }

    Enumeration delegates(final String string) {
        ArrayEnumeration arrayEnumeration = new ArrayEnumeration(this.systems);
        AlterEnumeration alterEnumeration = new AlterEnumeration(arrayEnumeration){

            public Object alter(Object object) {
                FileSystem fileSystem = (FileSystem)object;
                if (fileSystem == null) {
                    return null;
                }
                return MultiFileSystem.this.findResourceOn(fileSystem, string);
            }
        };
        return new FilterEnumeration(alterEnumeration);
    }

    void maskFile(FileSystem fileSystem, String string) throws IOException {
        FileObject fileObject = this.findResourceOn(fileSystem, fileSystem.getRoot().getPackageNameExt('/', '.'));
        FileObject fileObject2 = FileUtil.createData(fileObject, string + MASK);
    }

    void unmaskFile(FileSystem fileSystem, String string) throws IOException {
        FileObject fileObject = this.findResourceOn(fileSystem, string + MASK);
        if (fileObject != null) {
            FileLock fileLock = fileObject.lock();
            try {
                fileObject.delete(fileLock);
                Object var6_5 = null;
                fileLock.releaseLock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                fileLock.releaseLock();
                throw throwable;
            }
        }
    }

    void unmaskFileOnAll(FileSystem fileSystem, String string) throws IOException {
        FileSystem[] fileSystemArray = this.getDelegates();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] != null && !fileSystemArray[n].isReadOnly()) {
                this.unmaskFile(fileSystemArray[n], string);
                if (fileSystemArray[n] == fileSystem) {
                    return;
                }
            }
            ++n;
        }
    }

    static boolean isMaskFile(FileObject fileObject) {
        return fileObject.getExt().endsWith(MASK);
    }
}

