/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class DataObject
implements Node.Cookie,
Serializable {
    private static final long serialVersionUID = 3328227388376142699L;
    public static final String PROP_TEMPLATE = "template";
    public static final String PROP_NAME = "name";
    public static final String PROP_HELP = "helpCtx";
    public static final String PROP_MODIFIED = "modified";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PRIMARY_FILE = "primaryFile";
    public static final String PROP_FILES = "files";
    static final String EA_ASSIGNED_LOADER = "NetBeansAttrAssignedLoader";
    static final String EA_ASSIGNED_LOADER_MODULE = "NetBeansAttrAssignedLoaderModule";
    private static ModifiedRegistry modified = new ModifiedRegistry();
    private static Set syncModified = Collections.synchronizedSet(modified);
    private static final Object listenersMethodLock = new Object();
    private boolean modif = false;
    private transient Node nodeDelegate;
    DataObjectPool.Item item;
    private DataLoader loader;
    private EventListenerList listeners;
    private Object nodeCreationLock = new Object();
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;

    public DataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        this(fileObject, DataObjectPool.getPOOL().register(fileObject, dataLoader), dataLoader);
    }

    private DataObject(FileObject fileObject, DataObjectPool.Item item, DataLoader dataLoader) {
        this.item = item;
        this.loader = dataLoader;
        item.setDataObject(this);
    }

    protected void dispose() {
        DataObjectPool.Item item = this.item;
        if (item != null) {
            item.deregister(true);
            item.setDataObject(null);
            this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void setValid(boolean bl) throws PropertyVetoException {
        if (!bl && this.isValid()) {
            this.fireVetoableChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
            this.dispose();
            this.setModified(false);
        }
    }

    public final boolean isValid() {
        return this.item.isValid();
    }

    public final DataLoader getLoader() {
        return this.loader;
    }

    protected final void markFiles() throws IOException {
        Iterator iterator = this.files().iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            this.loader.markFile(fileObject);
        }
    }

    public Set files() {
        return Collections.singleton(this.getPrimaryFile());
    }

    public final Node getNodeDelegate() {
        if (!this.isValid()) {
            IllegalStateException illegalStateException = new IllegalStateException("The data object " + this.getPrimaryFile() + " is invalid; you may not call getNodeDelegate on it any more; see #17020 and please fix your code");
            ErrorManager.getDefault().notify(1, illegalStateException);
        }
        if (this.nodeDelegate == null) {
            Children.MUTEX.readAccess(new Runnable(){

                public void run() {
                    Object object = DataObject.this.nodeCreationLock;
                    synchronized (object) {
                        if (DataObject.this.nodeDelegate == null) {
                            DataObject.this.nodeDelegate = DataObject.this.createNodeDelegate();
                        }
                    }
                }
            });
            if (this.nodeDelegate == null) {
                throw new IllegalStateException("DataObject " + this + " has null node delegate");
            }
        }
        return this.nodeDelegate;
    }

    Node getClonedNodeDelegate(DataFilter dataFilter) {
        return this.getNodeDelegate().cloneNode();
    }

    Node getNodeDelegateOrNull() {
        return this.nodeDelegate;
    }

    protected Node createNodeDelegate() {
        return new DataNode(this, Children.LEAF);
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryFile().lock();
    }

    static boolean setTemplate(FileObject fileObject, boolean bl) throws IOException {
        boolean bl2 = false;
        Object object = fileObject.getAttribute(PROP_TEMPLATE);
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            bl2 = true;
        }
        if (bl2 == bl) {
            return false;
        }
        fileObject.setAttribute(PROP_TEMPLATE, bl ? new Boolean(true) : null);
        return true;
    }

    public final void setTemplate(boolean bl) throws IOException {
        if (!DataObject.setTemplate(this.getPrimaryFile(), bl)) {
            return;
        }
        this.firePropertyChange(PROP_TEMPLATE, new Boolean(!bl), new Boolean(bl));
    }

    public final boolean isTemplate() {
        Object object = this.getPrimaryFile().getAttribute(PROP_TEMPLATE);
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean bl) {
        if (this.modif != bl) {
            this.modif = bl;
            if (bl) {
                syncModified.add(this);
            } else {
                syncModified.remove(this);
            }
            this.firePropertyChange(PROP_MODIFIED, new Boolean(!bl), new Boolean(bl));
        }
    }

    public abstract HelpCtx getHelpCtx();

    public final FileObject getPrimaryFile() {
        return this.item.primaryFile;
    }

    public static DataObject find(FileObject fileObject) throws DataObjectNotFoundException {
        if (fileObject == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (!fileObject.isValid()) {
                throw new FileStateInvalidException(fileObject.toString());
            }
            DataObject dataObject = DataObjectPool.getPOOL().find(fileObject);
            if (dataObject != null) {
                return dataObject;
            }
            dataObject = TopManager.getDefault().getLoaderPool().findDataObject(fileObject);
            if (dataObject != null) {
                return dataObject;
            }
            throw new DataObjectNotFoundException(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
        catch (IOException iOException) {
            DataObjectNotFoundException dataObjectNotFoundException = new DataObjectNotFoundException(fileObject);
            ErrorManager.getDefault().annotate((Throwable)dataObjectNotFoundException, iOException);
            throw dataObjectNotFoundException;
        }
    }

    public static Registry getRegistry() {
        return Registry.INSTANCE;
    }

    public String getName() {
        return this.getPrimaryFile().getName();
    }

    public String toString() {
        return super.toString() + '[' + this.getPrimaryFile() + ']';
    }

    public final DataFolder getFolder() {
        FileObject fileObject = this.getPrimaryFile().getParent();
        return fileObject == null ? null : DataFolder.findFolder(fileObject);
    }

    public final DataObject copy(final DataFolder dataFolder) throws IOException {
        final DataObject[] dataObjectArray = new DataObject[1];
        FileSystem fileSystem = dataFolder.getPrimaryFile().getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataObjectArray[0] = DataObject.this.handleCopy(dataFolder);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataObjectArray[0], this), 1);
        return dataObjectArray[0];
    }

    protected abstract DataObject handleCopy(DataFolder var1) throws IOException;

    public final void delete() throws IOException {
        Object object = this.synchObject();
        synchronized (object) {
            FileSystem fileSystem = this.getPrimaryFile().getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    DataObject.this.handleDelete();
                    DataObject.this.item.deregister(false);
                    DataObject.this.item.setDataObject(null);
                }
            });
        }
        this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        DataObject.fireOperationEvent(new OperationEvent(this), 3);
    }

    protected abstract void handleDelete() throws IOException;

    public final void rename(final String string) throws IOException {
        String string2;
        if (string != null && string.trim().length() == 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(this.getName());
            String string3 = NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, "MSG_NotValidName", this.getName());
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, string3);
            throw illegalArgumentException;
        }
        final FileObject[] fileObjectArray = new FileObject[2];
        Object object = this.synchObject();
        synchronized (object) {
            string2 = this.getName();
            if (string2.equals(string)) {
                return;
            }
            fileObjectArray[0] = this.getPrimaryFile();
            FileSystem fileSystem = fileObjectArray[0].getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    fileObjectArray[1] = DataObject.this.handleRename(string);
                    if (fileObjectArray[0] != fileObjectArray[1]) {
                        DataObject.this.item.changePrimaryFile(fileObjectArray[1]);
                    }
                }
            });
        }
        if (fileObjectArray[0] != fileObjectArray[1]) {
            this.firePropertyChange(PROP_PRIMARY_FILE, fileObjectArray[0], this.getPrimaryFile());
        }
        DataObject.fireOperationEvent(new OperationEvent.Rename(this, string2), 4);
        this.firePropertyChange(PROP_NAME, string2, this.getName());
    }

    protected abstract FileObject handleRename(String var1) throws IOException;

    public final void move(final DataFolder dataFolder) throws IOException {
        FileObject fileObject;
        Object object = this.synchObject();
        synchronized (object) {
            if (this.getFolder() == null) {
                return;
            }
            if (dataFolder.equals(this.getFolder())) {
                return;
            }
            fileObject = this.getPrimaryFile();
            FileSystem fileSystem = fileObject.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject = DataObject.this.handleMove(dataFolder);
                    DataObject.this.item.changePrimaryFile(fileObject);
                }
            });
        }
        this.firePropertyChange(PROP_PRIMARY_FILE, fileObject, this.getPrimaryFile());
        DataObject.fireOperationEvent(new OperationEvent.Move(this, fileObject), 2);
    }

    protected abstract FileObject handleMove(DataFolder var1) throws IOException;

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        return DataShadow.create(dataFolder, this);
    }

    public final DataShadow createShadow(final DataFolder dataFolder) throws IOException {
        final DataShadow[] dataShadowArray = new DataShadow[1];
        FileSystem fileSystem = dataFolder.getPrimaryFile().getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataShadowArray[0] = DataObject.this.handleCreateShadow(dataFolder);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataShadowArray[0], this), 5);
        return dataShadowArray[0];
    }

    public final DataObject createFromTemplate(DataFolder dataFolder) throws IOException {
        return this.createFromTemplate(dataFolder, null);
    }

    public final DataObject createFromTemplate(final DataFolder dataFolder, final String string) throws IOException {
        final DataObject[] dataObjectArray = new DataObject[1];
        FileSystem fileSystem = dataFolder.getPrimaryFile().getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataObjectArray[0] = DataObject.this.handleCreateFromTemplate(dataFolder, string);
            }
        });
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataObjectArray[0], this), 6);
        return dataObjectArray[0];
    }

    protected abstract DataObject handleCreateFromTemplate(DataFolder var1, String var2) throws IOException;

    private static void fireOperationEvent(OperationEvent operationEvent, int n) {
        TopManager.getDefault().getLoaderPool().fireOperationEvent(operationEvent, n);
    }

    Object synchObject() {
        return this.nodeCreationLock;
    }

    private EventListenerList listeners() {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
        }
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners().add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DataObject.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners().remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DataObject.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        Object[] objectArray = this.listeners().getListenerList();
        PropertyChangeEvent propertyChangeEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$beans$PropertyChangeListener == null ? DataObject.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                }
                ((PropertyChangeListener)objectArray[n + 1]).propertyChange(propertyChangeEvent);
            }
            n -= 2;
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.listeners().add(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = DataObject.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.listeners().remove(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = DataObject.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, vetoableChangeListener);
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        Object[] objectArray = this.listeners().getListenerList();
        PropertyChangeEvent propertyChangeEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$beans$VetoableChangeListener == null ? DataObject.class$("java.beans.VetoableChangeListener") : class$java$beans$VetoableChangeListener)) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                }
                ((VetoableChangeListener)objectArray[n + 1]).vetoableChange(propertyChangeEvent);
            }
            n -= 2;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return null;
    }

    protected Node.Cookie getCookie(DataShadow dataShadow, Class clazz) {
        return this.getCookie(clazz);
    }

    public Object writeReplace() {
        return new Replace(this);
    }

    static String getString(String string) {
        return NbBundle.getMessage(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataObject.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, string);
    }

    void recognizedByFolder() {
    }

    void notifyFileRenamed(FileRenameEvent fileRenameEvent) {
        if (fileRenameEvent.getFile().equals(this.getPrimaryFile())) {
            this.firePropertyChange(PROP_NAME, fileRenameEvent.getName(), this.getName());
        }
    }

    void notifyFileDeleted(FileEvent fileEvent) {
    }

    void notifyFileDataCreated(FileEvent fileEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ModifiedRegistry
    extends HashSet {
        private HashSet listeners;
        static final long serialVersionUID = -2861723614638919680L;

        private ModifiedRegistry() {
        }

        public final synchronized void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new HashSet(5);
            }
            this.listeners.add(changeListener);
        }

        public final synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public boolean add(Object object) {
            boolean bl = super.add(object);
            if (bl) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return bl;
        }

        public boolean remove(Object object) {
            boolean bl = super.remove(object);
            if (bl) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return bl;
        }

        protected final void fireChangeEvent(ChangeEvent changeEvent) {
            HashSet hashSet;
            if (this.listeners == null) {
                return;
            }
            ModifiedRegistry modifiedRegistry = this;
            synchronized (modifiedRegistry) {
                hashSet = (HashSet)this.listeners.clone();
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    public static final class Registry {
        private static Registry INSTANCE = new Registry();

        private Registry() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            modified.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            modified.removeChangeListener(changeListener);
        }

        public Set getModifiedSet() {
            return Collections.unmodifiableSet(syncModified);
        }

        public DataObject[] getModified() {
            return ((AbstractCollection)modified).toArray(new DataObject[0]);
        }
    }

    public static interface Container
    extends Node.Cookie {
        public static final String PROP_CHILDREN = "children";

        public DataObject[] getChildren();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static final class Replace
    implements Serializable {
        private FileObject fo;
        private transient DataObject obj;
        private static final long serialVersionUID = -627843044348243058L;

        public Replace(DataObject dataObject) {
            this.obj = dataObject;
            this.fo = dataObject.getPrimaryFile();
        }

        public Object readResolve() {
            return this.obj;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.obj = DataObject.find(this.fo);
        }
    }
}

