/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ResourceBundle;
import org.openide.options.ContextSystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public final class PrintSettings
extends ContextSystemOption {
    static final long serialVersionUID = -9102470021814206818L;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    private static ResourceBundle bundle;
    public static final String PROP_PAGE_FORMAT = "pageFormat";
    public static final String PROP_WRAP = "wrap";
    public static final String PROP_HEADER_FORMAT = "headerFormat";
    public static final String PROP_FOOTER_FORMAT = "footerFormat";
    public static final String PROP_HEADER_FONT = "headerFont";
    public static final String PROP_FOOTER_FONT = "footerFont";
    public static final String PROP_HEADER_ALIGNMENT = "headerAlignment";
    public static final String PROP_FOOTER_ALIGNMENT = "footerAlignment";
    public static final String PROP_LINE_ASCENT_CORRECTION = "lineAscentCorrection";
    private static final String HELP_ID = "editing.printing";
    private static PageFormat pageFormat;
    private static boolean wrap;
    private static String headerFormat;
    private static String footerFormat;
    private static Font headerFont;
    private static Font footerFont;
    private static int headerAlignment;
    private static int footerAlignment;
    private static float lineAscentCorrection;
    static /* synthetic */ Class class$org$openide$text$PrintSettings;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(wrap);
        objectOutput.writeObject(headerFormat);
        objectOutput.writeObject(footerFormat);
        objectOutput.writeObject(headerFont);
        objectOutput.writeObject(footerFont);
        objectOutput.writeInt(headerAlignment);
        objectOutput.writeInt(footerAlignment);
        PrintSettings.externalizePageFormat(pageFormat, objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        wrap = objectInput.readBoolean();
        headerFormat = (String)objectInput.readObject();
        footerFormat = (String)objectInput.readObject();
        headerFont = (Font)objectInput.readObject();
        footerFont = (Font)objectInput.readObject();
        headerAlignment = objectInput.readInt();
        footerAlignment = objectInput.readInt();
        pageFormat = PrintSettings.internalizePageFormat(objectInput);
    }

    private static void externalizePageFormat(PageFormat pageFormat, ObjectOutput objectOutput) throws IOException {
        if (pageFormat == null) {
            objectOutput.writeInt(3);
            return;
        }
        objectOutput.writeInt(pageFormat.getOrientation());
        Paper paper = pageFormat.getPaper();
        objectOutput.writeDouble(paper.getWidth());
        objectOutput.writeDouble(paper.getHeight());
        objectOutput.writeDouble(paper.getImageableX());
        objectOutput.writeDouble(paper.getImageableY());
        objectOutput.writeDouble(paper.getImageableWidth());
        objectOutput.writeDouble(paper.getImageableHeight());
    }

    private static PageFormat internalizePageFormat(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PageFormat pageFormat = new PageFormat();
        Paper paper = pageFormat.getPaper();
        int n = objectInput.readInt();
        if (n == 3) {
            return null;
        }
        pageFormat.setOrientation(n);
        paper.setSize(objectInput.readDouble(), objectInput.readDouble());
        paper.setImageableArea(objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble());
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public String displayName() {
        return PrintSettings.getString("CTL_Print_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public static PageFormat getPageFormat(PrinterJob printerJob) {
        if (pageFormat == null) {
            pageFormat = printerJob.defaultPage();
        }
        return pageFormat;
    }

    public PageFormat getPageFormat() {
        if (pageFormat == null) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            pageFormat = printerJob.defaultPage(new PageFormat());
            printerJob.cancel();
        }
        return pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (pageFormat == null) {
            return;
        }
        if (pageFormat.equals(PrintSettings.pageFormat)) {
            return;
        }
        PageFormat pageFormat2 = PrintSettings.pageFormat;
        PrintSettings.pageFormat = pageFormat;
        this.firePropertyChange(PROP_PAGE_FORMAT, pageFormat2, PrintSettings.pageFormat);
    }

    public boolean getWrap() {
        return wrap;
    }

    public void setWrap(boolean bl) {
        if (wrap == bl) {
            return;
        }
        wrap = bl;
        this.firePropertyChange(PROP_WRAP, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getHeaderFormat() {
        if (headerFormat == null) {
            headerFormat = PrintSettings.getString("CTL_Header_format");
        }
        return headerFormat;
    }

    public void setHeaderFormat(String string) {
        if (string == null) {
            return;
        }
        if (string.equals(headerFormat)) {
            return;
        }
        String string2 = headerFormat;
        headerFormat = string;
        this.firePropertyChange(PROP_HEADER_FORMAT, string2, headerFormat);
    }

    public String getFooterFormat() {
        if (footerFormat == null) {
            footerFormat = PrintSettings.getString("CTL_Footer_format");
        }
        return footerFormat;
    }

    public void setFooterFormat(String string) {
        if (string == null) {
            return;
        }
        if (string.equals(footerFormat)) {
            return;
        }
        String string2 = footerFormat;
        footerFormat = string;
        this.firePropertyChange(PROP_FOOTER_FORMAT, string2, footerFormat);
    }

    public Font getHeaderFont() {
        if (headerFont == null) {
            headerFont = new Font("Monospaced", 0, 6);
        }
        return headerFont;
    }

    public void setHeaderFont(Font font) {
        if (font == null) {
            return;
        }
        if (font.equals(headerFont)) {
            return;
        }
        Font font2 = headerFont;
        headerFont = font;
        this.firePropertyChange(PROP_HEADER_FONT, font2, headerFont);
    }

    public Font getFooterFont() {
        if (footerFont == null) {
            footerFont = this.getHeaderFont();
        }
        return footerFont;
    }

    public void setFooterFont(Font font) {
        if (font == null) {
            return;
        }
        if (font.equals(footerFont)) {
            return;
        }
        Font font2 = headerFont;
        footerFont = font;
        this.firePropertyChange(PROP_FOOTER_FONT, font2, footerFont);
    }

    public int getHeaderAlignment() {
        return headerAlignment;
    }

    public void setHeaderAlignment(int n) {
        if (n == headerAlignment) {
            return;
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        int n2 = headerAlignment;
        headerAlignment = n;
        this.firePropertyChange(PROP_HEADER_ALIGNMENT, new Integer(n2), new Integer(headerAlignment));
    }

    public int getFooterAlignment() {
        return footerAlignment;
    }

    public void setFooterAlignment(int n) {
        if (n == footerAlignment) {
            return;
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        int n2 = footerAlignment;
        footerAlignment = n;
        this.firePropertyChange(PROP_FOOTER_ALIGNMENT, new Integer(n2), new Integer(footerAlignment));
    }

    public float getLineAscentCorrection() {
        return lineAscentCorrection;
    }

    public void setLineAscentCorrection(float f) {
        if (f == lineAscentCorrection) {
            return;
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        float f2 = lineAscentCorrection;
        lineAscentCorrection = f;
        this.firePropertyChange(PROP_LINE_ASCENT_CORRECTION, new Float(f2), new Float(lineAscentCorrection));
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PrintSettings.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings);
        }
        return bundle.getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        wrap = true;
        headerAlignment = 1;
        footerAlignment = 1;
        lineAscentCorrection = 0.7f;
    }

    public static class PageFormatEditor
    extends PropertyEditorSupport {
        static /* synthetic */ Class class$org$openide$text$PrintSettings;

        public String getAsText() {
            return null;
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            PageFormat pageFormat = (PageFormat)this.getValue();
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
            ((PrintSettings)SharedClassObject.findObject(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = PageFormatEditor.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings)).setPageFormat((PageFormat)pageFormat2.clone());
            printerJob.cancel();
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class AlignmentEditor
    extends PropertyEditorSupport {
        private String sCENTER;
        private String sRIGHT;
        private String sLEFT = PrintSettings.getString("CTL_LEFT");
        private String[] tags = new String[]{this.sLEFT, this.sCENTER = PrintSettings.getString("CTL_CENTER"), this.sRIGHT = PrintSettings.getString("CTL_RIGHT")};

        public String[] getTags() {
            return this.tags;
        }

        public String getAsText() {
            return this.tags[(Integer)this.getValue()];
        }

        public void setAsText(String string) {
            if (string.equals(this.sLEFT)) {
                this.setValue(new Integer(0));
            } else if (string.equals(this.sCENTER)) {
                this.setValue(new Integer(1));
            } else {
                this.setValue(new Integer(2));
            }
        }
    }
}

