/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static RequestProcessor UNLIMITED = new RequestProcessor("Default RequestProcessor", 50);
    private static Timer starterThread = new Timer(true);
    String name;
    private static int counter = 0;
    boolean stopped = false;
    private Object processorLock = new Object();
    private HashSet processors = new HashSet();
    private Item pendingTail = null;
    private Item pendingHead = null;
    private int running = 0;
    private int throughput;
    static final boolean SLOW = Boolean.getBoolean("org.openide.util.RequestProcessor.Item.SLOW");

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String string) {
        this(string, 1);
    }

    public RequestProcessor(String string, int n) {
        this.throughput = n;
        this.name = string != null ? string : "OpenIDE-request-processor-" + counter++;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    public Task post(Runnable runnable) {
        return this.post(runnable, 0, 1);
    }

    public Task post(Runnable runnable, int n) {
        return this.post(runnable, n, 1);
    }

    public Task post(Runnable runnable, int n, int n2) {
        Task task = this.create(runnable);
        task.setPriority(n2);
        task.schedule(n);
        return task;
    }

    public Task create(Runnable runnable) {
        return new Task(runnable);
    }

    public boolean isRequestProcessorThread() {
        Thread thread = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            boolean bl = this.processors.contains(thread);
            return bl;
        }
    }

    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            Iterator iterator = this.processors.iterator();
            while (iterator.hasNext()) {
                ((Processor)iterator.next()).interrupt();
            }
        }
    }

    public static Task postRequest(Runnable runnable) {
        return DEFAULT.post(runnable);
    }

    public static Task postRequest(Runnable runnable, int n) {
        return DEFAULT.post(runnable, n);
    }

    public static Task postRequest(Runnable runnable, int n, int n2) {
        return DEFAULT.post(runnable, n, n2);
    }

    public static Task createRequest(Runnable runnable) {
        return DEFAULT.create(runnable);
    }

    void enqueue(Item item) {
        Object object = this.processorLock;
        synchronized (object) {
            if (this.pendingTail == null) {
                this.pendingTail = this.pendingHead = item;
            } else {
                this.pendingTail.link = item;
                this.pendingTail = item;
                if (this.pendingHead == null) {
                    this.pendingHead = item;
                }
            }
            if (this.running < this.throughput) {
                ++this.running;
                Processor processor = Processor.get();
                this.processors.add(processor);
                processor.setName(this.name);
                processor.attachTo(this);
            }
        }
    }

    Item askForWork(Processor processor) {
        Object object = this.processorLock;
        synchronized (object) {
            if (this.stopped || this.pendingHead == null) {
                this.processors.remove(processor);
                Processor.put(processor);
                --this.running;
                Item item = null;
                return item;
            }
            Item item = this.pendingHead;
            this.pendingHead = this.pendingHead.link;
            if (this.pendingHead == null) {
                this.pendingTail = null;
            }
            Item item2 = item;
            return item2;
        }
    }

    private static class Processor
    extends Thread {
        private static Stack pool = new Stack();
        private RequestProcessor source;
        private static final int INACTIVE_TIMEOUT = 60000;
        private boolean idle = true;
        private Object lock = new Object();
        static /* synthetic */ Class class$org$openide$util$RequestProcessor;

        static Processor get() {
            Stack stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor processor = new Processor();
                    processor.idle = false;
                    processor.start();
                    Processor processor2 = processor;
                    return processor2;
                }
                Processor processor = (Processor)pool.pop();
                processor.idle = false;
                Processor processor3 = processor;
                return processor3;
            }
        }

        static void put(Processor processor) {
            Stack stack = pool;
            synchronized (stack) {
                processor.setName("Inactive RequestProcessor thread");
                processor.idle = true;
                pool.push(processor);
            }
        }

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        void setPrio(int n) {
            if (n != this.getPriority()) {
                this.setPriority(n);
            }
        }

        public void attachTo(RequestProcessor requestProcessor) {
            Object object = this.lock;
            synchronized (object) {
                this.source = requestProcessor;
                this.lock.notify();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                var1_1 = null;
                var2_2 = this.lock;
                synchronized (var2_2) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException var3_4) {
                        // empty catch block
                    }
                    var1_1 = this.source;
                    this.source = null;
                    if (var1_1 == null) {
                        var3_3 = Processor.pool;
                        synchronized (var3_3) {
                            if (this.idle) {
                                Processor.pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 11] lbl31 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl42
                }
                do {
                    if ((var4_5 = var3_3.takeOverTask()) == null) continue;
                    this.setPrio(var4_5.getPriority());
                    try {
                        var4_5.run();
                    }
                    catch (ThreadDeath var5_10) {
                        throw var5_10;
                    }
                    catch (Throwable var6_7) {
                        var7_8 = ErrorManager.getDefault();
                        var7_8.annotate(var6_7, 4096, null, NbBundle.getMessage(Processor.class$org$openide$util$RequestProcessor == null ? Processor.class$("org.openide.util.RequestProcessor") : Processor.class$org$openide$util$RequestProcessor, "EXC_IN_REQUEST_PROCESSOR"), (Throwable)(RequestProcessor.SLOW != false ? var3_3 : null), null);
                        var7_8.notify(var6_7);
                    }
lbl42:
                    // 4 sources

                } while ((var3_3 = var1_1.askForWork(this)) != null);
            }
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup.getParent() != null) {
                        threadGroup = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            };
            return (ThreadGroup)AccessController.doPrivileged(privilegedAction);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class Item
    extends Exception {
        RequestProcessor owner;
        Item link;
        Task action;

        Item(Task task, RequestProcessor requestProcessor) {
            super("Posted StackTrace");
            this.action = task;
            this.owner = requestProcessor;
        }

        Task takeOverTask() {
            Object object = this.owner.processorLock;
            synchronized (object) {
                Task task = this.action;
                if (this.action != null) {
                    this.action.item = null;
                }
                this.action = null;
                Task task2 = task;
                return task2;
            }
        }

        boolean clear() {
            return this.takeOverTask() != null;
        }

        public Throwable fillInStackTrace() {
            return SLOW ? super.fillInStackTrace() : this;
        }
    }

    public final class Task
    extends org.openide.util.Task {
        private Item item;
        private int priority = 1;
        private long time = 0L;

        Task(Runnable runnable) {
            super(runnable);
        }

        public int getDelay() {
            long l = this.time - System.currentTimeMillis();
            if (l < 0L) {
                return 0;
            }
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        public void schedule(int n) {
            Item item;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear();
                }
                item = this.item = new Item(this, RequestProcessor.this);
            }
            if (n == 0) {
                RequestProcessor.this.enqueue(item);
            } else {
                starterThread.schedule(new TimerTask(this, item){
                    private final /* synthetic */ Item val$localItem;
                    private final /* synthetic */ Task this$1;
                    {
                        this.this$1 = task;
                        this.val$localItem = item;
                    }

                    public void run() {
                        Task.access$100(this.this$1).enqueue(this.val$localItem);
                    }
                }, n);
            }
        }

        public boolean cancel() {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean bl;
                boolean bl2 = bl = this.item == null ? false : this.item.clear();
                if (bl) {
                    this.notifyFinished();
                }
                boolean bl3 = bl;
                return bl3;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int n) {
            if (n < 1) {
                n = 1;
            }
            if (n > 10) {
                n = 10;
            }
            this.priority = n;
        }

        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean bl;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    bl = this.item == null ? false : this.item.clear();
                }
                if (bl) {
                    this.run();
                }
            } else {
                super.waitFinished();
            }
        }

        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }

        static /* synthetic */ RequestProcessor access$100(Task task) {
            return task.RequestProcessor.this;
        }
    }
}

