/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.JPopupMenuPlus;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public abstract class SystemAction
extends SharedClassObject
implements Action {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_ICON = "icon";
    private static final String PROP_ICON_TEXTUAL = "iconTextual";
    private static ImageIcon BLANK_ICON = null;
    private static final Set relativeIconResourceClasses = new HashSet(200);

    private static ImageIcon getBlankIcon() {
        if (BLANK_ICON == null) {
            BLANK_ICON = new ImageIcon(Utilities.loadImage("org/openide/resources/actions/empty.gif"));
        }
        return BLANK_ICON;
    }

    public static SystemAction get(Class clazz) {
        return (SystemAction)SharedClassObject.findObject(clazz, true);
    }

    public abstract String getName();

    public abstract HelpCtx getHelpCtx();

    public boolean isEnabled() {
        return this.getProperty(PROP_ENABLED).equals(Boolean.TRUE);
    }

    public void setEnabled(boolean bl) {
        this.putProperty(PROP_ENABLED, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public final void putValue(String string, Object object) {
        this.putProperty(string, object, true);
    }

    public final Object getValue(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            if ("Name".equals(string)) {
                object = this.getName();
            } else if ("SmallIcon".equals(string)) {
                object = this.getIcon();
            }
        }
        return object;
    }

    public abstract void actionPerformed(ActionEvent var1);

    protected void initialize() {
        this.putProperty(PROP_ENABLED, Boolean.TRUE);
        super.initialize();
    }

    protected boolean clearSharedData() {
        return false;
    }

    public final void setIcon(Icon icon) {
        this.putProperty(PROP_ICON, icon, true);
        this.putProperty(PROP_ICON_TEXTUAL, icon);
    }

    public final Icon getIcon() {
        return this.getIcon(false);
    }

    public final Icon getIcon(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            Object object2;
            Icon icon = (Icon)this.getProperty(bl ? PROP_ICON_TEXTUAL : PROP_ICON);
            if (icon == null) {
                object2 = this.iconResource();
                if (object2 != null) {
                    if (((String)object2).indexOf(47) == -1) {
                        String string = this.getClass().getName();
                        if (relativeIconResourceClasses.add(string)) {
                            ErrorManager.getDefault().log(16, "Deprecated relative path in " + string + ".iconResource (cf. #20072)");
                        }
                        icon = new ImageIcon(this.getClass().getResource((String)object2));
                    } else {
                        icon = new ImageIcon(Utilities.loadImage((String)object2));
                    }
                    this.putProperty(PROP_ICON, icon);
                    this.putProperty(PROP_ICON_TEXTUAL, icon);
                } else if (bl) {
                    String string = this.getName();
                    if (string.endsWith("...")) {
                        string = string.substring(0, string.length() - 3);
                    }
                    icon = new ComponentIcon(new JLabel(Actions.cutAmpersand(string.trim())));
                    this.putProperty(PROP_ICON_TEXTUAL, icon);
                } else {
                    icon = SystemAction.getBlankIcon();
                    this.putProperty(PROP_ICON, icon);
                }
            }
            object2 = icon;
            return object2;
        }
    }

    protected String iconResource() {
        return null;
    }

    public static JToolBar createToolbarPresenter(SystemAction[] systemActionArray) {
        JToolBar jToolBar = new JToolBar();
        int n = systemActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (systemActionArray[n2] == null) {
                jToolBar.addSeparator();
            } else if (systemActionArray[n2] instanceof Presenter.Toolbar) {
                jToolBar.add(((Presenter.Toolbar)((Object)systemActionArray[n2])).getToolbarPresenter());
            }
            ++n2;
        }
        return jToolBar;
    }

    public static SystemAction[] linkActions(SystemAction[] systemActionArray, SystemAction[] systemActionArray2) {
        Vector<SystemAction> vector = new Vector<SystemAction>(Arrays.asList(systemActionArray));
        vector.addAll(Arrays.asList(systemActionArray2));
        return vector.toArray(systemActionArray);
    }

    public static JPopupMenu createPopupMenu(SystemAction[] systemActionArray) {
        boolean bl = false;
        JPopupMenuPlus jPopupMenuPlus = new JPopupMenuPlus();
        int n = 0;
        while (n < systemActionArray.length) {
            if (systemActionArray[n] == null) {
                bl = jPopupMenuPlus.getComponentCount() > 0;
            } else {
                JMenuItem jMenuItem;
                if (systemActionArray[n] instanceof Presenter.Popup) {
                    jMenuItem = ((Presenter.Popup)((Object)systemActionArray[n])).getPopupPresenter();
                } else {
                    jMenuItem = new JMenuItem(systemActionArray[n].getName());
                    jMenuItem.setEnabled(false);
                }
                if (bl) {
                    jPopupMenuPlus.addSeparator();
                    bl = false;
                }
                jPopupMenuPlus.add(jMenuItem);
            }
            ++n;
        }
        return jPopupMenuPlus;
    }

    private static class ComponentIcon
    extends ImageIcon {
        private JComponent comp;
        private BufferedImage image;

        public ComponentIcon(JComponent jComponent) {
            if (jComponent.getParent() != null) {
                throw new IllegalArgumentException();
            }
            this.comp = jComponent;
            Dimension dimension = jComponent.getPreferredSize();
            jComponent.setSize(Math.max(dimension.width, 16), Math.max(dimension.height, 16));
        }

        protected void loadImage(Image image) {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.comp.setBackground(component.getBackground());
            this.comp.setForeground(component.getForeground());
            Graphics graphics2 = graphics.create(n, n2, this.getIconWidth(), this.getIconHeight());
            this.comp.paint(graphics2);
        }

        public int getIconWidth() {
            return this.comp.getWidth();
        }

        public int getIconHeight() {
            return this.comp.getHeight();
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.comp.setForeground(Color.black);
                this.comp.paint(this.image.getGraphics());
            }
            return this.image;
        }
    }
}

