#!/bin/sh
#                 Sun Public License Notice
#
# The contents of this file are subject to the Sun Public License
# Version 1.0 (the "License"). You may not use this file except in
# compliance with the License. A copy of the License is available at
# http://www.sun.com/
#
# The Original Code is NetBeans. The Initial Developer of the Original
# Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
# Microsystems, Inc. All Rights Reserved.

#get the right dir
IDE_DIR=`dirname $0`
if [ -z $IDE_DIR ] ; then
	IDE_DIR=`pwd` ;
fi

IDE_PORT=8000
IDE_SUSPEND=y
PARSE_NEXT=1

while [ $# -gt 0 -a $PARSE_NEXT = "1" ] ; do
	case "$1" in 
		-port) shift; if [ $# -gt 0 ] ; then IDE_PORT=$1 ; shift ; fi;;
		-nowait) shift; IDE_SUSPEND=n ;;
		*) PARSE_NEXT=0 ;;
		
	esac
done
echo Waiting on port $IDE_PORT

#start the ide for a debugger
#use socket transport, port 8000, wait for an incoming connection, suspend=y is default
$IDE_DIR/../runide.sh -J-Xdebug -J-Xrunjdwp:transport=dt_socket,server=y,address=$IDE_PORT,suspend=$IDE_SUSPEND "$@"
