/*
 * w_sound.c : sound id file name mapping
 *
 * Copyright (c) Yukihiko Aoki 1999
 * NetHack may be freely redistributed.  See license for details.
 *
 */

#include "hack.h"

#ifdef NH2K_EXTENDS

#include "win32api.h"
#include "w_main.h"

static const char *sound_map[] = {
    NULL,
    "Breath.wav",
    "Clunk.wav",
    "Coin.wav",
    "Cursing.wav",
    "Death.wav",
    "Destroy.wav",
    "Doorclos.wav",
    "Dooropen.wav",
    "Drop.wav",
    "Fountain.wav",
    "Hallu.wav",
    "Hit.wav",
    "Landmine.wav",
    "Level.wav",
    "Memor.wav",
    "Miss.wav",
    "Ouch.wav",
    "Register.wav",
    "Thump.wav",
    "Trapdoor.wav",
    "Vomit.wav",
    "Whistle.wav",
    "bee.wav",
    "bee2.wav",
    "bee3.wav",
    "blast.wav",
    "bubble.wav",
    "cat.wav",
    "cat2.wav",
    "creaking.wav",
    "dog.wav",
    "doorkick.wav",
    "eii.wav",
    "explosion2.wav",
    "footsteps.wav",
    "keikei.wav",
    "key.wav",
    "laughing.wav",
    "mournfully.wav",
    "noises.wav",
    "noises2.wav",
    "pile.wav",
    "ringdrop.wav",
    "screaming.wav",
    "whammm.wav",
    "dooropen2.wav",
    "explosion.wav",
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    "sh_moster.wav",
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    "se-drop1.wav",
    NULL,
    "be-funny1.wav",
    "sh-freshtear2.wav",
    "se-drink.wav",
    "se-guns1.wav"
};

/***************************************************************************************/
/*
/***************************************************************************************/
const char *Sound_getFilename(int type)
{
    static char buf[MAX_PATH + 1];
    char *filename = NULL;

    if(sound_map[type]) {
        GetModuleDirectory(buf, MAX_PATH);
        strcat(buf, "\\" WAVEDIR "\\");
        strcat(buf, sound_map[type]);
        filename = buf;
    }

    return filename;
}

#endif /* NH2K_EXTENDS */
