/*
**
**	$Id: jconj.c,v 1.4 1996/07/17 06:03:45 issei Exp issei $
**
*/

/* Copyright (c) Issei Numata 1994-1996 */
/* JNetHack may be freely redistributed.  See license for details. */

#include <stdio.h>
#include <ctype.h>
#include "hack.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>

#include <setjmp.h>
#include <signal.h>

#ifdef REPORTSCORE

static char	*errstr;
static char	*email;
static char	*homeurl;

void
set_email(char *s)
{
    email = malloc(strlen(s) + 1);
    strcpy(email, s);
}
void
set_homeurl(char *s)
{
    homeurl = malloc(strlen(s) + 1);
    strcpy(homeurl, s);
}

char *
get_email()
{
    if(email)
	return email;
    else
	return "";
}

char *
get_homeurl()
{
    if(homeurl)
	return homeurl;
    else
	return "";
}

#if 0
static int
soc_write_str(int sd, char *buf)
{
  return write(sd, buf, strlen(buf));
}
#endif

int
soc_read(int sd, char *buf, int len)
{
  fd_set		readfds, writefds, exceptfds;
  struct timeval	timeout;
  int			ret = 0;

  FD_ZERO(&readfds);
  FD_ZERO(&writefds);
  FD_ZERO(&exceptfds);
  FD_SET(sd, &readfds);

  timeout.tv_sec = 5;
  timeout.tv_usec = 0;
  if(!select(32, &readfds, &writefds, &exceptfds, &timeout)){
    errstr = "error: timeout!\n";
    return -1;
  }

  if(FD_ISSET(sd, & readfds)){
    ret = read(sd, buf, len);
    /*
    write(1, buf, ret);
    */
  }
  return ret;
}

int
soc_wait(int sd)
{
  char	buf[4097];
  int len;

  len = soc_read(sd, buf, 4096);
  buf[len] = '\0';
  
  return atoi(buf);
}

static jmp_buf	env;
/*
static sig_t	sig_int_saved;
static sig_t	sig_alm_saved;
*/
static void (*sig_int_saved)(int);
static void (*sig_alm_saved)(int);

static void
interrupt_report(int sig)
{
    unlock_file(RECORD);
    longjmp(env, sig);
}

int
connect_scoreserver(int timeout)
{
  int			sd;
  struct sockaddr_in	to;
  struct hostent	*hp;
  char			buf[4097];
  int			len;
  struct itimerval	val, val0;
  int			ret;

  val0.it_interval.tv_sec = 0;
  val0.it_interval.tv_usec = 0;
  val0.it_value.tv_sec = 0;
  val0.it_value.tv_usec = 0;

  val.it_interval.tv_sec = 0;
  val.it_interval.tv_usec = 0;
  val.it_value.tv_sec = 10;
  val.it_value.tv_usec = 0;

  if((ret = setjmp(env)) != 0){
      signal(SIGINT, sig_int_saved);
      signal(SIGALRM, sig_alm_saved);
      if(ret == SIGALRM)
	  errstr = "error: timeout!\n";
      else
	  errstr = "error: interrupt!\n";
	  
      return -1;
  }
  sig_int_saved = signal(SIGINT, interrupt_report);
  sig_alm_saved = signal(SIGALRM, interrupt_report);

  setitimer(ITIMER_REAL, &val, NULL);

  if((hp = gethostbyname(SCORE_SERVER)) == NULL){
    errstr = "error: bad score server!\n";

    signal(SIGINT, sig_int_saved);
    signal(SIGALRM, sig_alm_saved);

    return -1;
  }

  setitimer(ITIMER_REAL, &val0, NULL);

  signal(SIGALRM, sig_alm_saved);

  bzero(&to, sizeof(to));
  bcopy(hp->h_addr_list[0], &to.sin_addr, hp->h_length);

  to.sin_family = AF_INET;
  to.sin_port = htons(SCORE_PORT);
  
  if((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0){
    errstr = "error: cannot create socket!\n";
    return -1;
  }

  if(connect(sd, (struct sockaddr *)&to, sizeof(to)) < 0){
    errstr = "error: bad score server!\n";
    return -1;
  }

  len = soc_read(sd, buf, 4096);
  if(len <= 0 && buf[0] != '2'){
    errstr = "error: score server error!\n";
    return -1;
  }

  signal(SIGINT, sig_int_saved);
  return sd;
}

char *
remote_err()
{
  return errstr;
}

#endif
