/*
 * w_main.c : Program's main module
 *
 * Copyright (c) Yukihiko Aoki 1999, 2005
 * NetHack may be freely redistributed.  See license for details.
 *
 */

#include "hack.h"

#ifdef NH2K_EXTENDS

#include "win32api.h"
#include "w_main.h"

/*
 * global variables
 */
char         g_skindir[MAX_PATH + 1];
HACCEL       g_hAccel = NULL;
char         NHWVersion[256];
HINSTANCE    g_hInstance = NULL;
HWND         g_baseHwnd  = NULL;
WINRESOURCE *g_resource  = NULL;
char         g_propFile[MAX_PATH + 1];
SYSTEMPROP   g_sysprop;
DISPPROC     disp_procs;
COLORREF     colormap[] = {
    RGB(  0,  0,  0),   /* BLACK      */
    RGB(255,  0,  0),   /* RED        */
    RGB(  0,160,  0),   /* GREEN      */
    RGB(200,160, 20),   /* BROWN      */
    RGB(  0,  0,160),   /* BLUE       */
    RGB(160,  0,160),   /* MAGENTA    */
    RGB(  0,160,160),   /* CYAN       */
    RGB(200,200,200),   /* GRAY       */
    RGB(  0,  0,  0),   /* NO_COLOR   */
    RGB(255,100,  0),   /* ORANGE     */
    RGB(  0,255,  0),   /* BR GREEN   */
    RGB(255,255,  0),   /* YELLOW     */
    RGB(  0,  0,255),   /* BR BLUE    */
    RGB(255,  0,255),   /* BR MAGENTA */
    RGB(  0,255,255),   /* BR CYAN    */
    RGB(255,255,255)    /* WHITE      */
};

/*
 * External functions
 */
extern int main(int,char **);   /* in sys/share/pcmain.c */

/*
 * Local functions
 */
static int  FDECL(ParseCommandLine, (char *, char **));
static BOOL FDECL(SelectControl, (char *));
static void NDECL(GetNHWVersion);

/***************************************************************************************
 * WinMain: Program's main routine.
 ***************************************************************************************/
int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPreInst, LPSTR lpszCmdLine, int nCmdShow)
{
    char  *ctlfile = NULL;
    char  *xargv[20];
    char **argv;
    int    argc;

    GetNHWVersion();
    OutputDebugString(NHWVersion);

    /* parse parameter */
    argc = ParseCommandLine(lpszCmdLine, xargv);
    argv = xargv;

    /* set some global variables */
    g_skindir[0] = '\0';
    g_hInstance = hInst;
    g_baseHwnd  = NULL;
    GetModuleDirectory(g_propFile, MAX_PATH);
    strcat(g_propFile, DEF_INIFILE);
    g_hAccel = LoadAccelerators(hInst, "HACK_ACCEL");

    /* get special parameter (control file) */
    if (argc > 2 && !strncmp(CTLPARAM, xargv[1], strlen(CTLPARAM))) {
        ctlfile = &xargv[1][strlen(CTLPARAM)];
        xargv[1] = xargv[0];
        argv++;
        argc--;
    }

    if (SelectControl(ctlfile)) {
        return main(argc, argv);
    }

    return EXIT_FAILURE;
}

/*--------------------------------------------------------------------------------------
 * Parse command line for argv
 *-------------------------------------------------------------------------------------*/
static int ParseCommandLine(char *cmdline, char **xargv)
{
    int   maxchars;
    int   count;
    int   argcount = 1;
    int   between  = 0;
    char *buf;

    xargv[0] = "NetHack";
    if (strlen(cmdline) == 0) {
        return argcount;
    }

    buf = (char *) alloc(strlen(cmdline) + 1);
    strcpy(buf,cmdline);

    xargv[argcount] = (char *)&buf[0];
    ++argcount;
    maxchars = strlen(buf);
    for (count = 0; count < maxchars; ++count) {
        if (!between) {
            if (isspace(buf[count])) {
                between = 1;
                buf[count] = '\0';
            }
        } else {
            if (!isspace(buf[count])) {
                between = 0;
                xargv[argcount] = (char *)&buf[count];
                ++argcount;
            }
        }
    }
    return argcount;
}

/*--------------------------------------------------------------------------------------
 * Display copyright dialog and select control file
 *-------------------------------------------------------------------------------------*/
static BOOL SelectControl(char *ctlfile)
{
    char        buf[MAX_PATH + 1];
    WINCONTROL *list, *tmp = NULL;
    BOOL        init_flg   = FALSE;
    int         result;

    if (ctlfile) {
        /* load specified control file */
        list = LoadControlFile(ctlfile, TRUE);
        if(list) {
            init_flg = InitDisplayMode(list, NULL);
        }
    } else {
        /* load installed control files */
        GetModuleDirectory(buf, MAX_PATH);
        list = ListControlFiles(buf);
        /* display copyright dialog */
        result = DialogBoxParam(
            g_hInstance, "HACK_COPYRIGHT", NULL, (DLGPROC)CopyrightProc, (LPARAM)list);
        if (result < 0) {
            /* error occured */
            PrintError("Error: copyright dialog creation");
        } else if (result > 0) {
            init_flg = TRUE;
        }
    }
    if (list) {
        FreeControl(list);
    }

    return init_flg;
}

/***************************************************************************************
 * Default system property settings
 ***************************************************************************************/
void System_defaultProperty(void *param)
{
    SYSTEMPROP *property = (SYSTEMPROP *)param;

    property->sound_flg  = FLAG_ON;
    property->curkey_flg = FLAG_OFF;
    property->ask_popup  = FLAG_ON;
}

/*--------------------------------------------------------------------------------------
 * GetNHWVersion
 *-------------------------------------------------------------------------------------*/
static void GetNHWVersion()
{
    TCHAR buf[256];
    DWORD len = 0L;
    LPVOID pPtr;
    VS_FIXEDFILEINFO *pFixedFileInfo;

    GetModuleFileName(NULL, buf, 255);
    len = GetFileVersionInfoSize(buf, NULL);
    pPtr = malloc(len);
    GetFileVersionInfo(buf, NULL, len, (LPVOID)pPtr);
    VerQueryValue(pPtr, 
              TEXT("\\"),
              (LPVOID*)&pFixedFileInfo,
              &len);
    sprintf(NHWVersion,
        "NetHack 2000+5 Ver.%d.%d.%d Build(%d)",
        HIWORD( pFixedFileInfo->dwProductVersionMS ),
        LOWORD( pFixedFileInfo->dwProductVersionMS ),
        HIWORD( pFixedFileInfo->dwProductVersionLS ),
        LOWORD( pFixedFileInfo->dwProductVersionLS ) );
    free(pPtr);
}

#endif /* NH2K_EXTENDS */
