/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.birt.gui.editorparts.AlarmListTableReportEditorView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderAlarmReport {
    private static Logger logger;
    private IAction editorAlarm = new ActionNodeAlarmReport();
    private IAction showAllNodeAlarmListTableAction = new ActionAllNodeAlarmReport();
    private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance().getBundle();

    public ActionBuilderAlarmReport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionAllNodeAlarmListTableReport() {
        return this.showAllNodeAlarmListTableAction;
    }

    public IAction getActionEditorPartNodeAlarmReport() {
        return this.editorAlarm;
    }

    private abstract class AbstractAlarmListAction
    extends Action {
        private AbstractAlarmListAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    protected class ActionAllNodeAlarmReport
    extends AbstractAlarmListAction {
        protected ActionAllNodeAlarmReport() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmReport.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "All Node Alarm Report";
        }

        public String getToolTipText() {
            return "All Node Alarm Report";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView("All alarm report", null, false), AlarmListTableReportEditorView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionNodeAlarmReport
    extends AbstractAlarmListAction {
        protected NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmReport.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Node Alarm Report";
        }

        public String getToolTipText() {
            return "Node Alarm Report";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " alarm report", this.nodeInfo, false), AlarmListTableReportEditorView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }
}

