/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.birt.gui.editorparts.PingGraphReportEditorView;
import netjfwatcher.birt.gui.editorparts.PingTableReportEditorView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsData;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderNodeDataReport {
    private static Logger logger;
    private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance().getBundle();
    private IEditorPart editorNodeConfigView;
    private IAction showPingData = new ActionPingResponseDataReport();
    private IAction showPingGraph = new ActionPingResponseGraphReport();

    public ActionBuilderNodeDataReport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction actionPingDataReportView() {
        return this.showPingData;
    }

    public IAction actionPingGraphReportView() {
        return this.showPingGraph;
    }

    public IAction actionShowStatisticsDataReport() {
        return new ActionShowStatisticsDataReport();
    }

    public IAction actionShowStatisticsDataReportSocket() {
        return new ActionShowStatisticsDataReportSocket();
    }

    protected abstract class AbstractDataTableReportAction
    extends Action {
        protected AbstractDataTableReportAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public final class ActionShowStatisticsDataReport
    extends AbstractDataTableReportAction {
        private NodeInformation nodeInfo;
        private String oid;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataReport.this.bundle.getEntry("icons/table.gif"));
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataReport.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataReport.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataReport.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataReport.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp Statistics Data View" + " OID=" + this.oid, this.nodeInfo, false, this.oid), EditorNodeSnmpStatisticsData.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionShowStatisticsDataReportSocket
    extends AbstractDataTableReportAction {
        private NodeInformation nodeInfo;
        private String oid;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataReport.this.bundle.getEntry("icons/table.gif"));
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataReport.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataReport.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataReport.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataReport.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp Statistics Data View" + " OID=" + this.oid + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true, this.oid), EditorNodeSnmpStatisticsData.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionPingResponseDataReport
    extends AbstractDataTableReportAction {
        private NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataReport.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Ping Response Table Report";
        }

        public String getToolTipText() {
            return "Ping Response Table Report";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataReport.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataReport.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataReport.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataReport.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Ping response table report", this.nodeInfo, false), PingTableReportEditorView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionPingResponseGraphReport
    extends AbstractDataTableReportAction {
        private NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataReport.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Ping Response Chart Report";
        }

        public String getToolTipText() {
            return "Ping Response Chart Report";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataReport.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataReport.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataReport.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataReport.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Ping response graph report", this.nodeInfo, false), PingGraphReportEditorView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }
}

