/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.birt.gui.editorparts.NodeSnmpReportEditorView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderSnmpReport
extends Action {
    private static Logger logger;
    private IAction snmpInfoShowAction = new ActionNodeSnmpReportView();
    private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance().getBundle();

    public ActionBuilderSnmpReport() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public IAction getActionSnmpInfoReport() {
        return this.snmpInfoShowAction;
    }

    private abstract class AbstractSnmpAction
    extends Action {
        private AbstractSnmpAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public final class ActionNodeSnmpReportView
    extends AbstractSnmpAction {
        private NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderSnmpReport.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Node SNMP Report";
        }

        public String getToolTipText() {
            return "Node SNMP Report";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " SNMP report", this.nodeInfo, false), NodeSnmpReportEditorView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }
}

