/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.action;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.birt.report.viewer.utilities.WebappAccessor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PreviewBirtAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private String reportName;
    private Browser browser;

    public void setReportName(String report) {
        this.reportName = report;
    }

    public void setBrowser(Browser brw) {
        this.browser = brw;
    }

    public void run(IAction action) {
        try {
            System.setProperty("RUN_UNDER_ECLIPSE", "true");
            WebViewer.display((String)this.reportName, (String)"html", (Browser)this.browser, (String)"run");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            WebViewer.display((String)this.reportName, (String)"html", (Browser)this.browser, (String)"run");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private static String createURL(String servletName, String report, String format) {
        String encodedReportName = null;
        String encodedDocumentName = null;
        try {
            encodedReportName = URLEncoder.encode(report, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (encodedReportName != null && encodedReportName.length() > 0) {
            encodedDocumentName = String.valueOf(encodedReportName.substring(0, encodedReportName.lastIndexOf("."))) + ".rptdocument";
        }
        String locale = ViewerPlugin.getDefault().getPluginPreferences().getString("user_locale");
        String svgFlag = ViewerPlugin.getDefault().getPluginPreferences().getString("svg_flag");
        boolean bSVGFlag = false;
        if ("true".equalsIgnoreCase(svgFlag)) {
            bSVGFlag = true;
        }
        String masterPageContent = ViewerPlugin.getDefault().getPluginPreferences().getString("master_page_content");
        boolean bMasterPageContent = true;
        if ("false".equalsIgnoreCase(masterPageContent)) {
            bMasterPageContent = false;
        }
        return String.valueOf(PreviewBirtAction.getBaseURL()) + servletName + "?" + "__report=" + encodedReportName + ("run".equalsIgnoreCase(servletName) ? "" : "&__document=" + encodedDocumentName) + "&__format=" + format + "&__svg=" + String.valueOf(bSVGFlag) + (WebViewer.LocaleTable.containsKey(locale) ? "&__locale=" + WebViewer.LocaleTable.get(locale) : "") + "&__designer=true" + "&__masterpage=" + String.valueOf(bMasterPageContent);
    }

    private static String getBaseURL() {
        return "http://" + WebappAccessor.getHost() + ":" + WebappAccessor.getPort() + "/viewer/";
    }
}

