/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.gui;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.birt.action.ActionBuilderNodeDataReport;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingChart;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingTable;
import netjfwatcher.engine.socket.info.NodeInformation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;

public class NodePingReportMenu {
    private static Logger logger;
    private Bundle bundle;
    private Image chartImage;
    private Image tableImage;
    private ActionBuilderNodeDataReport dataTableReportAction = new ActionBuilderNodeDataReport();

    public NodePingReportMenu() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void createPingMenu(IMenuManager manager, NodeInformation targetNodeInfo, boolean isSocket) {
        MenuManager optionMenu = new MenuManager("Node Ping Response Data");
        manager.add((IContributionItem)optionMenu);
        optionMenu.add((IContributionItem)new Separator());
        String cfr_ignored_0 = String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ") " + "Ping " + " Chart";
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ")");
        ActionBuilderNodeDataReport.ActionPingResponseDataReport pingDataTableAction = (ActionBuilderNodeDataReport.ActionPingResponseDataReport)this.dataTableReportAction.actionPingDataReportView();
        pingDataTableAction.setNodeInfo(targetNodeInfo);
        optionMenu.add((IAction)pingDataTableAction);
        ActionBuilderNodeDataReport.ActionPingResponseGraphReport pingGraphAction = (ActionBuilderNodeDataReport.ActionPingResponseGraphReport)this.dataTableReportAction.actionPingGraphReportView();
        pingGraphAction.setNodeInfo(targetNodeInfo);
        optionMenu.add((IAction)pingGraphAction);
    }

    public void createPingMenu(Menu popUpMenu, NodeInformation targetNodeInfo, boolean isSocket) {
        MenuItem pingMenuItem = new MenuItem(popUpMenu, 64);
        this.bundle = NetWatcherRCPBirtPlugin.getInstance().getBundle();
        ImageDescriptor chartImageDescriptor = ImageDescriptor.createFromURL((URL)this.bundle.getEntry("icons/chart.gif"));
        ImageDescriptor tableImageDescriptor = ImageDescriptor.createFromURL((URL)this.bundle.getEntry("icons/table.gif"));
        if (this.chartImage == null) {
            this.chartImage = chartImageDescriptor.createImage();
        }
        if (this.tableImage == null) {
            this.tableImage = tableImageDescriptor.createImage();
        }
        pingMenuItem.setText("Node Ping Response Data");
        Menu pingSubmenu = new Menu(pingMenuItem);
        pingMenuItem.setMenu(pingSubmenu);
        String title = String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ") " + "Ping ";
        MenuItem subMenuItemPingTable = new MenuItem(pingSubmenu, 8);
        subMenuItemPingTable.setText(String.valueOf(title) + " Table");
        subMenuItemPingTable.setImage(this.tableImage);
        NodeMapMenuNodePingTable nodePingTable = new NodeMapMenuNodePingTable(targetNodeInfo, isSocket);
        subMenuItemPingTable.addSelectionListener((SelectionListener)nodePingTable);
        MenuItem subMenuItemPingChart = new MenuItem(pingSubmenu, 8);
        subMenuItemPingChart.setText(String.valueOf(title) + " Chart");
        subMenuItemPingChart.setImage(this.chartImage);
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ")");
        NodeMapMenuNodePingChart nodePingChart = new NodeMapMenuNodePingChart(targetNodeInfo, isSocket, nameList);
        subMenuItemPingChart.addSelectionListener((SelectionListener)nodePingChart);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
        if (this.tableImage != null) {
            this.tableImage.dispose();
        }
    }
}

