/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.gui;

import java.util.logging.Logger;
import javax.xml.parsers.FactoryConfigurationError;
import netjfwatcher.birt.action.ActionBuilderAlarmReport;
import netjfwatcher.birt.action.ActionBuilderNodeListReport;
import netjfwatcher.birt.action.ActionBuilderSnmpReport;
import netjfwatcher.birt.action.ListenerNodeTreeReport;
import netjfwatcher.birt.gui.AbstractNodeTreeReportView;
import netjfwatcher.birt.gui.NodePingReportMenu;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class NodeTreeReportView
extends AbstractNodeTreeReportView {
    private static Logger logger = null;
    private ActionBuilderNodeListReport nodeListAction = new ActionBuilderNodeListReport();
    protected ActionBuilderAlarmReport actinAlarm = new ActionBuilderAlarmReport();
    private ActionBuilderSnmpReport snmpReportAction = new ActionBuilderSnmpReport();
    private NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu = new NodeSnmpStatisticsMenu();
    private NodePingReportMenu nodePingReportMenu = new NodePingReportMenu();

    public NodeTreeReportView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.initLog4j();
    }

    private void initLog4j() throws FactoryConfigurationError {
        BasicConfigurator.configure();
    }

    protected void initShow() {
    }

    public void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodeTreeReportView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.nodeListTreeViewer.getControl());
        this.nodeListTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.nodeListTreeViewer);
    }

    protected void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());
        toolBarManager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeDatabase());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    protected void fillContextMenu(IMenuManager manager) {
        TreeItem[] treeItem;
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());
        manager.add(this.getActionNodeTreeBuilder().actionSortNodeTreeDatabase());
        manager.add(this.nodeListAction.getActionNodeListTableReport());
        if (this.nodeListTreeViewer.getTree().getSelection() != null && (treeItem = this.nodeListTreeViewer.getTree().getSelection()) != null && treeItem.length > 0) {
            int nodeTreeSelectNo = 0;
            while (nodeTreeSelectNo < treeItem.length) {
                if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
                    this.nodeListTreeViewer.getTree().deselectAll();
                } else if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTree) {
                    NodeInformation targetNodeInfo = ((NodeTree)treeItem[nodeTreeSelectNo].getData()).getNodeInfo();
                    ((ActionBuilderAlarmReport.ActionNodeAlarmReport)this.actinAlarm.getActionEditorPartNodeAlarmReport()).setNodeInfo(targetNodeInfo);
                    manager.add(this.actinAlarm.getActionEditorPartNodeAlarmReport());
                    ((ActionBuilderSnmpReport.ActionNodeSnmpReportView)this.snmpReportAction.getActionSnmpInfoReport()).setNodeInfo(targetNodeInfo);
                    manager.add(this.snmpReportAction.getActionSnmpInfoReport());
                    this.nodePingReportMenu.createPingMenu(manager, targetNodeInfo, false);
                } else {
                    this.nodeListTreeViewer.getTree().deselectAll();
                }
                ++nodeTreeSelectNo;
            }
        }
        manager.add(this.actinAlarm.getActionAllNodeAlarmListTableReport());
    }

    protected void setupNodeTreeViewListener() {
        this.nodeListTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ListenerNodeTreeReport(false));
    }
}

