/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.gui.editorparts;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.birt.model.ReportEngineFactory;
import netjfwatcher.birt.preference.ReportDesignConfig;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractReportEditorView
extends AbstractEditorNodeView {
    private static Logger logger;
    protected Browser browser;
    protected ProgressBar progressBar;
    protected transient Text reportLocationText = null;
    protected transient Button browseFolderButton = null;
    protected Button showReportButton;
    protected Button htmlOutputButton;
    protected Button pdfOutputButton;
    protected Color textBackColor;
    protected NodeInformation targetNodeInfo;
    protected static final int HORIZONTAL_SPAN4 = 4;
    protected static final int HORIZONTAL_SPAN3 = 3;
    protected static final String PREVIEW_TITLE = "Preview";
    protected static final String HTML_OUT_TITLE = "HTML output";
    protected static final String PDF_OUT_TITLE = "PDF output";
    protected static final int PREVIEW = 0;
    protected static final int HTML_OUT = 1;
    protected static final int PDF_OUT = 2;
    protected static final String ASTALISK = "*";
    protected static final String HTML_FILE_EXT = ".html";
    protected static final String PDF_FILE_EXT = ".pdf";

    public AbstractReportEditorView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    public void createPartControl(Composite parent) {
        this.setEditorInput();
        parent.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        Group reportGroup = new Group(parent, 4);
        reportGroup.setText("Select report:");
        GridLayout layout = new GridLayout(4, false);
        reportGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        reportGroup.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.showReportButton = new Button((Composite)reportGroup, 8);
        this.showReportButton.setText(PREVIEW_TITLE);
        this.htmlOutputButton = new Button((Composite)reportGroup, 8);
        this.htmlOutputButton.setText(HTML_OUT_TITLE);
        this.pdfOutputButton = new Button((Composite)reportGroup, 8);
        this.pdfOutputButton.setText(PDF_OUT_TITLE);
        this.browser = new Browser(parent, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 4;
        this.browser.setLayoutData((Object)gd);
        gd = new GridData(3, 2, false, false);
        gd.heightHint = 10;
        gd.widthHint = 100;
        this.progressBar = new ProgressBar(parent, 2);
        this.progressBar.setLayoutData((Object)gd);
        this.progressBar.setVisible(false);
        this.setListener();
    }

    protected void setListener() {
        if (this.reportLocationText != null) {
            this.reportLocationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                }
            });
        }
        if (this.browseFolderButton != null) {
            this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedLocation;
                    AbstractReportEditorView.this.setButtonEnable(false);
                    FileDialog dialog = new FileDialog(AbstractReportEditorView.this.reportLocationText.getShell());
                    String[] extension = new String[]{"*.rptdesign"};
                    dialog.setFilterExtensions(extension);
                    if (AbstractReportEditorView.this.reportLocationText.getText() != null && AbstractReportEditorView.this.reportLocationText.getText().trim().length() > 0) {
                        dialog.setFilterPath(AbstractReportEditorView.this.reportLocationText.getText());
                    }
                    if ((selectedLocation = dialog.open()) != null) {
                        AbstractReportEditorView.this.reportLocationText.setText(selectedLocation);
                    }
                    AbstractReportEditorView.this.setButtonEnable(true);
                }
            });
        }
        if (this.browser != null) {
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent e) {
                    AbstractReportEditorView.this.progressBar.setVisible(false);
                }

                public void changing(LocationEvent e) {
                    AbstractReportEditorView.this.progressBar.setVisible(true);
                }
            });
        }
        this.showReportButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractReportEditorView.this.setPreView();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.htmlOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractReportEditorView.this.progressBar.setVisible(true);
                AbstractReportEditorView.this.setButtonEnable(false);
                try {
                    try {
                        AbstractReportEditorView.this.setReportFile(1);
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                        MessageDialog.openError((Shell)AbstractReportEditorView.this.getSite().getShell(), (String)"Abort output HTML", (String)exp.getMessage());
                    }
                }
                finally {
                    AbstractReportEditorView.this.setButtonEnable(true);
                    AbstractReportEditorView.this.progressBar.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pdfOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractReportEditorView.this.progressBar.setVisible(true);
                AbstractReportEditorView.this.setButtonEnable(false);
                try {
                    try {
                        AbstractReportEditorView.this.setReportFile(2);
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                        MessageDialog.openError((Shell)AbstractReportEditorView.this.getSite().getShell(), (String)"Abort output PDF", (String)exp.getMessage());
                    }
                }
                finally {
                    AbstractReportEditorView.this.setButtonEnable(true);
                    AbstractReportEditorView.this.progressBar.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setPreView() {
        this.setButtonEnable(false);
        this.progressBar.setVisible(true);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    try {
                        AbstractReportEditorView.this.setReportFile(0);
                    }
                    catch (Exception exp) {
                        AbstractReportEditorView.this.progressBar.setVisible(false);
                        exp.printStackTrace();
                        MessageDialog.openError((Shell)AbstractReportEditorView.this.getSite().getShell(), (String)"Abort preview Report", (String)exp.getMessage());
                    }
                }
                finally {
                    AbstractReportEditorView.this.setButtonEnable(true);
                }
            }
        });
    }

    protected void setButtonEnable(boolean isEnable) {
        if (this.browseFolderButton != null) {
            this.browseFolderButton.setEnabled(isEnable);
        }
        this.showReportButton.setEnabled(isEnable);
        this.htmlOutputButton.setEnabled(isEnable);
        this.pdfOutputButton.setEnabled(isEnable);
    }

    protected void setEditorInput() {
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
    }

    protected void setReportFile(int selectNo) throws EngineException, FileNotFoundException, IOException, Exception {
        String reportFileName = this.getReportDesignFile("node_snmp_table.rptdesign");
        String outputFileRenderOption = "";
        if (selectNo != 0) {
            String fileName = "nodelist";
            String fileExt = "";
            switch (selectNo) {
                case 1: {
                    fileExt = "*.html";
                    fileName = String.valueOf(fileName) + HTML_FILE_EXT;
                    break;
                }
                case 2: {
                    fileExt = "*.pdf";
                    fileName = String.valueOf(fileName) + PDF_FILE_EXT;
                    break;
                }
            }
            outputFileRenderOption = this.setOutputFileDialog(fileName, fileExt);
        }
        this.previewReport(selectNo, reportFileName, outputFileRenderOption);
    }

    protected String setOutputFileDialog(String fileName, String fileExtName) {
        FileDialog openDialog = new FileDialog(this.getEditorSite().getShell(), 4096);
        String[] fileExt = new String[]{fileExtName};
        openDialog.setFileName(fileName);
        openDialog.setFilterExtensions(fileExt);
        openDialog.setFilterPath("./plugins/netjfwatcher_report_0.3.0/output/");
        String openFileName = openDialog.open();
        return openFileName;
    }

    protected void previewReport(int selectNo, String reportFileName, String outpurFileRenderOption) throws EngineException, FileNotFoundException, IOException, Exception {
        IReportEngine engine = ReportEngineFactory.getInstance().createReportEngine();
        IReportRunnable design = null;
        IRunAndRenderTask task = null;
        FileInputStream fs = null;
        ByteArrayOutputStream bos = null;
        try {
            try {
                fs = new FileInputStream(reportFileName);
                design = engine.openReportDesign((InputStream)fs);
                this.setDataSource(design);
                this.serDataSet(design);
                task = engine.createRunAndRenderTask(design);
                if (selectNo != 2) {
                    HTMLRenderContext renderContext = new HTMLRenderContext();
                    renderContext.setImageDirectory("image");
                    HashMap<String, HTMLRenderContext> contextMap = new HashMap<String, HTMLRenderContext>();
                    contextMap.put("HTML_RENDER_CONTEXT", renderContext);
                    task.setAppContext(contextMap);
                } else {
                    PDFRenderContext renderContext = new PDFRenderContext();
                    HashMap<String, PDFRenderContext> contextMap = new HashMap<String, PDFRenderContext>();
                    contextMap.put("PDF_RENDER_CONTEXT", renderContext);
                    task.setAppContext(contextMap);
                }
                bos = new ByteArrayOutputStream();
                this.outPutTask(task, selectNo, bos, outpurFileRenderOption);
                if (task != null) {
                    task.run();
                    task.close();
                    task = null;
                }
                if (selectNo == 0) {
                    this.browser.setText(bos.toString());
                }
            }
            catch (EngineException e) {
                throw e;
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException(String.valueOf(reportFileName) + " " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (task != null) {
                task.close();
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected String getReportDesignFile(String fileName) throws EngineException, FileNotFoundException, IOException, Exception {
        String filePath = "";
        filePath = DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby") ? "/plugins/netjfwatcher_report_0.3.0/rptdesign/derby/derby_" + fileName : "/plugins/netjfwatcher_report_0.3.0/rptdesign/" + fileName;
        String file = "." + ReportDesignConfig.getInstance().getDocument(filePath);
        return file;
    }

    protected void outPutTask(IRunAndRenderTask task, int select, ByteArrayOutputStream bos, String outpurFileRenderOption) {
        switch (select) {
            case 0: {
                HTMLRenderOption options = new HTMLRenderOption();
                options.setOutputStream((OutputStream)bos);
                options.setOutputFormat("html");
                task.setRenderOption((IRenderOption)options);
                break;
            }
            case 1: {
                HTMLRenderOption options = new HTMLRenderOption();
                options.setOutputFileName(outpurFileRenderOption);
                options.setOutputFormat("html");
                task.setRenderOption((IRenderOption)options);
                break;
            }
            case 2: {
                RenderOptionBase options = new RenderOptionBase();
                options.setOutputFileName(outpurFileRenderOption);
                options.setOutputFormat("pdf");
                task.setRenderOption((IRenderOption)options);
                break;
            }
            default: {
                logger.warning("Abort output");
            }
        }
    }

    protected void setDataSource(IReportRunnable design) throws SemanticException {
        ResourceInfo info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        System.out.println("suf : nodewatch");
        System.out.println("name : " + info.getDatabaseName());
        System.out.println("driver : " + info.getDatabaseDriver());
        System.out.println("url : " + info.getDatabaseUrl());
        System.out.println("user : " + info.getDatabaseUser());
        System.out.println("password : " + info.getDatabasePassword());
        String driver = info.getDatabaseDriver();
        String url = String.valueOf(info.getDatabaseUrl()) + "nodewatch";
        String user = info.getDatabaseUser();
        String password = info.getDatabasePassword();
        List contents = design.getDesignHandle().getModuleHandle().getAllDataSources();
        int i = 0;
        while (i < contents.size()) {
            Object odaPasswordObj;
            Object odaUserObj;
            Object odaURLObj;
            OdaDataSourceHandle dataSource = (OdaDataSourceHandle)contents.get(i);
            Object odaDriverClassObj = dataSource.getProperty("odaDriverClass");
            if (odaDriverClassObj != null) {
                dataSource.setProperty("odaDriverClass", (Object)driver);
            }
            if ((odaURLObj = dataSource.getProperty("odaURL")) != null) {
                dataSource.setProperty("odaURL", (Object)url);
            }
            if ((odaUserObj = dataSource.getProperty("odaUser")) != null) {
                if (user != null) {
                    dataSource.setProperty("odaUser", (Object)user);
                } else {
                    dataSource.setProperty("odaUser", (Object)"");
                }
            }
            if ((odaPasswordObj = dataSource.getProperty("odaPassword")) != null) {
                if (password != null) {
                    dataSource.setProperty("odaPassword", (Object)password);
                } else {
                    dataSource.setProperty("odaPassword", (Object)"");
                }
            }
            System.out.println("odaDriverClass " + dataSource.getProperty("odaDriverClass"));
            System.out.println("odaURL " + dataSource.getProperty("odaURL"));
            System.out.println("odaUser " + dataSource.getProperty("odaUser"));
            System.out.println("odaPassword " + dataSource.getProperty("odaPassword"));
            ++i;
        }
    }

    protected void serDataSet(IReportRunnable design) throws SemanticException {
        String ipAddress = null;
        if (this.targetNodeInfo != null) {
            ipAddress = this.targetNodeInfo.getIpaddress();
        }
        List contents2 = design.getDesignHandle().getModuleHandle().getAllDataSets();
        int i = 0;
        while (i < contents2.size()) {
            OdaDataSetHandle dataSet = (OdaDataSetHandle)contents2.get(i);
            System.out.println("getModule " + design.getDesignHandle().getModule());
            System.out.println("queryText " + dataSet.getQueryText());
            if (ipAddress != null) {
                String sql = this.getSql(ipAddress, null, null);
                System.out.println("sql " + sql);
                if (sql != null && !sql.equals("")) {
                    dataSet.setQueryText(sql);
                }
            }
            ++i;
        }
    }

    protected String getSql(String ipaddress, String startTime, String endTime) {
        return "";
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }
}

