/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.gui.editorparts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.birt.gui.editorparts.AbstractReportEditorView;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.widgets.Display;

public class AlarmListTableReportEditorView
extends AbstractReportEditorView {
    private static Logger logger;

    public AlarmListTableReportEditorView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    protected void setReportFile(int selectNo) throws EngineException, FileNotFoundException, IOException, Exception {
        String reportFileName = this.getReportDesignFile("alarm_list.rptdesign");
        String outputFileRenderOption = "";
        if (selectNo != 0) {
            String fileName = "alarmlist";
            if (this.targetNodeInfo != null) {
                String convIPAddress;
                String ipAddress = this.targetNodeInfo.getIpaddress();
                fileName = convIPAddress = "IP" + ipAddress.replace('.', '_') + "_Alarm";
            }
            String fileExt = "";
            switch (selectNo) {
                case 1: {
                    fileExt = "*.html";
                    fileName = String.valueOf(fileName) + ".html";
                    break;
                }
                case 2: {
                    fileExt = "*.pdf";
                    fileName = String.valueOf(fileName) + ".pdf";
                    break;
                }
            }
            outputFileRenderOption = this.setOutputFileDialog(fileName, fileExt);
        }
        this.previewReport(selectNo, reportFileName, outputFileRenderOption);
    }

    protected void serDataSet(IReportRunnable design) throws SemanticException {
        String ipAddress = null;
        if (this.targetNodeInfo != null) {
            ipAddress = this.targetNodeInfo.getIpaddress();
        }
        List contents2 = design.getDesignHandle().getModuleHandle().getAllDataSets();
        int i = 0;
        while (i < contents2.size()) {
            OdaDataSetHandle dataSet = (OdaDataSetHandle)contents2.get(i);
            if (ipAddress != null) {
                String sql = this.getSql(ipAddress, null, null);
                System.out.println("sql " + sql);
                if (sql != null && !sql.equals("")) {
                    dataSet.setQueryText(sql);
                }
            }
            ++i;
        }
    }

    protected String getSql(String ipaddress, String startTime, String endTime) {
        String cfr_ignored_0 = "IP" + ipaddress.replace('.', '_');
        String sql = "";
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
            sql = "SELECT * from alarm_table where " + "alarm_confirm".toUpperCase() + " = " + "'" + "unconfirm" + "' " + " and " + "ipaddress".toUpperCase() + "=" + "'" + ipaddress + "' " + " order by " + "id".toUpperCase() + " " + "desc";
            return sql;
        }
        sql = "SELECT * from alarm_table where alarm_confirm = 'unconfirm'  and ipaddress='" + ipaddress + "' " + " order by " + "id" + " " + "desc";
        return sql;
    }
}

