/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.gui.editorparts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.birt.gui.editorparts.AbstractReportEditorView;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.swt.widgets.Display;

public class NodeSnmpReportEditorView
extends AbstractReportEditorView {
    private static Logger logger;

    public NodeSnmpReportEditorView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    protected void setReportFile(int selectNo) throws EngineException, FileNotFoundException, IOException, Exception {
        String reportFileName = this.getReportDesignFile("node_snmp_table.rptdesign");
        String outputFileRenderOption = "";
        if (selectNo != 0) {
            String ipAddress = this.targetNodeInfo.getIpaddress();
            String convIPAddress = "IP" + ipAddress.replace('.', '_') + "_SNMP";
            String fileExt = "";
            switch (selectNo) {
                case 1: {
                    fileExt = "*.html";
                    convIPAddress = String.valueOf(convIPAddress) + ".html";
                    break;
                }
                case 2: {
                    fileExt = "*.pdf";
                    convIPAddress = String.valueOf(convIPAddress) + ".pdf";
                    break;
                }
            }
            outputFileRenderOption = this.setOutputFileDialog(convIPAddress, fileExt);
        }
        this.previewReport(selectNo, reportFileName, outputFileRenderOption);
    }

    protected void serDataSet(IReportRunnable design) throws SemanticException {
        String ipAddress = this.targetNodeInfo.getIpaddress();
        System.out.println("ipAddress " + ipAddress);
        List contents2 = design.getDesignHandle().getModuleHandle().getAllDataSets();
        int i = 0;
        while (i < contents2.size()) {
            OdaDataSetHandle dataSet = (OdaDataSetHandle)contents2.get(i);
            List resultSetList = dataSet.getListProperty("resultSet");
            int j = 0;
            while (j < resultSetList.size()) {
                ResultSetColumn cfr_ignored_0 = (ResultSetColumn)resultSetList.get(j);
                ++j;
            }
            CachedMetaDataHandle ca = dataSet.getCachedMetaDataHandle();
            ca.getResultSet();
            System.out.println("getModule " + design.getDesignHandle().getModule());
            System.out.println("queryText " + dataSet.getQueryText());
            System.out.println("getResultSetName " + dataSet.getResultSetName());
            System.out.println("getName " + dataSet.getName());
            if (ipAddress != null) {
                String sql;
                if (dataSet.getName().equals("node_snmp_sys")) {
                    sql = this.getSystemMibSql(ipAddress);
                    System.out.println("sql " + sql);
                    if (sql != null && !sql.equals("")) {
                        dataSet.setQueryText(sql);
                    }
                }
                if (dataSet.getName().equals("node_snmp_if")) {
                    sql = this.getInterfaceMibSql(ipAddress);
                    System.out.println("sql " + sql);
                    if (sql != null && !sql.equals("")) {
                        dataSet.setQueryText(sql);
                    }
                }
            }
            ++i;
        }
    }

    protected String getSystemMibSql(String ipaddress) {
        String convIPAddress = "IP" + ipaddress.replace('.', '_');
        String tableName = String.valueOf(convIPAddress.replace('-', '_')) + "_snmp";
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
            String sql = "SELECT * from " + tableName.toUpperCase() + " order by " + "curdate".toUpperCase() + " desc";
            return sql;
        }
        String sql = "SELECT * from " + tableName + " order by " + "curdate" + " desc";
        return sql;
    }

    protected String getInterfaceMibSql(String ipaddress) {
        String convIPAddress = "IP" + ipaddress.replace('.', '_');
        String tableName = String.valueOf(convIPAddress.replace('-', '_')) + "_if";
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
            String sql = "SELECT * from " + tableName.toUpperCase() + " order by " + "ifIndex".toUpperCase() + " asc";
            return sql;
        }
        String sql = "SELECT * from " + tableName + " order by " + "ifIndex" + " asc";
        return sql;
    }
}

