/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.birt.gui.editorparts;

import java.util.logging.Logger;
import netjfwatcher.birt.action.PreviewBirtAction;
import netjfwatcher.birt.gui.editorparts.AbstractReportEditorView;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class PreviewBirtViewer
extends AbstractReportEditorView {
    private static Logger logger;

    public PreviewBirtViewer() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        Group reportGroup = new Group(parent, 4);
        reportGroup.setText("Select report:");
        GridLayout layout = new GridLayout(2, false);
        reportGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        reportGroup.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label label = new Label((Composite)reportGroup, 0);
        label.setText("Full Path:");
        label.setLayoutData((Object)gd);
        this.reportLocationText = new Text((Composite)reportGroup, 2048);
        gd = new GridData(768);
        this.reportLocationText.setLayoutData((Object)gd);
        this.reportLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.browseFolderButton = new Button((Composite)reportGroup, 131072);
        this.browseFolderButton.setText("...");
        this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PreviewBirtViewer.this.reportLocationText.getShell());
                String[] extension = new String[]{"*.rptdesign"};
                dialog.setFilterExtensions(extension);
                if (PreviewBirtViewer.this.reportLocationText.getText() != null && PreviewBirtViewer.this.reportLocationText.getText().trim().length() > 0) {
                    dialog.setFilterPath(PreviewBirtViewer.this.reportLocationText.getText());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    PreviewBirtViewer.this.reportLocationText.setText(selectedLocation);
                }
            }
        });
        Button showReport = new Button((Composite)reportGroup, 8);
        showReport.setText("Run Report");
        showReport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreviewBirtViewer.this.previewReport();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.browser = new Browser(parent, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.browser.setLayoutData((Object)gd);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent e) {
                PreviewBirtViewer.this.progressBar.setVisible(false);
            }

            public void changing(LocationEvent e) {
                PreviewBirtViewer.this.progressBar.setVisible(true);
            }
        });
        gd = new GridData(3, 2, false, false);
        gd.heightHint = 10;
        gd.widthHint = 100;
        this.progressBar = new ProgressBar(parent, 2);
        this.progressBar.setLayoutData((Object)gd);
        this.progressBar.setVisible(false);
        WebViewer.startup((Browser)this.browser);
    }

    private void previewReport() {
        String report = this.reportLocationText.getText();
        if (report.length() != 0) {
            PreviewBirtAction preview = new PreviewBirtAction();
            preview.setReportName(report);
            preview.setBrowser(this.browser);
            preview.run();
            preview.dispose();
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }
}

