/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.action;

import java.util.logging.Logger;

import netjfwatcher.birt.gui.editorparts.AlarmListTableReportEditorView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * A[ ReportɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderAlarmReport {
	/* MO */
	private static Logger logger;

	/* m[hA[|[g\ANV */
	private IAction editorAlarm = new ActionNodeAlarmReport();

	/* Sm[hA[|[g\ANV */
	private IAction showAllNodeAlarmListTableAction = new ActionAllNodeAlarmReport();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance()
			.getBundle();

	/**
	 * AlarmXg|[gViewɊւANVNX CX^X𐶐܂B
	 * 
	 */
	public ActionBuilderAlarmReport() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Sm[hA[|[g\ANVԂ܂B
	 * 
	 * @return showAlarmListTableAction Sm[hA[|[g\ANV
	 */
	public IAction getActionAllNodeAlarmListTableReport() {
		return showAllNodeAlarmListTableAction;
	}

	/**
	 * m[hA[|[g\ANVԂ܂B
	 * 
	 * @return editorAlarm m[hA[|[g\ANV
	 */
	public IAction getActionEditorPartNodeAlarmReport() {
		return editorAlarm;
	}

	/**
	 * A[|[gɊւANV`钊ۃNXłB
	 * 
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractAlarmListAction extends Action {
		public final void run() {
			doTask();
		}

		protected abstract void doTask();
	}

	/**
	 * Sm[hA[|[g\ Editor part\ANVNXłB
	 * 
	 */
	protected class ActionAllNodeAlarmReport extends AbstractAlarmListAction {
		/**
		 * Sm[hA[|[g\ANV ImageDescriptorԂ܂B
		 * 
		 * @return ACRImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry(ActionPreference.ALARM_LIST_REPORT_IMAGE_DESC));
		}

		/**
		 * Sm[hA[|[g\ANṼeLXgԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return ActionPreference.ALARM_LIST_REPORT_TEXT;
		}

		/**
		 * Sm[hA[|[g\ANVToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 * 
		 */
		public String getToolTipText() {
			return ActionPreference.ALARM_LIST_REPORT_TOOLTIP_TEXT;
		}

		/**
		 * Sm[hA[|[g\܂B
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			try {
				/*
				 * EditorɃuEUI[v EditorID̓uEŨNX
				 */
				activePage.openEditor(new EditorInputNodeView(
						"All alarm report", null, false),
						AlarmListTableReportEditorView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}
	}

	/**
	 * m[h̃A[|[g\ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public class ActionNodeAlarmReport extends AbstractAlarmListAction {
		/** m[hĎ */
		protected NodeInformation nodeInfo;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor
					.createFromURL(bundle
							.getEntry(ActionPreference.NODE_ALARM_LIST_REPORT_IMAGE_DESC));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return ActionPreference.NODE_ALARM_LIST_REPORT_TEXT;
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return ActionPreference.NODE_ALARM_LIST_REPORT_TOOLTIP_TEXT;
		}

		/**
		 * m[hA[|[g\^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";

			try {
				/*
				 * IꂽGg̃m[hĎ񂩂EditorɃI[v
				 */
				activePage.openEditor(new EditorInputNodeView(nodeName
						+ " alarm report", nodeInfo, false),
						AlarmListTableReportEditorView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo
		 *            m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}

}
