/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.action;

import java.util.logging.Logger;

import netjfwatcher.birt.gui.editorparts.PingGraphReportEditorView;
import netjfwatcher.birt.gui.editorparts.PingTableReportEditorView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsData;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

import com.sun.corba.se.impl.orbutil.graph.Node;

/**
 * f[^|[g\ANVNXNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeDataReport {
	/* MO */
	private static Logger logger;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance()
			.getBundle();

	/*
	 * EditorPartEditorPartJxɁAUEditorPart
	 * CloseĂOpen
	 */
	private IEditorPart editorNodeConfigView;

	/* m[hPingf[^|[g\ANV */
	private IAction showPingData = new ActionPingResponseDataReport();

	/* m[hPingf[^Ot|[g\ANV */
	private IAction showPingGraph = new ActionPingResponseGraphReport();

	/**
	 * f[^|[g\ANVNXNX
	 * CX^X𐶐܂B
	 */
	public ActionBuilderNodeDataReport() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * m[hPingf[^|[g\ANVԂ܂B
	 * 
	 * @return showPingData m[hPingf[^|[g\ANV
	 */
	public IAction actionPingDataReportView() {
		return showPingData;
	}

	/**
	 * m[hPingf[^Ot|[g\ANVԂ܂B
	 * 
	 * @return showPingData m[hPingf[^Ot|[g\ANV
	 */
	public IAction actionPingGraphReportView() {
		return showPingGraph;
	}

	/**
	 * m[hSNMPvf[^e[u\ANVԂ܂B
	 * 
	 * @return m[hSNMPvf[^e[u\ANV
	 */
	public IAction actionShowStatisticsDataReport() {
		return new ActionShowStatisticsDataReport();
	}

	/**
	 * lbg[NoRł̃m[hSNMPvf[^e[u\ANVԂ܂B
	 * 
	 * @return lbg[NoRł̃m[hSNMPvf[^e[u\ANV
	 */
	public IAction actionShowStatisticsDataReportSocket() {
		return new ActionShowStatisticsDataReportSocket();
	}

	/**
	 * m[h̒ǉA폜ɊւANV̒ۊNXB  ܂؂ދȏĂB
	 * <p>
	 * {@link #doTask(FeedGroup, Node)}ΊȒPɃANVI
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractDataTableReportAction extends Action {
		/**
		 * ANV܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANV^XNłB
		 */
		protected abstract void doTask();
	}

	/**
	 * m[hSNMPv\ANVNXłB
	 * 
	 * @author Yoshimasa matsumoto
	 * @version 1.0
	 */
	public final class ActionShowStatisticsDataReport extends
			AbstractDataTableReportAction {
		/* m[hĎ */
		private NodeInformation nodeInfo;

		/* SNMPv\OID */
		private String oid;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/table.gif"));
		}

		/**
		 * Node Snmp View\^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";

			try {
				if (editorNodeConfigView != null) {
					activePage.closeEditor(editorNodeConfigView, false);
					editorNodeConfigView = null;
				}

				/*
				 * IꂽGg̃m[hURLEditorɃuEU I[v
				 */
				editorNodeConfigView = activePage.openEditor(
						new EditorInputNodeView(nodeName
								+ EditorNodeSnmpStatisticsData.TITLE_SUFFIX
								+ " OID=" + oid, nodeInfo, false, oid),
						EditorNodeSnmpStatisticsData.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[h̓v\sOIDݒ肵܂B
		 * 
		 * @param oid
		 *            v\sOID
		 */
		public void setOid(String oid) {
			this.oid = oid;
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo
		 *            m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}

	/**
	 * lbg[NoRł̃m[hSNMPv\ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionShowStatisticsDataReportSocket extends
			AbstractDataTableReportAction {
		/* m[hĎ */
		private NodeInformation nodeInfo;

		/* SNMPv\OID */
		private String oid;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/table.gif"));
		}

		/**
		 * Node Snmp View\^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			/*  */
			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";

			try {
				if (editorNodeConfigView != null) {
					activePage.closeEditor(editorNodeConfigView, false);
					editorNodeConfigView = null;
				}

				/*
				 * IꂽGg̃m[hURLEditorɃuEU I[v
				 */
				editorNodeConfigView = activePage.openEditor(
						new EditorInputNodeView(nodeName
								+ EditorNodeSnmpStatisticsData.TITLE_SUFFIX
								+ " OID="
								+ oid
								+ NetworkClientNodeTreeView
										.getTitleSuffixEngineAddress(),
								nodeInfo, true, oid),
						EditorNodeSnmpStatisticsData.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[h̓v\sOIDݒ肵܂B
		 * 
		 * @param oid
		 *            v\sOID
		 */
		public void setOid(String oid) {
			this.oid = oid;
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo
		 *            m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}

	/**
	 * Pingf[^\ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionPingResponseDataReport extends
			AbstractDataTableReportAction {
		/* m[hĎ */
		private NodeInformation nodeInfo;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor
					.createFromURL(bundle
							.getEntry(ActionPreference.NODE_PING_TABLE_REPORT_IMAGE_FILE));
		}

		/**
		 * Pingf[^\ANṼeLXgԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return ActionPreference.NODE_PING_TABLE_REPORT_TEXT;
		}

		/**
		 * Pingf[^\ANVToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return ActionPreference.NODE_PING_TABLE_REPORT_TOOL_TIP;
		}

		/**
		 * Node Pingf[^View\^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			/* m[h */
			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";

			try {
				if (editorNodeConfigView != null) {
					activePage.closeEditor(editorNodeConfigView, false);
					editorNodeConfigView = null;
				}

				/*
				 * IꂽGg̃m[hURLEditorɃuEU I[v
				 */
				editorNodeConfigView = activePage.openEditor(
						new EditorInputNodeView(nodeName
								+ " Ping response table report", nodeInfo,
								false), PingTableReportEditorView.class
								.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo
		 *            m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}

	/**
	 * Pingf[^\ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionPingResponseGraphReport extends
			AbstractDataTableReportAction {
		/* m[hĎ */
		private NodeInformation nodeInfo;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor
					.createFromURL(bundle
							.getEntry(ActionPreference.NODE_PING_CHART_REPORT_IMAGE_FILE));
		}

		/**
		 * Pingf[^\ANṼeLXgԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return ActionPreference.NODE_PING_CHART_REPORT_TEXT;
		}

		/**
		 * Pingf[^\ANVToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return ActionPreference.NODE_PING_CHART_REPORT_TOOL_TIP;
		}

		/**
		 * Node Pingf[^View\^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			/* m[h */
			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";

			try {
				if (editorNodeConfigView != null) {
					activePage.closeEditor(editorNodeConfigView, false);
					editorNodeConfigView = null;
				}

				/*
				 * IꂽGg̃m[hURLEditorɃuEU I[v
				 */
				editorNodeConfigView = activePage.openEditor(
						new EditorInputNodeView(nodeName
								+ " Ping response graph report", nodeInfo,
								false), PingGraphReportEditorView.class
								.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo
		 *            m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}
}
