/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.action;

import java.util.logging.Logger;

import netjfwatcher.birt.gui.editorparts.NodeListTableReportEditorView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * NodeXg ReportANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeListReport {
	/* MO */
	private static Logger logger;


	/* Node Liste[u\XVANV */
	private IAction showNodeListTableReportAction = new ActionShowNodeListTable();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance()
			.getBundle();

	/**
	 * NodeXgViewł̃ANVNXCX^X ܂B
	 * 
	 */
	public ActionBuilderNodeListReport() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Node liste[u\ANVԂ܂B
	 * 
	 * @return NNode list reportr[̃ANV
	 */
	public IAction getActionNodeListTableReport() {
		return showNodeListTableReportAction;
	}

	/**
	 * Node list reportr[ɊւANVNXłB
	 * 
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractNodeListAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANVs^XNłB
		 * 
		 */
		protected abstract void doTask();
	}

	/**
	 * Node ListǂݍŃe[u\ANVNXłB
	 */
	protected class ActionShowNodeListTable extends AbstractNodeListAction {
		/**
		 * Node list reportr[̃ANṼACR ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry(ActionPreference.NODE_LIST_REPORT_IMAGE_DESC));
		}

		/**
		 * Node list reportr[̃ANVText Ԃ܂B
		 * 
		 * @return Node ListǂݍŃe[u\ANV Text
		 */
		public String getText() {
			return ActionPreference.NODE_LIST_REPORT_TEXT;
		}

		/**
		 * Node list reportr[̃ANVToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return ActionPreference.NODE_LIST_REPORT_TOOLTIP_TEXT;
		}

		/**
		 * Node list reportr[\܂B
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			try {
				activePage.openEditor(new EditorInputNodeView(
						"Node list report", null, false),
						NodeListTableReportEditorView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}
	}

}
