/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.action;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.birt.gui.AbstractNodeTreeReportView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.common.view.INodeTreeNode;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.webbrowser.nodetree.NodeListImport;
import netjfwatcher.webbrowser.nodetree.NodeListXmlParse;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import netjfwatcher.webbrowser.view.HttpAccessException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.osgi.framework.Bundle;

/**
 * m[hTree ViewɂANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeTreeReport extends Action {
	/* MO */
	private static Logger logger = null;

	/*
	 * m[hIcon ImageIcon image filekeyƂĕێ (Icon imageQdɐ邱Ɩh~ƂƂɁA
	 * finalize()ImagejꍇɎgp)
	 */
	private HashMap nodeIconImageMap = new HashMap();

	/* TreeViewer */
	private TreeViewer nodeListTreeViewer;

	/* Xe[^XC}l[W擾pView */
	private AbstractNodeTreeReportView nodeTreeView;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* Composite */
	private Composite parentComposite;

	/* NodeTreeGroup */
	private NodeTreeGroup nodeTreeGroupRoot;

	/*
	 * m[hViewō\\EditorPartEditorPart
	 * JxɁAUEditorPartCloseĂOpen
	 */
	private IEditorPart editorNodeConfigView;

	/*
	 * HTTPɂĎ擾m[hĎ񃊃Xg (m[hTree\[gpɕێ)
	 */
	private ArrayList nodeInfoListHttp = new ArrayList();

	/*
	 * SocketɂĎ擾m[hĎ񃊃Xg (m[hTree\[gpɕێ)
	 */
	private ArrayList nodeInfoListSocket = new ArrayList();

	/*
	 * GroupǗMapGroupɑ݂Ă邩AVK Group쐬邩̔fɎgp
	 */
	private HashMap groupMap = new HashMap();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance()
			.getBundle();

	/*
	 * f[^x[Xǂݍ񂾃m[hĎɂăm[hTreeZbg ANV
	 */
	private IAction reloadNodeTreeDatabase = new ActionReloadNodeTreeDatabase();

	/*
	 * HTTPT[oǂݍ񂾃m[hĎɂăm[hTreeZbg ANV
	 */
	private IAction reloadNodeTreeHttp = new ActionReloadNodeTreeHttp();

	/*
	 * lbg[NoR(Socket)œǂݍ񂾃m[hĎɂăm[hTreeZbg ANV
	 */
	private IAction reloadNodeTreeSocket = new ActionReloadNodeTreeSocket();

	/* m[hTree\[gANV(f[^x[Xm[hĎ) */
	private IAction sortNodeTreeDatabase = new ActionSortNodeTreeDatabase();

	/*
	 * m[hTree\[gANV(HTTPT[oǂݍ񂾃m[hĎ ̃\[g)
	 */
	private IAction sortNodeTreeHttp = new ActionSortNodeTreeHttp();

	/*
	 * m[hTree\[gANV(lbg[NoR(Socket)ǂݍ񂾃m[hĎ ̃\[g)
	 */
	private IAction sortNodeTreeSocket = new ActionSortNodeTreeSocket();

	/**
	 * m[hTree ViewɂANVNXCX^X 𐶐܂B
	 * 
	 */
	public ActionBuilderNodeTreeReport() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * m[hTree ViewɂANVNXCX^X 𐶐܂B
	 * 
	 * @param nodeTreeView
	 *            AbstractNodeTreeView
	 * @param nodeListTreeViewer
	 *            TreeViewer
	 * @param parentComposite
	 *            Composite
	 * @param nodeTreeGroupRoot
	 *            NodeTreeGroup
	 */
	public ActionBuilderNodeTreeReport(AbstractNodeTreeReportView nodeTreeView,
			TreeViewer nodeListTreeViewer, Composite parentComposite,
			NodeTreeGroup nodeTreeGroupRoot) {
		logger = Logger.getLogger(this.getClass().getName());
		this.nodeTreeView = nodeTreeView;
		this.nodeListTreeViewer = nodeListTreeViewer;
		this.parentComposite = parentComposite;
		this.nodeTreeGroupRoot = nodeTreeGroupRoot;
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return nodeListTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return nodeListTreeViewer;
	}

	/**
	 * m[hTreeǂݍ݃ANVԂ܂B
	 * 
	 * @return reloadNodeTree m[hTreeǂݍ݃ANV
	 */
	public IAction actionReloadNodeTreeDatabase() {
		return reloadNodeTreeDatabase;
	}

	/**
	 * HTTPoRł̃m[hTreeXVANVԂ܂B
	 * 
	 * @return reloadNodeTreeHttp HTTPoRł̃m[hTreeXVANV
	 */
	public IAction actionReloadNodeTreeHttp() {
		return reloadNodeTreeHttp;
	}

	/**
	 * lbg[NoRł̃m[hTreeXVANVԂ܂B
	 * 
	 * @return reloadNodeTreeSocket lbg[NoRł̃m[hTreeXVANV
	 */
	public IAction actionReloadNodeTreeSocket() {
		return reloadNodeTreeSocket;
	}

	/**
	 * m[hTree\[gANVԂ܂B
	 * 
	 * @return sortNodeTreeDatabase m[hTree\[gANV
	 */
	public IAction actionSortNodeTreeDatabase() {
		return sortNodeTreeDatabase;
	}

	/**
	 * HTTPoRł̃m[hTree\[gANVԂ܂B
	 * 
	 * @return sortNodeTreeHttp HTTPoRł̃m[hTree\[gANV
	 */
	public IAction actionSortNodeTreeHttp() {
		return sortNodeTreeHttp;
	}

	/**
	 * lbg[NoRł̃m[hTree\[gANVԂ܂B
	 * 
	 * @return sortNodeTreeSocket lbg[NoRł̃m[hTree\[gANV
	 */
	public IAction actionSortNodeTreeSocket() {
		return sortNodeTreeSocket;
	}

	/**
	 * m[hĎ񂩂m[hTreeTree groupTree node(m[h + IP Address)𐶐Am[hTree
	 * Viewɒǉ܂B
	 * 
	 * @param nodeInfo
	 *            m[h
	 * @param isSortDirectionTreeView
	 *            Tree View\[g
	 */
	private void createNodeTree(NodeInformation nodeInfo,
			final boolean isSortDirectionTreeView) {
		/* O[vo */
		String group = nodeInfo.getGroup();

		/* m[hTreeO[v𐶐 */
		NodeTreeGroup nodetreeGroup = null;

		if (groupMap.containsKey(group)) {
			/* 擾Groupɑ݂ꍇɂ́AGroup擾 */
			nodetreeGroup = (NodeTreeGroup) groupMap.get(group);
		} else {
			/* 擾GroupVȖȌꍇGroupVK쐬 */
			nodetreeGroup = new NodeTreeGroup(group);

			/* m[hTree RootGroupǉ */
			nodeTreeGroupRoot.addChild(nodetreeGroup);
			groupMap.put(group, nodetreeGroup);
		}

		/* Tree\NodeZbg */
		String nodeName = nodeInfo.getNodename() + "("
				+ nodeInfo.getIpaddress() + ")";

		/* m[hʂɑΉm[hIconC[W擾 */
		Image nodeIconImage = null;
		nodeIconImage = createNodeIconImage(nodeInfo.getNodeKind());

		/* m[hGroupɃm[hǉ */
		nodetreeGroup.addChild(new NodeTree(nodeName, nodeInfo, nodeIconImage));

		/* TreeView\[g */
		nodeListTreeViewer.setSorter(new ViewerSorter() {
			/*
			 * ViewerSortercompare\bhI[o[ChA /~\[gtOɂTreeView\[g܂B
			 * 
			 * @see org.eclipse.jface.viewers.
			 *      ViewerSorter#compare(org.eclipse.jface.viewers.Viewer,
			 *      java.lang.Object, java.lang.Object)
			 */
			public int compare(Viewer viewer, Object e1, Object e2) {
				int cat1 = category(e1);
				int cat2 = category(e2);

				if (cat1 != cat2) {
					return cat1 - cat2;
				}

				// cat1 == cat2
				String name1;
				String name2;

				if ((viewer == null) || !(viewer instanceof ContentViewer)) {
					name1 = e1.toString();
					name2 = e2.toString();
				} else {
					IBaseLabelProvider prov = ((ContentViewer) viewer)
							.getLabelProvider();

					if (prov instanceof ILabelProvider) {
						ILabelProvider lprov = (ILabelProvider) prov;
						name1 = lprov.getText(e1);
						name2 = lprov.getText(e2);
					} else {
						name1 = e1.toString();
						name2 = e2.toString();
					}
				}

				if (name1 == null) {
					name1 = ""; //$NON-NLS-1$
				}

				if (name2 == null) {
					name2 = ""; //$NON-NLS-1$
				}

				if (isSortDirectionTreeView) {
					// \[g
					return collator.compare(name1, name2);
				}

				// ~\[g
				return collator.compare(name2, name1);
			}
		});

		nodeListTreeViewer.expandAll();
		nodeListTreeViewer.refresh();
	}

	/*
	 * w̃m[hʂm[hIcon Image𐶐ĕԂ܂B
	 * 
	 * @param nodeKind m[h @return nodeIconImage m[hIconC[W
	 */
	private Image createNodeIconImage(String nodeKind) {
		/*
		 * m[hʂɑΉm[hIconC[Wt@C LqXMLt@CList𐶐Am[hIcon C[Wt@C擾
		 */
		String nodeIconFileName = MediaResource.getInstance()
				.getNodeIconFullFileName(nodeKind);
		Image nodeIconImage = null;

		if (!nodeIconImageMap.containsKey(nodeIconFileName)) {
			Display display = parentComposite.getDisplay();

			URL url = null;
			url = bundle.getEntry(nodeIconFileName);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger.severe("Npt found icon file : " + nodeIconFileName);
			} else {
				try {
					/* m[hIconC[W */
					nodeIconImage = new Image(display, url.openStream());

					/* m[hIconC[WMapɊi[ */
					nodeIconImageMap.put(nodeIconFileName, nodeIconImage);
				} catch (IOException e) {
					logger.warning("Abort create image " + e.getMessage()
							+ " for " + nodeIconFileName);
					e.printStackTrace();
				}
			}
		} else {
			nodeIconImage = (Image) nodeIconImageMap.get(nodeIconFileName);
		}

		return nodeIconImage;
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 * @param groupNo
	 *            O[v
	 * @param nodeNo
	 *            m[h
	 */
	protected void setStatusLine(int groupNo, int nodeNo) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (nodeTreeView.getViewSite()
				.getActionBars().getStatusLineManager());

		statusLineManager.setVisible(true);
		statusLineManager.setMessage("Node Tree View " + "Group count="
				+ groupNo + " Node count=" + nodeNo);
	}

	/**
	 * m[hTreȇIm[hԂ܂B
	 * 
	 * @return node m[h
	 */
	public INodeTreeNode getNodeBase() {
		// TreeIm[ho
		IStructuredSelection selectElement = (IStructuredSelection) getViewer()
				.getSelection();
		INodeTreeNode node = (INodeTreeNode) selectElement.getFirstElement();

		if (node == null) {
			node = (INodeTreeNode) getViewer().getInput();
		}

		return node;
	}

	/**
	 * m[hO[vԂ܂B
	 * 
	 * @param node
	 *            m[h
	 * @return baseNodeGroup m[hO[v
	 */
	public NodeTreeGroup setNodeGroupBase(INodeTreeNode node) {
		NodeTreeGroup baseNodeGroup = null;

		if (node != null) {
			baseNodeGroup = node.getParent();
		}

		if (node instanceof NodeTreeGroup) {
			baseNodeGroup = (NodeTreeGroup) node;
		}

		return baseNodeGroup;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* m[hIcon imagej */
		Map list = nodeIconImageMap;
		Iterator it = null;

		for (it = list.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			Image nodeIconImage = (Image) list.get(key);

			if (nodeIconImage != null) {
				nodeIconImage.dispose();
			}
		}
	}

	/**
	 * ANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractNodeAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			NodeTreeGroup baseNodeGroup = null;

			INodeTreeNode node = getNodeBase();
			baseNodeGroup = setNodeGroupBase(node);

			doTask(baseNodeGroup, node);
		}

		/**
		 * ANVs^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected abstract void doTask(NodeTreeGroup group, INodeTreeNode node);

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/reload.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Node Tree reload";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Node Tree reload";
		}
	}

	/**
	 * f[^x[Xm[hĎǂݍŁAm[hTree\ ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionReloadNodeTreeDatabase extends AbstractNodeAction {
		/**
		 * f[^x[Xm[hĎǂݍŁAm[hTree \^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
			setNodeTree();
		}

		/**
		 * Node TreeZbg܂B
		 * 
		 */
		public void setNodeTree() {
			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				NodeTreeGroup nodeTreeGroup = (NodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			groupMap.clear();

			DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
					.getInstance();
			ArrayList nodeList = null;

			try {
				nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
			} catch (SQLException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error ", e1
						.getMessage());
				logger.warning("Node List import error " + e1.getMessage());
				shell.dispose();
				e1.printStackTrace();

				return;
			} catch (Exception e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error ", e1
						.getMessage());
				logger.warning("Node List import error " + e1.getMessage());
				shell.dispose();
				e1.printStackTrace();

				return;
			} finally {
				nodeRegisterDBTable = null;
			}

			if (nodeList == null) {
				return;
			}

			if (nodeList.size() == 0) {
				nodeListTreeViewer.refresh();

				return;
			}

			for (int i = 0; i < nodeList.size(); i++) {
				NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);

				createNodeTree(nodeInfo, true);
			}

			setStatusLine(groupMap.size(), nodeList.size());
		}
	}

	/**
	 * HTTPT[om[hĎǂݍŁAm[hTree \^XNłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionReloadNodeTreeHttp extends AbstractNodeAction {
		/**
		 * ۂNode Tree\ẑ߂Ƀm[hēǂݍ݂^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
			setNodeTree();
		}

		/**
		 * Node TreeZbg܂B
		 * 
		 */
		public void setNodeTree() {
			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				NodeTreeGroup nodeTreeGroup = (NodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			groupMap.clear();

			/* uEUǂݍݏ󋵕\Xe[^XCj^[擾 */
			IWorkbench workbench = PlatformUI.getWorkbench();
			WorkbenchWindow workbenchWindow = (WorkbenchWindow) workbench
					.getActiveWorkbenchWindow();
			IActionBars bars = workbenchWindow.getActionBars();
			IStatusLineManager lineManager = bars.getStatusLineManager();
			IProgressMonitor monitor = lineManager.getProgressMonitor();

			monitor.beginTask("Reading ... " + " Node Tree ", 100);

			/*
			 * Webm[hĎC|[g
			 */
			NodeListImport netNodeInfoImport = new NodeListImport();

			try {
				ArrayList nodeInfoImportList = netNodeInfoImport
						.importNodeList();

				if (nodeInfoImportList.size() == 0) {
					nodeListTreeViewer.refresh();

					return;
				}

				nodeInfoListHttp.clear();

				for (int i = 0; i < nodeInfoImportList.size(); i++) {
					String[] nodeInfoArray = (String[]) nodeInfoImportList
							.get(i);

					// System.out.println("Node name : " + nodeInfoArray[0]);
					// System.out.println("Node IP : " + nodeInfoArray[1]);
					NodeInformation nodeInfo = new NodeInformation();
					nodeInfo
							.setIpaddress(nodeInfoArray[NodeListXmlParse.IPADDRESS_NUMBER]);
					nodeInfo
							.setNodename(nodeInfoArray[NodeListXmlParse.NODENAME_NUMBER]);
					nodeInfo
							.setGroup(nodeInfoArray[NodeListXmlParse.GROUP_NUMBER]);
					nodeInfo
							.setEngineAddress(nodeInfoArray[NodeListXmlParse.ENGINE_ADDRESS_NUMBER]);
					nodeInfo
							.setNodeKind(nodeInfoArray[NodeListXmlParse.NODEKIND_NUMBER]);

					createNodeTree(nodeInfo, true);
					nodeInfoListHttp.add(nodeInfo);
				}

				setStatusLine(groupMap.size(), nodeInfoImportList.size());
			} catch (HttpAccessException e) {
				logger.warning(e.getMessage());

				MessageBox alertMessageBox = new MessageBox(parentComposite
						.getShell(), SWT.YES | SWT.ICON_WARNING);

				alertMessageBox.setMessage(e.getMessage());
				alertMessageBox.open();

				e.printStackTrace();
			} catch (HttpAccessPreferenceException e) {
				logger.warning(e.getMessage());

				MessageBox alertMessageBox = new MessageBox(parentComposite
						.getShell(), SWT.YES | SWT.ICON_WARNING);

				alertMessageBox.setMessage(e.getMessage());
				alertMessageBox.open();

				e.printStackTrace();
			} finally {
				monitor.done();
			}
		}
	}

	/**
	 * lbg[NoRŃm[hĎǂݍŁAm[hTree\ ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionReloadNodeTreeSocket extends AbstractNodeAction {
		/**
		 * f[^x[Xm[hĎǂݍŁAm[hTree \^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
			setNodeTree();
		}

		/**
		 * Node TreeZbg܂B
		 * 
		 */
		public void setNodeTree() {
			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				NodeTreeGroup nodeTreeGroup = (NodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			groupMap.clear();

			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
					engineAddress);

			try {
				ArrayList nodeList = connectNodeInfo.getNodeInformationList(
						null, null);

				String[] nodeIPAddress = new String[nodeList.size()];
				String[] nodeName = new String[nodeList.size()];

				if (nodeList.size() == 0) {
					nodeListTreeViewer.refresh();

					return;
				}

				nodeInfoListSocket.clear();

				for (int i = 0; i < nodeList.size(); i++) {
					NodeInformation nodeInfo = (NodeInformation) nodeList
							.get(i);

					createNodeTree(nodeInfo, true);
					nodeInfoListSocket.add(nodeInfo);
					nodeIPAddress[i] = nodeInfo.getIpaddress();
					nodeName[i] = nodeInfo.getNodename();
				}

				setStatusLine(groupMap.size(), nodeList.size());
			} catch (EngineConnectException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e
						.getMessage());
				logger.warning("Node List import error" + e.getMessage());
				shell.dispose();
				e.printStackTrace();
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e
						.getMessage());
				logger.warning("Node List import error" + e.getMessage());
				shell.dispose();
				e.printStackTrace();
			}
		}
	}

	/**
	 * m[h\[gANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractNodeSortAction extends AbstractNodeAction {
		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry(MenuPreference.NODE_TREE_SORT_IMAGE_FILE));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return MenuPreference.NODE_TREE_SORT;
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return MenuPreference.NODE_TREE_SORT_TOOL_TIP;
		}
	}

	/**
	 * m[hTree\[gANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ActionSortNodeTreeDatabase extends
			AbstractNodeSortAction {
		private String sortColumn0 = DBTableNodeRegister.NODEGROUP;

		private String sortDirection0 = "asc";

		private String sortColumn1 = DBTableNodeRegister.NODENAME;

		private String sortDirection1 = "asc";

		private boolean isSortToggle = true;

		/**
		 * Node TreeSort^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
			if (isSortToggle) {
				sortDirection0 = "asc";
				sortDirection1 = "asc";
				isSortToggle = false;
			} else {
				sortDirection0 = "desc";
				sortDirection1 = "desc";
				isSortToggle = true;
			}

			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				NodeTreeGroup nodeTreeGroup = (NodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					if (node instanceof NodeTreeGroup) {
						parentNodeTreeGroup = (NodeTreeGroup) node;
					}

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();
			setNodeTree();
		}

		/**
		 * Node TreeZbg܂B
		 * 
		 */
		protected void setNodeTree() {
			/* f[^x[Xm[hĎ񃊃Xg擾 */
			DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
					.getInstance();
			ArrayList nodeList = null;

			try {
				nodeList = nodeRegisterDBTable.getNodeInfoList(sortColumn0,
						sortDirection0, sortColumn1, sortDirection1);
			} catch (SQLException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e1
						.getMessage());
				logger.warning("Node List import error" + e1.getMessage());
				shell.dispose();
				e1.printStackTrace();

				return;
			} catch (Exception e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e1
						.getMessage());
				logger.warning("Node List import error" + e1.getMessage());
				shell.dispose();
				e1.printStackTrace();

				return;
			} finally {
				nodeRegisterDBTable = null;
			}

			if (nodeList == null) {
				return;
			}

			for (int i = 0; i < nodeList.size(); i++) {
				NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);

				createNodeTree(nodeInfo, isSortToggle);
			}
		}
	}

	/**
	 * m[hTree\[gANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ActionSortNodeTreeHttp extends AbstractNodeSortAction {
		private boolean isSortToggle = true;

		/**
		 * Node TreeSort^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
			if (isSortToggle) {
				isSortToggle = false;
			} else {
				isSortToggle = true;
			}

			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				NodeTreeGroup nodeTreeGroup = (NodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					if (node instanceof NodeTreeGroup) {
						parentNodeTreeGroup = (NodeTreeGroup) node;
					}

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();

			for (int i = 0; i < nodeInfoListHttp.size(); i++) {
				NodeInformation nodeInfo = (NodeInformation) nodeInfoListHttp
						.get(i);
				createNodeTree(nodeInfo, isSortToggle);
			}
		}
	}

	/**
	 * lbg[NoRŃm[hTree\[gANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ActionSortNodeTreeSocket extends
			AbstractNodeSortAction {
		private boolean isSortToggle = true;

		/**
		 * Node TreeSort^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
			if (isSortToggle) {
				isSortToggle = false;
			} else {
				isSortToggle = true;
			}

			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				NodeTreeGroup nodeTreeGroup = (NodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					if (node instanceof NodeTreeGroup) {
						parentNodeTreeGroup = (NodeTreeGroup) node;
					}

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();

			for (int i = 0; i < nodeInfoListSocket.size(); i++) {
				NodeInformation nodeInfo = (NodeInformation) nodeInfoListSocket
						.get(i);
				createNodeTree(nodeInfo, isSortToggle);
			}
		}
	}
}
