/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.action;

import java.util.logging.Logger;

import netjfwatcher.birt.gui.editorparts.NodeSnmpReportEditorView;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * m[hSNMPɊւ郌|[gANV`NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderSnmpReport extends Action {
	/* MO */
	private static Logger logger;



	/* m[hSNMP(System MIByInterface MIB)\ANV */
	private IAction snmpInfoShowAction = new ActionNodeSnmpReportView();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetWatcherRCPBirtPlugin.getInstance()
			.getBundle();

	/**
	 * m[hSNMPɊւ郌|[gANVNX
	 * CX^X ܂B
	 * 
	 */
	public ActionBuilderSnmpReport() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * m[hSNMP(System MIByInterface MIB)\ANVԂ܂B
	 * 
	 * @return snmpInfoShowAction m[hSNMP(System MIByInterface MIB)
	 *  \ANV
	 */
	public IAction getActionSnmpInfoReport() {
		return snmpInfoShowAction;
	}

	/**
	 * SnmpvɊւANV`钊ۃNXłB
	 * 
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractSnmpAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANVs^XNłB
		 * 
		 */
		protected abstract void doTask();
	}

	/**
	 * m[hSNMP View\sANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionNodeSnmpReportView extends AbstractSnmpAction {
		private NodeInformation nodeInfo;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry(ActionPreference.NODE_SNMP_REPORT_IMAGE_FILE));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return ActionPreference.NODE_SNMP_REPORT_TEXT;
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return ActionPreference.NODE_SNMP_REPORT_TOOL_TIP;
		}

		/**
		 * Node SNMP View\^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			/* Tree\NodeZbg */
			String nodeName = nodeInfo.getNodename() + "("
					+ nodeInfo.getIpaddress() + ")";

			try {
				activePage.openEditor(new EditorInputNodeView(nodeName
						+ " SNMP report", nodeInfo, false),
						NodeSnmpReportEditorView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		/**
		 * m[hĎZbg܂B
		 * 
		 * @param nodeInfo m[hĎ
		 */
		public void setNodeInfo(NodeInformation nodeInfo) {
			this.nodeInfo = nodeInfo;
		}
	}

}
