package netjfwatcher.birt.action;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.birt.report.viewer.utilities.WebappAccessor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PreviewBirtAction implements IWorkbenchWindowActionDelegate {

	private IWorkbenchWindow window;

	private String reportName;

	private Browser browser;

	/**
	 * The constructor.
	 */
	public PreviewBirtAction() {
	}

	public void setReportName(String report) {
		reportName = report;
	}

	public void setBrowser(Browser brw) {
		browser = brw;
	}

	public void run(IAction action) {
		try {
			System.setProperty("RUN_UNDER_ECLIPSE", "true");
			WebViewer.display(reportName, WebViewer.HTML, browser, "run");
			// WebViewer.display("C:/IANA/2005/Birt/RCP/testBirt/testSampleDB.rptdesign",
			// WebViewer.HTML,false);
		} catch (Exception e) {
			// logger.error(e);
			e.printStackTrace();
		}

	}

	public void run() {
		try {

			// option 1 display with no parameters in url. Parameter box will
			// display if
			// required in a seperate window. This uses the /run mapping
			// WebViewer.display(reportName , WebViewer.HTML, false);

			// option 2 display BIRT Viewer in sepearate Browser with /frameset
			// mapping
			// WebViewer.display(reportName , WebViewer.HTML, true);

			// option 3 display in SWT Browser using /frameset mapping.
			// WebViewer.display(reportName, WebViewer.HTML, browser,
			// "frameset");

			// option 4 display in SWT Browser using /run mapping.
			WebViewer.display(reportName, WebViewer.HTML, browser, "run");

			// option 5 display with parameters encoded in the URL
			// - Note this required adding additional functions
			// Use the TopNPercent.rptdesign with this example
			// WebViewer.startup(null);
			// String format = "html";
			// String preParameters = createURL( "run", reportName, format );
			// Make sure to encode your parameters
			// String parm1NameString = URLEncoder.encode( "Top Count", "utf-8"
			// );
			// String parm1ValueString = URLEncoder.encode( "5", "utf-8" );
			// String parm2NameString = URLEncoder.encode( "Top Percentage",
			// "utf-8" );
			// String parm2ValueString = URLEncoder.encode( "25", "utf-8" );
			// String finalUrl = preParameters + "&" + parm1NameString + "=" +
			// parm1ValueString;
			// finalUrl += "&" + parm2NameString + "=" + parm2ValueString;
			// browser.setUrl( finalUrl );

		} catch (Exception e) {
			// logger.error(e);
			e.printStackTrace();
		}

	}

	/**
	 * Selection in the workbench has been changed. We can change the state of
	 * the 'real' action here if we want, but this can only happen after the
	 * delegate has been created.
	 * 
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system resources we previously
	 * allocated.
	 * 
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to be able to provide parent shell
	 * for the message dialog.
	 * 
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	private static String createURL(String servletName, String report,
			String format) {
		String encodedReportName = null;
		String encodedDocumentName = null;

		try {
			encodedReportName = URLEncoder.encode(report, "utf-8"); //$NON-NLS-1$
		} catch (UnsupportedEncodingException e) {
			// Do nothing
		}

		if (encodedReportName != null && encodedReportName.length() > 0) {
			encodedDocumentName = encodedReportName.substring(0,
					encodedReportName.lastIndexOf(".")) + ".rptdocument"; //$NON-NLS-1$
		}

		String locale = ViewerPlugin.getDefault().getPluginPreferences()
				.getString(WebViewer.USER_LOCALE);

		String svgFlag = ViewerPlugin.getDefault().getPluginPreferences()
				.getString(WebViewer.SVG_FLAG);
		boolean bSVGFlag = false;
		if ("true".equalsIgnoreCase(svgFlag)) //$NON-NLS-1$
		{
			bSVGFlag = true;
		}

		String masterPageContent = ViewerPlugin.getDefault()
				.getPluginPreferences()
				.getString(WebViewer.MASTER_PAGE_CONTENT);
		boolean bMasterPageContent = true;
		if ("false".equalsIgnoreCase(masterPageContent)) //$NON-NLS-1$
		{
			bMasterPageContent = false;
		}

		// So far, only report name is encoded as utf-8 format
		return getBaseURL()
				+ servletName
				+ "?" //$NON-NLS-1$
				+ "__report=" + encodedReportName //$NON-NLS-1$
				+ ("run".equalsIgnoreCase(servletName) ? "" : "&__document=" + encodedDocumentName) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				+ "&__format=" + format //$NON-NLS-1$
				+ "&__svg=" + String.valueOf(bSVGFlag) //$NON-NLS-1$
				+ (WebViewer.LocaleTable.containsKey(locale) ? "&__locale=" + WebViewer.LocaleTable.get(locale) : "") //$NON-NLS-1$ //$NON-NLS-2$
				+ "&__designer=true" //$NON-NLS-1$
				+ "&__masterpage=" + String.valueOf(bMasterPageContent); //$NON-NLS-1$

	}

	private static String getBaseURL() {
		return "http://" + WebappAccessor.getHost() + ":" //$NON-NLS-1$ //$NON-NLS-2$
				+ WebappAccessor.getPort() + "/viewer/"; //$NON-NLS-1$
	}
}