/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.action;

import java.util.logging.Logger;

import netjfwatcher.birt.gui.editorparts.ReportEngineSetReportLocationEditorView;
import netjfwatcher.birt.gui.editorparts.PreviewBirtViewer;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;


/**
 * |[gGWEditor ViewOpenNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ReportEngineEditorViewOpenAction {
    /* MO */
    private static Logger logger = null;

    private ReportEngineEditorViewOpenAction() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void openPreviewBirtViewer() {
        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            activePage.openEditor(
                new EditorInputNodeView("Preview Birt Viewer", false),
                PreviewBirtViewer.class.getName());
        } catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

    }

    public void openReportEngineEditorView() {
        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            activePage.openEditor(
                new EditorInputNodeView("Report Engine Editor Viewer", false),
                ReportEngineSetReportLocationEditorView.class.getName());
        } catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
    
    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ReportEngineEditorViewOpenAction getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ReportEngineEditorViewOpenAction RESOURCE =
            new ReportEngineEditorViewOpenAction();
    }
}
