/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.gui;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.birt.action.ActionBuilderNodeDataReport;
import netjfwatcher.birt.action.ActionBuilderNodeDataReport.ActionPingResponseDataReport;
import netjfwatcher.birt.action.ActionBuilderNodeDataReport.ActionPingResponseGraphReport;
import netjfwatcher.birt.preference.NetWatcherRCPBirtPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingChart;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingTable;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;

/**
 * j[}l[W⃁j[Ƀm[hPingĎj[ǉ \bhNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodePingReportMenu {
	/* MO */
	private static Logger logger;

	/* 摜肷邽߂PluginResource bundle */
	private Bundle bundle;

	/* Pingf[^Chart(Ot)`ANV Image */
	private Image chartImage;

	/* Pingf[^e[u\ANV Image */
	private Image tableImage;

	/* Pingf[^Ot/e[u\ANVr_[ */
	private ActionBuilderNodeDataReport dataTableReportAction = new ActionBuilderNodeDataReport();

	/**
	 * m[hPingĎ֘Aj[𐶐NXCX^X𐶐܂B
	 * 
	 */
	public NodePingReportMenu() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * wMenuManagerɃm[hPingj[ǉ܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 * @param targetNodeInfo
	 *            m[hĎ
	 * @param isSocket
	 *            SocketoRŏ擾邩ۂtO
	 */
	public void createPingMenu(IMenuManager manager,
			NodeInformation targetNodeInfo, boolean isSocket) {
		/* Menu}l[Wɐ */
		MenuManager optionMenu = new MenuManager(
				MenuPreference.NODE_PING_RESPONSE_DATA);
		manager.add(optionMenu);
		optionMenu.add(new Separator());

		String title = targetNodeInfo.getNodename() + "("
				+ targetNodeInfo.getIpaddress() + ") " + "Ping "
				+ AbstractEditorNodeChart.TITLE_SUFFIX;
		ArrayList nameList = new ArrayList();
		nameList.add(targetNodeInfo.getNodename() + "("
				+ targetNodeInfo.getIpaddress() + ")");

		/*
		 * Pingf[^e[u\ANV
		 */
		ActionPingResponseDataReport pingDataTableAction = ((ActionPingResponseDataReport) dataTableReportAction
				.actionPingDataReportView());
		pingDataTableAction.setNodeInfo(targetNodeInfo);
		optionMenu.add(pingDataTableAction);

		/*
		 * Pingf[^Ot\ANV
		 */
		ActionPingResponseGraphReport pingGraphAction = ((ActionPingResponseGraphReport) dataTableReportAction
				.actionPingGraphReportView());
		pingGraphAction.setNodeInfo(targetNodeInfo);
		optionMenu.add(pingGraphAction);

	}

	/**
	 * wMenuɃm[hPingj[ǉ܂B m[hMap ViewPopupj[Pingj[ǉ܂B
	 * 
	 * @param popUpMenu
	 *            Menu
	 * @param targetNodeInfo
	 *            m[hĎ
	 * @param isSocket
	 *            SocketoRŏ񂗂擾邩ۂtO
	 */
	public void createPingMenu(Menu popUpMenu, NodeInformation targetNodeInfo,
			boolean isSocket) {
		MenuItem pingMenuItem = new MenuItem(popUpMenu, SWT.CASCADE);

		/* 摜肷邽߂PluginResource bundle */
		bundle = NetWatcherRCPBirtPlugin.getInstance().getBundle();

		ImageDescriptor chartImageDescriptor = ImageDescriptor
				.createFromURL(bundle.getEntry(MenuPreference.CHART_IMAGE_FILE));
		ImageDescriptor tableImageDescriptor = ImageDescriptor
				.createFromURL(bundle.getEntry(MenuPreference.TABLE_IMAGE_FILE));

		if (chartImage == null) {
			chartImage = chartImageDescriptor.createImage();
		}

		if (tableImage == null) {
			tableImage = tableImageDescriptor.createImage();
		}

		pingMenuItem.setText(MenuPreference.NODE_PING_RESPONSE_DATA);

		Menu pingSubmenu = new Menu(pingMenuItem);
		pingMenuItem.setMenu(pingSubmenu);

		/*
		 * Pingf[^Ot\ANV
		 */
		String title = targetNodeInfo.getNodename() + "("
				+ targetNodeInfo.getIpaddress() + ") " + "Ping ";

		MenuItem subMenuItemPingTable = new MenuItem(pingSubmenu, SWT.PUSH);
		subMenuItemPingTable.setText(title + " Table");
		subMenuItemPingTable.setImage(tableImage);

		// menuItem1_1.setImage(tableImage);
		NodeMapMenuNodePingTable nodePingTable = new NodeMapMenuNodePingTable(
				targetNodeInfo, isSocket);
		subMenuItemPingTable.addSelectionListener(nodePingTable);

		MenuItem subMenuItemPingChart = new MenuItem(pingSubmenu, SWT.PUSH);
		subMenuItemPingChart.setText(title + " Chart");
		subMenuItemPingChart.setImage(chartImage);

		ArrayList nameList = new ArrayList();
		nameList.add(targetNodeInfo.getNodename() + "("
				+ targetNodeInfo.getIpaddress() + ")");

		NodeMapMenuNodePingChart nodePingChart = new NodeMapMenuNodePingChart(
				targetNodeInfo, isSocket, nameList);
		subMenuItemPingChart.addSelectionListener(nodePingChart);
	}

	/**
	 * Imagej܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (chartImage != null) {
			chartImage.dispose();
		}

		if (tableImage != null) {
			tableImage.dispose();
		}
	}
}
