/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.gui;

import javax.xml.parsers.FactoryConfigurationError;

import org.apache.log4j.BasicConfigurator;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * m[h}l[WPerspectiveNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeReportPerspective implements IPerspectiveFactory {
	private static final float NODE_TREE_RATIO = 0.20f;

	private static final float NODE_LIST_RATIO = 0.40f;

	/**
	 * PerspectivȅCAEgs܂B
	 * 
	 * @param layout
	 *            IPageLayout
	 */
	public void createInitialLayout(IPageLayout layout) {
		layout.setEditorAreaVisible(false);

		String editorArea = layout.getEditorArea();

		/* PerspectiveɃm[hTree */
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT,
				NODE_TREE_RATIO, editorArea);
		left.addView(NodeTreeReportView.class.getName());

		/* Perspective㑤Ƀm[hListƃm[hMap */
		/*
		 * IFolderLayout top = layout.createFolder( "top", IPageLayout.TOP,
		 * NODE_LIST_RATIO, editorArea);
		 * top.addView(NodeListTableView.class.getName());
		 * top.addView(NodeMapView.class.getName());
		 */

		initLog4j();
	}

	private void initLog4j() throws FactoryConfigurationError {
		// PreferenceStore`t@CƂĂēǂݍ
		BasicConfigurator.configure();
	}
}
