/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.gui;

import java.util.logging.Logger;

import javax.xml.parsers.FactoryConfigurationError;

import netjfwatcher.birt.action.ActionBuilderAlarmReport;
import netjfwatcher.birt.action.ActionBuilderNodeListReport;
import netjfwatcher.birt.action.ActionBuilderSnmpReport;
import netjfwatcher.birt.action.ListenerNodeTreeReport;
import netjfwatcher.birt.action.ActionBuilderAlarmReport.ActionNodeAlarmReport;
import netjfwatcher.birt.action.ActionBuilderSnmpReport.ActionNodeSnmpReportView;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;

import org.apache.log4j.BasicConfigurator;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;

/**
 * m[h Report Tree\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeTreeReportView extends AbstractNodeTreeReportView {
	/* MO */
	private static Logger logger = null;

	private ActionBuilderNodeListReport nodeListAction = new ActionBuilderNodeListReport();

	/** A[Ɋւ郌|[gANV */
	protected ActionBuilderAlarmReport actinAlarm = new ActionBuilderAlarmReport();

	/* m[hSnmp֘ÃANV */
	private ActionBuilderSnmpReport snmpReportAction = new ActionBuilderSnmpReport();

	/* SNMPv\j[ */
	private NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu = new NodeSnmpStatisticsMenu();

	/* Pingf[^\j[ */
	private NodePingReportMenu nodePingReportMenu = new NodePingReportMenu();

	/**
	 * m[hTree\ViewNXCX^X𐶐܂B
	 * 
	 */
	public NodeTreeReportView() {
		logger = Logger.getLogger(this.getClass().getName());
		initLog4j();
	}

	private void initLog4j() throws FactoryConfigurationError {
		// PreferenceStore`t@CƂĂēǂݍ
		BasicConfigurator.configure();
	}

	/**
	 * f[^x[Xm[hĎ񃊃XgǂݍTree\ ܂B
	 * 
	 */
	protected void initShow() {
		/*
		 * ((ActionReloadNodeTreeDatabase) actionNodeTree.
		 * actionReloadNodeTreeDatabase()).setNodeTree();
		 */
	}

	/**
	 * ReLXgj[𐶐܂B
	 * 
	 */
	public void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		Menu menu = mm.createContextMenu(nodeListTreeViewer.getControl());
		nodeListTreeViewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, nodeListTreeViewer);
	}

	/**
	 * ANV̏ƂToolBarݒ肵܂B
	 * 
	 */
	protected void setToolBarActions() {
		/* ToolBarݒ */
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		/* m[hTreeēǍANV */
		toolBarManager.add(getActionNodeTreeBuilder()
				.actionReloadNodeTreeDatabase());
		toolBarManager.add(getActionNodeTreeBuilder()
				.actionSortNodeTreeDatabase());
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/**
	 * j[o[ݒ肵܂B preWindowOpenɌĂ΂܂B m[hTreẽm[hIĂꍇƑIĂȂꍇ
	 * j[ς܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* m[hTreeǂݍ݃ANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* m[hTreeēǂݍ */
		manager.add(getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());

		/* m[hTree\[g */
		manager.add(getActionNodeTreeBuilder().actionSortNodeTreeDatabase());
		/* m[hXg |[g */
		manager.add(nodeListAction.getActionNodeListTableReport());
		/*
		 * Treẽm[hIĂ邩`FbN
		 */
		if (nodeListTreeViewer.getTree().getSelection() != null) {
			TreeItem[] treeItem = nodeListTreeViewer.getTree().getSelection();

			if ((treeItem != null) && (treeItem.length > 0)) {
				for (int nodeTreeSelectNo = 0; nodeTreeSelectNo < treeItem.length; nodeTreeSelectNo++) {
					if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
						/* GroupI */
						nodeListTreeViewer.getTree().deselectAll();
					} else if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTree) {
						NodeInformation targetNodeInfo = ((NodeTree) treeItem[nodeTreeSelectNo]
								.getData()).getNodeInfo();

						/* m[hAlarmj[ǉ */
						((ActionNodeAlarmReport) actinAlarm
								.getActionEditorPartNodeAlarmReport())
								.setNodeInfo(targetNodeInfo);
						manager.add(actinAlarm
								.getActionEditorPartNodeAlarmReport());

						/* m[hSNMP\j[ǉ */
						((ActionNodeSnmpReportView) snmpReportAction
								.getActionSnmpInfoReport())
								.setNodeInfo(targetNodeInfo);
						manager.add(snmpReportAction.getActionSnmpInfoReport());

						/*
						 * m[hPingf[^j[j[}l[W ǉ
						 */
						nodePingReportMenu.createPingMenu(manager,
								targetNodeInfo, false);

					} else {
						/* Groupłm[hłȂ */
						nodeListTreeViewer.getTree().deselectAll();
					}
				}
			}
		}

		/* Sm[hAlarmr[\ */
		manager.add(actinAlarm.getActionAllNodeAlarmListTableReport());

	}

	/**
	 * m[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		nodeListTreeViewer
				.addSelectionChangedListener(new ListenerNodeTreeReport(false));
	}
}
