package netjfwatcher.birt.gui.editorparts;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.birt.model.ReportEngineFactory;
import netjfwatcher.birt.preference.ReportDesignConfig;
import netjfwatcher.birt.preference.ReportDesignFilePreference;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
/**
 * Editor Partsւ̃|[g\yHTML/PDFo͂sۃNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractReportEditorView extends AbstractEditorNodeView {
	/* MO */
	private static Logger logger;

	protected Browser browser;

	protected ProgressBar progressBar;

	protected transient Text reportLocationText = null;

	protected transient Button browseFolderButton = null;

	protected Button showReportButton;

	protected Button htmlOutputButton;

	protected Button pdfOutputButton;

	/* Text BackColor */
	protected Color textBackColor;

	/* m[hĎ */
	protected NodeInformation targetNodeInfo;

	protected static final int HORIZONTAL_SPAN4 = 4;

	protected static final int HORIZONTAL_SPAN3 = 3;

	protected static final String PREVIEW_TITLE = "Preview";

	protected static final String HTML_OUT_TITLE = "HTML output";

	protected static final String PDF_OUT_TITLE = "PDF output";

	protected static final int PREVIEW = 0;

	protected static final int HTML_OUT = 1;

	protected static final int PDF_OUT = 2;

	protected static final String ASTALISK = "*";

	protected static final String HTML_FILE_EXT = ".html";

	protected static final String PDF_FILE_EXT = ".pdf";

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public AbstractReportEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		/* ͐ݒlm[hĎ擾 */
		setEditorInput();

		parent.setLayout(new GridLayout());
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);

		Group reportGroup = new Group(parent, SWT.SHADOW_IN);
		reportGroup.setText("Select report:");
		GridLayout layout = new GridLayout(HORIZONTAL_SPAN4, false);
		reportGroup.setLayout(layout);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		reportGroup.setLayoutData(gd);

		gd = new GridData();
		gd.horizontalSpan = HORIZONTAL_SPAN4;
		/*
		 * Label label = new Label(reportGroup, SWT.NONE); label.setText("Full
		 * Path:"); label.setLayoutData(gd); reportLocationText = new
		 * Text(reportGroup, SWT.BORDER); gd = new
		 * GridData(GridData.FILL_HORIZONTAL); gd.horizontalSpan =
		 * HORIZONTAL_SPAN3; gd.verticalSpan = 1;
		 * reportLocationText.setLayoutData(gd); // setPageComplete(false);
		 * 
		 * browseFolderButton = new Button(reportGroup, SWT.RIGHT);
		 * browseFolderButton.setText("..."); //$NON-NLS-1$
		 */

		showReportButton = new Button(reportGroup, SWT.PUSH);
		showReportButton.setText(PREVIEW_TITLE);
		htmlOutputButton = new Button(reportGroup, SWT.PUSH);
		htmlOutputButton.setText(HTML_OUT_TITLE);
		pdfOutputButton = new Button(reportGroup, SWT.PUSH);
		pdfOutputButton.setText(PDF_OUT_TITLE);

		browser = new Browser(parent, SWT.NONE);
		gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = HORIZONTAL_SPAN4;
		browser.setLayoutData(gd);

		gd = new GridData(GridData.END, GridData.CENTER, false, false);
		// gd = new GridData( GridData.FILL_BOTH );
		gd.heightHint = 10;
		gd.widthHint = 100;
		progressBar = new ProgressBar(parent, SWT.INDETERMINATE);
		progressBar.setLayoutData(gd);
		progressBar.setVisible(false);

		setListener();

	}

	protected void setListener() {
		if (reportLocationText != null) {
			reportLocationText.addModifyListener(new ModifyListener() {

				public void modifyText(ModifyEvent e) {
					//
				}

			});
		}
		if (browseFolderButton != null) {
			browseFolderButton.addSelectionListener(new SelectionAdapter() {

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.swt.events.
				 *      SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
				 */
				public void widgetSelected(SelectionEvent e) {
					setButtonEnable(false);
					FileDialog dialog = new FileDialog(reportLocationText
							.getShell());
					String[] extension = { "*.rptdesign" };
					dialog.setFilterExtensions(extension);
					if (reportLocationText.getText() != null
							&& reportLocationText.getText().trim().length() > 0) {

						dialog.setFilterPath(reportLocationText.getText());

					}

					String selectedLocation = dialog.open();
					if (selectedLocation != null) {
						reportLocationText.setText(selectedLocation);
					}
					setButtonEnable(true);
				}

			});
		}
		if (browser != null) {
			browser.addLocationListener(new LocationAdapter() {

				public void changed(final LocationEvent e) {
					progressBar.setVisible(false);
				}

				public void changing(final LocationEvent e) {
					progressBar.setVisible(true);
				}
			});
		}
		showReportButton.addSelectionListener(new SelectionListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {

				setPreView();

				// addReportParameters(lParent, gridData);
				// openReportRunner();

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});
		htmlOutputButton.addSelectionListener(new SelectionListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				progressBar.setVisible(true);
				setButtonEnable(false);
				try {

					setReportFile(HTML_OUT);
				} catch (Exception exp) {
					exp.printStackTrace();
					MessageDialog.openError(getSite().getShell(),
							"Abort output HTML", exp.getMessage());
				} finally {
					setButtonEnable(true);
					progressBar.setVisible(false);
				}

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});

		pdfOutputButton.addSelectionListener(new SelectionListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				progressBar.setVisible(true);
				setButtonEnable(false);
				try {

					setReportFile(PDF_OUT);
				} catch (Exception exp) {
					exp.printStackTrace();
					MessageDialog.openError(getSite().getShell(),
							"Abort output PDF", exp.getMessage());

				} finally {
					setButtonEnable(true);
					progressBar.setVisible(false);
				}

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});

	}

	protected void setPreView() {
		setButtonEnable(false);
		progressBar.setVisible(true);

		BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
				new Runnable() {
					public void run() {
						try {
							setReportFile(PREVIEW);
						} catch (Exception exp) {
							progressBar.setVisible(false);
							exp.printStackTrace();
							MessageDialog.openError(getSite().getShell(),
									"Abort preview Report", exp.getMessage());
						} finally {
							setButtonEnable(true);
						}
					}
				});
	}

	protected void setButtonEnable(boolean isEnable) {
		if (browseFolderButton != null) {
			browseFolderButton.setEnabled(isEnable);
		}
		showReportButton.setEnabled(isEnable);
		htmlOutputButton.setEnabled(isEnable);
		pdfOutputButton.setEnabled(isEnable);
	}

	protected void setEditorInput() {
		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();
	}

	protected void setReportFile(int selectNo) throws EngineException,
			FileNotFoundException, IOException, Exception {
		String reportFileName = getReportDesignFile(ReportDesignFilePreference.NODE_SNMP_REPORT_DESIGN);

		String outputFileRenderOption = "";
		if (selectNo != PREVIEW) {

			String fileName = "nodelist";
			String fileExt = "";
			switch (selectNo) {
			case HTML_OUT:
				fileExt = "*.html";
				fileName = fileName + ".html";
				break;
			case PDF_OUT:
				fileExt = "*.pdf";
				fileName = fileName + ".pdf";
				break;
			default:
				break;
			}

			outputFileRenderOption = setOutputFileDialog(fileName, fileExt);
		}

		previewReport(selectNo, reportFileName, outputFileRenderOption);
	}

	protected String setOutputFileDialog(String fileName, String fileExtName) {
		FileDialog openDialog = new FileDialog(getEditorSite().getShell(),
				SWT.OPEN);
		String[] fileExt = new String[1];
		fileExt[0] = fileExtName;
		openDialog.setFileName(fileName);
		openDialog.setFilterExtensions(fileExt);
		openDialog.setFilterPath(ReportDesignFilePreference.OUTPUT_FILE_PATH);

		String openFileName = openDialog.open();

		if (openFileName != null) {

		}
		return openFileName;
	}

	protected void previewReport(int selectNo, String reportFileName,
			String outpurFileRenderOption) throws EngineException,
			FileNotFoundException, IOException, Exception {

		IReportEngine engine = ReportEngineFactory.getInstance()
				.createReportEngine();

		IReportRunnable design = null;
		IRunAndRenderTask task = null;
		FileInputStream fs = null;
		ByteArrayOutputStream bos = null;
		try {
			// Open a report design - use design to modify design, retrieve
			fs = new FileInputStream(reportFileName);
			design = engine.openReportDesign(fs);

			setDataSource(design);
			serDataSet(design);

			task = engine.createRunAndRenderTask(design);

			if (selectNo != PDF_OUT) {
				// Set Render context to handle url and image locataions
				HTMLRenderContext renderContext = new HTMLRenderContext();
				// renderContext.setImageDirectory("./");
				renderContext
						.setImageDirectory(ReportDesignFilePreference.IMAGE_DIR);
				HashMap<String, HTMLRenderContext> contextMap = new HashMap<String, HTMLRenderContext>();
				contextMap.put(EngineConstants.APPCONTEXT_HTML_RENDER_CONTEXT,
						renderContext);
				task.setAppContext(contextMap);
			} else {
				PDFRenderContext renderContext = new PDFRenderContext();

				HashMap<String, PDFRenderContext> contextMap = new HashMap<String, PDFRenderContext>();
				contextMap.put(EngineConstants.APPCONTEXT_PDF_RENDER_CONTEXT,
						renderContext);
				task.setAppContext(contextMap);
			}

			bos = new ByteArrayOutputStream();
			// Set rendering options - such as file or stream output,
			// output format, whether it is embeddable, etc
			outPutTask(task, selectNo, bos, outpurFileRenderOption);

			if (task != null) {
				// run the report and destroy the engine
				task.run();
				task.close();
				task = null;
			}

			if (selectNo == PREVIEW) {
				// set Browser text accordingly
				browser.setText(bos.toString());
			}
		} catch (EngineException e) {
			throw e;
		} catch (FileNotFoundException e) {
			throw new FileNotFoundException(reportFileName + " "
					+ e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {

			if (task != null) {

				task.close();

			}

			if (fs != null) {
				try {
					fs.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			if (bos != null) {
				try {
					bos.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}

	}

	protected String getReportDesignFile(String fileName)
			throws EngineException, FileNotFoundException, IOException,
			Exception {
		String filePath = "";
		if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
				AbstractDataAccessObject.DERBY)
				|| DatabaseAccessControlKind.getInstance().getDatabaseName()
						.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			filePath = ReportDesignFilePreference.RPT_DESIGN_DIR
					+ ReportDesignFilePreference.DERBY_DIR + "derby_"
					+ fileName;
		} else {
			filePath = ReportDesignFilePreference.RPT_DESIGN_DIR + fileName;
		}
		String file = "."
				+ ReportDesignConfig.getInstance().getDocument(filePath);
		return file;
	}

	protected void outPutTask(IRunAndRenderTask task, int select,
			ByteArrayOutputStream bos, String outpurFileRenderOption) {

		IRenderOption options;
		switch (select) {
		case PREVIEW:
			options = new HTMLRenderOption();

			options.setOutputStream(bos);
			options.setOutputFormat(HTMLRenderOption.OUTPUT_FORMAT_HTML);

			task.setRenderOption(options);
			break;
		case HTML_OUT:
			options = new HTMLRenderOption();
			options.setOutputFileName(outpurFileRenderOption);
			options.setOutputFormat(HTMLRenderOption.OUTPUT_FORMAT_HTML);
			task.setRenderOption(options);
			break;
		case PDF_OUT:

			options = new RenderOptionBase();
			options.setOutputFileName(outpurFileRenderOption);
			options.setOutputFormat(HTMLRenderOption.OUTPUT_FORMAT_PDF);
			// options.setOutputFormat("pdf");
			task.setRenderOption(options);
			break;
		default:
			logger.warning("Abort output");
			break;
		}

	}

	protected void setDataSource(IReportRunnable design)
			throws SemanticException {

		ResourceInfo info = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo();
		System.out.println("suf : " + AbstractDataAccessObject.DATABASE_URL);
		System.out.println("name : " + info.getDatabaseName());
		System.out.println("driver : " + info.getDatabaseDriver());
		System.out.println("url : " + info.getDatabaseUrl());
		System.out.println("user : " + info.getDatabaseUser());
		System.out.println("password : " + info.getDatabasePassword());

		String driver = info.getDatabaseDriver();
		String url = info.getDatabaseUrl()
				+ AbstractDataAccessObject.DATABASE_URL;
		String user = info.getDatabaseUser();
		String password = info.getDatabasePassword();

		List contents = design.getDesignHandle().getModuleHandle()
				.getAllDataSources();
		for (int i = 0; i < contents.size(); i++) {
			OdaDataSourceHandle dataSource = (OdaDataSourceHandle) contents
					.get(i);

			Object odaDriverClassObj = dataSource.getProperty("odaDriverClass");
			if (odaDriverClassObj != null) {
				dataSource.setProperty("odaDriverClass", driver);
			}

			Object odaURLObj = dataSource.getProperty("odaURL");
			if (odaURLObj != null) {
				dataSource.setProperty("odaURL", url);
			}

			Object odaUserObj = dataSource.getProperty("odaUser");
			if (odaUserObj != null) {
				if (user != null) {
					dataSource.setProperty("odaUser", user);
				} else {
					dataSource.setProperty("odaUser", "");
				}
			}

			Object odaPasswordObj = dataSource.getProperty("odaPassword");
			if (odaPasswordObj != null) {
				if (password != null) {
					dataSource.setProperty("odaPassword", password);
				} else {
					dataSource.setProperty("odaPassword", "");
				}
			}

			System.out.println("odaDriverClass "
					+ dataSource.getProperty("odaDriverClass"));
			System.out.println("odaURL " + dataSource.getProperty("odaURL"));
			System.out.println("odaUser " + dataSource.getProperty("odaUser"));
			System.out.println("odaPassword "
					+ dataSource.getProperty("odaPassword"));
		}

	}

	protected void serDataSet(IReportRunnable design) throws SemanticException {
		String ipAddress = null;
		if (targetNodeInfo != null) {
			ipAddress = targetNodeInfo.getIpaddress();
		}

		// design.set
		List contents2 = design.getDesignHandle().getModuleHandle()
				.getAllDataSets();
		for (int i = 0; i < contents2.size(); i++) {
			OdaDataSetHandle dataSet = (OdaDataSetHandle) contents2.get(i);

			System.out.println("getModule "
					+ design.getDesignHandle().getModule());

			System.out.println("queryText " + dataSet.getQueryText());

			if (ipAddress != null) {
				String sql = getSql(ipAddress, null, null);
				System.out.println("sql " + sql);
				if (sql != null && !sql.equals("")) {
					dataSet.setQueryText(sql);
				}
			}

		}

	}

	protected String getSql(String ipaddress, String startTime, String endTime) {
		return "";
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}
}
